/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdRange;
import org.neo4j.io.pagecache.context.CursorContext;

class ReadOnlyHighIdGenerator
implements IdGenerator {
    private final long highId;

    ReadOnlyHighIdGenerator(long highId) {
        this.highId = highId;
    }

    @Override
    public void setHighId(long id) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void markHighestWrittenAtHighId() {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public long getHighestWritten() {
        return this.highId;
    }

    @Override
    public long getHighId() {
        return this.highId;
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.highId - 1L;
    }

    @Override
    public IdGenerator.Marker marker(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void close() {
    }

    @Override
    public long getNumberOfIdsInUse() {
        return this.getHighId();
    }

    @Override
    public long getDefragCount() {
        return 0L;
    }

    @Override
    public void checkpoint(CursorContext cursorContext) {
    }

    @Override
    public void maintenance(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) {
    }

    @Override
    public long nextId(CursorContext ignored) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public IdRange nextIdBatch(int size, boolean forceConsecutiveAllocation, CursorContext ignored) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void clearCache(CursorContext cursorContext) {
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
        return true;
    }
}

