/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdRange;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.util.VisibleForTesting;

public interface IdGenerator
extends IdSequence,
Closeable,
ConsistencyCheckable {
    public static final Marker NOOP_MARKER = new Marker(){

        @Override
        public void markFree(long id) {
        }

        @Override
        public void markUsed(long id) {
        }

        @Override
        public void markDeleted(long id) {
        }

        @Override
        public void close() {
        }
    };

    public IdRange nextIdBatch(int var1, boolean var2, CursorContext var3);

    public void setHighId(long var1);

    public void markHighestWrittenAtHighId();

    @VisibleForTesting
    public long getHighestWritten();

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public Marker marker(CursorContext var1);

    @Override
    public void close();

    public long getNumberOfIdsInUse();

    public long getDefragCount();

    public void checkpoint(CursorContext var1);

    public void maintenance(boolean var1, CursorContext var2);

    public void start(FreeIds var1, CursorContext var2) throws IOException;

    public void clearCache(CursorContext var1);

    public static class Delegate
    implements IdGenerator {
        private final IdGenerator delegate;

        public Delegate(IdGenerator delegate) {
            this.delegate = delegate;
        }

        @Override
        public long nextId(CursorContext cursorContext) {
            return this.delegate.nextId(cursorContext);
        }

        @Override
        public IdRange nextIdBatch(int size, boolean forceConsecutiveAllocation, CursorContext cursorContext) {
            return this.delegate.nextIdBatch(size, forceConsecutiveAllocation, cursorContext);
        }

        @Override
        public void setHighId(long id) {
            this.delegate.setHighId(id);
        }

        @Override
        public void markHighestWrittenAtHighId() {
            this.delegate.markHighestWrittenAtHighId();
        }

        @Override
        public long getHighestWritten() {
            return this.delegate.getHighestWritten();
        }

        @Override
        public long getHighId() {
            return this.delegate.getHighId();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.delegate.getHighestPossibleIdInUse();
        }

        @Override
        public Marker marker(CursorContext cursorContext) {
            return this.delegate.marker(cursorContext);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public long getNumberOfIdsInUse() {
            return this.delegate.getNumberOfIdsInUse();
        }

        @Override
        public long getDefragCount() {
            return this.delegate.getDefragCount();
        }

        @Override
        public void checkpoint(CursorContext cursorContext) {
            this.delegate.checkpoint(cursorContext);
        }

        @Override
        public void maintenance(boolean awaitOngoing, CursorContext cursorContext) {
            this.delegate.maintenance(awaitOngoing, cursorContext);
        }

        @Override
        public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) throws IOException {
            this.delegate.start(freeIdsForRebuild, cursorContext);
        }

        @Override
        public void clearCache(CursorContext cursorContext) {
            this.delegate.clearCache(cursorContext);
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
            return this.delegate.consistencyCheck(reporterFactory, cursorContext);
        }
    }

    public static interface Marker
    extends AutoCloseable {
        public void markUsed(long var1);

        public void markDeleted(long var1);

        public void markFree(long var1);

        @Override
        public void close();
    }
}

