/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.id.indexed.LinkedChunkLongArray;
import org.neo4j.internal.id.indexed.MarkerProvider;
import org.neo4j.internal.id.indexed.ScanLock;
import org.neo4j.io.pagecache.context.CursorContext;

class FreeIdScanner
implements Closeable {
    private static final IdRangeKey LOW_KEY = new IdRangeKey(0L);
    private static final IdRangeKey HIGH_KEY = new IdRangeKey(Long.MAX_VALUE);
    private final int idsPerEntry;
    private final GBPTree<IdRangeKey, IdRange> tree;
    private final ConcurrentLongQueue cache;
    private final AtomicBoolean atLeastOneIdOnFreelist;
    private final MarkerProvider markerProvider;
    private final long generation;
    private final ScanLock lock;
    private final IndexedIdGenerator.Monitor monitor;
    private volatile Long ongoingScanRangeIndex;

    FreeIdScanner(int idsPerEntry, GBPTree<IdRangeKey, IdRange> tree, ConcurrentLongQueue cache, AtomicBoolean atLeastOneIdOnFreelist, MarkerProvider markerProvider, long generation, boolean strictlyPrioritizeFreelistOverHighId, IndexedIdGenerator.Monitor monitor) {
        this.idsPerEntry = idsPerEntry;
        this.tree = tree;
        this.cache = cache;
        this.atLeastOneIdOnFreelist = atLeastOneIdOnFreelist;
        this.markerProvider = markerProvider;
        this.generation = generation;
        this.lock = strictlyPrioritizeFreelistOverHighId ? ScanLock.lockyAndPessimistic() : ScanLock.lockFreeAndOptimistic();
        this.monitor = monitor;
    }

    boolean tryLoadFreeIdsIntoCache(boolean awaitOngoing, CursorContext cursorContext) {
        if (!this.hasMoreFreeIds()) {
            return false;
        }
        if (this.scanLock(awaitOngoing)) {
            try {
                LinkedChunkLongArray pendingItemsToCache;
                int maxItemsToCache = this.cache.capacity() - this.cache.size();
                if (maxItemsToCache > 0 && this.findSomeIdsToCache(pendingItemsToCache = new LinkedChunkLongArray(Integer.min(maxItemsToCache, Integer.max(256, this.cache.capacity() / 10))), maxItemsToCache, cursorContext)) {
                    this.markIdsAsReserved(pendingItemsToCache, cursorContext);
                    this.placeIdsInCache(pendingItemsToCache);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    boolean hasMoreFreeIds() {
        return this.ongoingScanRangeIndex != null || this.atLeastOneIdOnFreelist.get();
    }

    private boolean scanLock(boolean awaitOngoing) {
        if (awaitOngoing) {
            this.lock.lock();
            return true;
        }
        return this.lock.tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(CursorContext cursorContext) {
        this.lock.lock();
        try {
            this.ongoingScanRangeIndex = null;
            try (IndexedIdGenerator.ReservedMarker marker = this.markerProvider.getMarker(cursorContext);){
                long id;
                do {
                    if ((id = this.cache.takeOrDefault(-1L)) == -1L) continue;
                    marker.markUnreserved(id);
                } while (id != -1L);
            }
            this.atLeastOneIdOnFreelist.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void placeIdsInCache(LinkedChunkLongArray pendingItemsToCache) {
        pendingItemsToCache.accept(id -> {
            if (!this.cache.offer(id)) {
                throw new IllegalStateException("This really should not happen, we knew the max available space there were for caching ids and now the cache claims to have less than that?");
            }
            this.monitor.cached(id);
        });
    }

    private void markIdsAsReserved(LinkedChunkLongArray pendingItemsToCache, CursorContext cursorContext) {
        try (IndexedIdGenerator.ReservedMarker marker = this.markerProvider.getMarker(cursorContext);){
            pendingItemsToCache.accept(marker::markReserved);
        }
    }

    private boolean findSomeIdsToCache(LinkedChunkLongArray pendingItemsToCache, int maxItemsToCache, CursorContext cursorContext) throws IOException {
        boolean somethingWasCached;
        boolean startedNow = this.ongoingScanRangeIndex == null;
        IdRangeKey from = this.ongoingScanRangeIndex == null ? LOW_KEY : new IdRangeKey(this.ongoingScanRangeIndex);
        boolean seekerExhausted = false;
        IdRange.FreeIdVisitor visitor = id -> this.queueId(pendingItemsToCache, maxItemsToCache, id);
        try (Seeker scanner = this.tree.seek((Object)from, (Object)HIGH_KEY, cursorContext);){
            while (pendingItemsToCache.size() < maxItemsToCache) {
                if (!scanner.next()) {
                    seekerExhausted = true;
                    break;
                }
                long baseId = ((IdRangeKey)scanner.key()).getIdRangeIdx() * (long)this.idsPerEntry;
                ((IdRange)scanner.value()).visitFreeIds(baseId, this.generation, visitor);
            }
            this.ongoingScanRangeIndex = seekerExhausted ? null : Long.valueOf(((IdRangeKey)scanner.key()).getIdRangeIdx());
        }
        boolean bl = somethingWasCached = pendingItemsToCache.size() > 0;
        if (seekerExhausted && !somethingWasCached && startedNow) {
            this.atLeastOneIdOnFreelist.set(false);
        }
        return somethingWasCached;
    }

    private boolean queueId(LinkedChunkLongArray pendingItemsToCache, int maxItemsToCache, long id) {
        if (pendingItemsToCache.size() < maxItemsToCache) {
            pendingItemsToCache.add(id);
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
    }
}

