/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.internal.id.BufferingIdGenerator;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;

public class BufferingIdGeneratorFactory
implements IdGeneratorFactory {
    private final BufferingIdGenerator[] overriddenIdGenerators = new BufferingIdGenerator[IdType.values().length];
    private Supplier<IdController.ConditionSnapshot> boundaries;
    private final Predicate<IdController.ConditionSnapshot> safeThreshold;
    private final IdGeneratorFactory delegate;

    public BufferingIdGeneratorFactory(IdGeneratorFactory delegate) {
        this.delegate = delegate;
        this.safeThreshold = IdController.ConditionSnapshot::conditionMet;
    }

    public void initialize(Supplier<IdController.ConditionSnapshot> conditionSnapshotSupplier) {
        this.boundaries = conditionSnapshotSupplier;
    }

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        assert (this.boundaries != null) : "Factory needs to be initialized before usage";
        IdGenerator generator = this.delegate.open(pageCache, filename, idType, highIdScanner, maxId, readOnlyChecker, config, cursorContext, openOptions);
        return this.wrapAndKeep(idType, generator);
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path filename, IdType idType, long highId, boolean throwIfFileExists, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        IdGenerator idGenerator = this.delegate.create(pageCache, filename, idType, highId, throwIfFileExists, maxId, readOnlyChecker, config, cursorContext, openOptions);
        return this.wrapAndKeep(idType, idGenerator);
    }

    @Override
    public IdGenerator get(IdType idType) {
        BufferingIdGenerator generator = this.overriddenIdGenerators[idType.ordinal()];
        return generator != null ? generator : this.delegate.get(idType);
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
        Stream.of(this.overriddenIdGenerators).forEach(visitor);
    }

    @Override
    public void clearCache(CursorContext cursorContext) {
        this.delegate.clearCache(cursorContext);
    }

    @Override
    public Collection<Path> listIdFiles() {
        return this.delegate.listIdFiles();
    }

    private IdGenerator wrapAndKeep(IdType idType, IdGenerator generator) {
        BufferingIdGenerator bufferingGenerator = new BufferingIdGenerator(generator);
        bufferingGenerator.initialize(this.boundaries, this.safeThreshold);
        this.overriddenIdGenerators[idType.ordinal()] = bufferingGenerator;
        return bufferingGenerator;
    }

    public void maintenance(CursorContext cursorContext) {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.maintenance(cursorContext);
        }
    }

    public void clear() {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.clear();
        }
    }
}

