/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.internal.id.ChunkConsumer;
import org.neo4j.io.pagecache.context.CursorContext;

public class DelayedBuffer<T> {
    private final Supplier<T> thresholdSupplier;
    private final Predicate<T> safeThreshold;
    private final ChunkConsumer chunkConsumer;
    private final Deque<Chunk<T>> chunks = new ConcurrentLinkedDeque<Chunk<T>>();
    private final int chunkSize;
    private final Lock consumeLock = new ReentrantLock();
    private final long[] chunk;
    private int chunkCursor;

    DelayedBuffer(Supplier<T> thresholdSupplier, Predicate<T> safeThreshold, int chunkSize, ChunkConsumer chunkConsumer) {
        assert (chunkSize > 0);
        this.thresholdSupplier = thresholdSupplier;
        this.safeThreshold = safeThreshold;
        this.chunkSize = chunkSize;
        this.chunkConsumer = chunkConsumer;
        this.chunk = new long[chunkSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintenance(CursorContext cursorContext) {
        DelayedBuffer delayedBuffer = this;
        synchronized (delayedBuffer) {
            this.flush();
        }
        this.consumeLock.lock();
        try {
            while (!this.chunks.isEmpty()) {
                Chunk<T> candidate = this.chunks.peek();
                if (this.safeThreshold.test(candidate.threshold)) {
                    this.chunkConsumer.consume(candidate.values, cursorContext);
                    this.chunks.remove();
                    continue;
                }
                break;
            }
        }
        finally {
            this.consumeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.chunkCursor > 0) {
            Deque<Chunk<T>> deque = this.chunks;
            synchronized (deque) {
                Chunk<T> chunkToAdd = new Chunk<T>(this.thresholdSupplier.get(), Arrays.copyOf(this.chunk, this.chunkCursor));
                this.chunks.offer(chunkToAdd);
            }
            this.chunkCursor = 0;
        }
    }

    public synchronized void offer(long value) {
        this.chunk[this.chunkCursor++] = value;
        if (this.chunkCursor == this.chunkSize) {
            this.flush();
        }
    }

    public synchronized void close() {
        this.clear();
    }

    public synchronized void clear() {
        this.chunks.clear();
        this.chunkCursor = 0;
    }

    private static class Chunk<T> {
        private final T threshold;
        private final long[] values;

        Chunk(T threshold, long[] values) {
            this.threshold = threshold;
            this.values = values;
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }
}

