/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.List;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;

class BufferingIdGenerator
extends IdGenerator.Delegate {
    private final MemoryTracker memoryTracker;
    private HeapTrackingLongArrayList bufferedDeletedIds;

    BufferingIdGenerator(IdGenerator delegate, MemoryTracker memoryTracker) {
        super(delegate);
        this.memoryTracker = memoryTracker;
        this.newFreeBuffer();
    }

    private void newFreeBuffer() {
        this.bufferedDeletedIds = HeapTrackingLongArrayList.newLongArrayList((int)10, (MemoryTracker)this.memoryTracker);
    }

    @Override
    public IdGenerator.Marker marker(CursorContext cursorContext) {
        final IdGenerator.Marker actual = super.marker(cursorContext);
        return new IdGenerator.Marker(){

            @Override
            public void markUsed(long id, int numberOfIds) {
                actual.markUsed(id, numberOfIds);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markDeleted(long id, int numberOfIds) {
                actual.markDeleted(id, numberOfIds);
                BufferingIdGenerator bufferingIdGenerator = BufferingIdGenerator.this;
                synchronized (bufferingIdGenerator) {
                    BufferingIdGenerator.this.bufferedDeletedIds.add(IdUtils.combinedIdAndNumberOfIds(id, numberOfIds, false));
                }
            }

            @Override
            public void markFree(long id, int numberOfIds) {
                actual.markFree(id, numberOfIds);
            }

            @Override
            public void close() {
                actual.close();
            }
        };
    }

    synchronized void collectBufferedIds(List<BufferingIdGeneratorFactory.IdBuffer> idBuffers) {
        if (!this.bufferedDeletedIds.isEmpty()) {
            idBuffers.add(new BufferingIdGeneratorFactory.IdBuffer(this.delegate, this.bufferedDeletedIds));
            this.newFreeBuffer();
        }
    }
}

