/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

final class BitsUtil {
    private BitsUtil() {
    }

    static long bitsInSingleLong(int start, int slots) {
        long bits = start + slots == 64 ? -1L : (1L << start + slots) - 1L;
        return bits & -(1L << start);
    }

    static void setBits(long[] bits, int start, int slots, int bitsArraySlot) {
        int firstArraySlot = bitsArraySlot + start / 64;
        start %= 64;
        int arraySlot = firstArraySlot;
        while (slots > 0) {
            int slotsInThisLong = Integer.min(slots, 64 - start);
            long bitsInThisSlot = BitsUtil.bitsInSingleLong(start, slotsInThisLong);
            assert (bits[arraySlot] == 0L);
            bits[arraySlot] = bitsInThisSlot;
            slots -= slotsInThisLong;
            start = 0;
            ++arraySlot;
        }
    }
}

