/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;

public class BufferedIdController
extends LifecycleAdapter
implements IdController {
    private static final String BUFFERED_ID_CONTROLLER = "idController";
    private final BufferingIdGeneratorFactory bufferingIdGeneratorFactory;
    private final JobScheduler scheduler;
    private final CursorContextFactory contextFactory;
    private final String databaseName;
    private final InternalLog log;
    private JobHandle<?> jobHandle;
    private volatile boolean running;
    private final Lock maintenanceLock = new ReentrantLock();

    public BufferedIdController(BufferingIdGeneratorFactory bufferingIdGeneratorFactory, JobScheduler scheduler, CursorContextFactory contextFactory, String databaseName, LogService logService) {
        this.bufferingIdGeneratorFactory = bufferingIdGeneratorFactory;
        this.scheduler = scheduler;
        this.contextFactory = contextFactory;
        this.databaseName = databaseName;
        this.log = logService.getInternalLog(BufferedIdController.class);
    }

    public void init() throws Exception {
        this.bufferingIdGeneratorFactory.init();
    }

    public void start() throws Exception {
        this.bufferingIdGeneratorFactory.start();
        this.running = true;
        JobMonitoringParams monitoringParams = JobMonitoringParams.systemJob((String)this.databaseName, (String)"ID generator maintenance");
        this.jobHandle = this.scheduler.scheduleRecurring(Group.STORAGE_MAINTENANCE, monitoringParams, this::maintenance, 1L, TimeUnit.SECONDS);
    }

    public void stop() throws Exception {
        this.running = false;
        if (this.jobHandle != null) {
            this.jobHandle.cancel();
            this.jobHandle = null;
            this.maintenanceLock.lock();
            this.maintenanceLock.unlock();
        }
        this.bufferingIdGeneratorFactory.stop();
    }

    public void shutdown() throws Exception {
        this.bufferingIdGeneratorFactory.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maintenance() {
        block11: {
            this.maintenanceLock.lock();
            try {
                if (!this.running) break block11;
                try (CursorContext cursorContext = this.contextFactory.create(BUFFERED_ID_CONTROLLER);){
                    this.bufferingIdGeneratorFactory.maintenance(cursorContext);
                }
                catch (Throwable t) {
                    this.log.error("Exception when performing id maintenance", t);
                }
            }
            finally {
                this.maintenanceLock.unlock();
            }
        }
    }

    @Override
    public void initialize(FileSystemAbstraction fs, Path baseBufferPath, Config config, Supplier<IdController.TransactionSnapshot> snapshotSupplier, IdController.IdFreeCondition condition, MemoryTracker memoryTracker) throws IOException {
        this.bufferingIdGeneratorFactory.initialize(fs, baseBufferPath, config, snapshotSupplier, condition, memoryTracker);
    }
}

