/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.id.BufferedIds;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.io.IOUtils;

class HeapBufferedIds
implements BufferedIds {
    private final ConcurrentLinkedDeque<Entry> queue = new ConcurrentLinkedDeque();

    HeapBufferedIds() {
    }

    @Override
    public void write(IdController.TransactionSnapshot snapshot, List<BufferingIdGeneratorFactory.IdBuffer> idBuffers) throws IOException {
        this.queue.add(new Entry(snapshot, idBuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(BufferedIds.BufferedIdVisitor visitor) throws IOException {
        Entry entry;
        while ((entry = this.queue.peek()) != null && visitor.startChunk(entry.snapshot)) {
            try {
                this.queue.remove();
                for (BufferingIdGeneratorFactory.IdBuffer idBuffer : entry.idBuffers) {
                    visitor.startType(idBuffer.idTypeOrdinal());
                    try {
                        PrimitiveLongResourceIterator ids = idBuffer.ids().iterator();
                        while (ids.hasNext()) {
                            visitor.id(ids.next());
                        }
                    }
                    finally {
                        visitor.endType();
                    }
                }
            }
            finally {
                visitor.endChunk();
                IOUtils.closeAll(entry.idBuffers);
            }
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public void close() throws IOException {
    }

    private record Entry(IdController.TransactionSnapshot snapshot, List<BufferingIdGeneratorFactory.IdBuffer> idBuffers) {
    }
}

