/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.range;

import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.range.ArrayBasedRange;
import org.neo4j.internal.id.range.ContinuousIdRange;

public interface PageIdRange {
    public static final PageIdRange EMPTY = new PageIdRange(){

        @Override
        public long nextId() {
            return -1L;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void unallocate(IdGenerator.TransactionalMarker marker) {
        }

        @Override
        public void mark() {
        }

        @Override
        public void resetToMark() {
        }

        @Override
        public long pageId() {
            return -1L;
        }

        public String toString() {
            return "EMPTY_RANGE";
        }
    };

    public static PageIdRange wrap(long[] ids, int idsPerPage) {
        if (ids[0] + (long)ids.length - 1L == ids[ids.length - 1]) {
            return new ContinuousIdRange(ids[0], ids.length, idsPerPage);
        }
        return new ArrayBasedRange(ids, idsPerPage);
    }

    public long nextId();

    public boolean hasNext();

    public void unallocate(IdGenerator.TransactionalMarker var1);

    public long pageId();

    public void mark();

    public void resetToMark();
}

