/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;

class ReadOnlyHighIdGenerator
implements IdGenerator {
    private final long highId;
    private final IdType idType;

    ReadOnlyHighIdGenerator(long highId, IdType idType) {
        this.highId = highId;
        this.idType = idType;
    }

    @Override
    public void setHighId(long id) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void markHighestWrittenAtHighId() {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public long getHighestWritten() {
        return this.highId;
    }

    @Override
    public long getHighId() {
        return this.highId;
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.highId - 1L;
    }

    @Override
    public IdGenerator.Marker marker(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void close() {
    }

    @Override
    public long getNumberOfIdsInUse() {
        return this.getHighId();
    }

    @Override
    public long getDefragCount() {
        return 0L;
    }

    @Override
    public void checkpoint(FileFlushEvent flushEvent, CursorContext cursorContext) {
    }

    @Override
    public void maintenance(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) {
    }

    @Override
    public long nextId(CursorContext ignored) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public long nextConsecutiveIdRange(int numberOfIds, boolean favorSamePage, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void clearCache(CursorContext cursorContext) {
    }

    @Override
    public IdType idType() {
        return this.idType;
    }

    @Override
    public boolean hasOnlySingleIds() {
        return true;
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
        return true;
    }
}

