/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.memory.MemoryTracker;

public abstract class AbstractBufferingIdGeneratorFactory
extends LifecycleAdapter
implements IdGeneratorFactory {
    protected final IdGeneratorFactory delegate;

    public AbstractBufferingIdGeneratorFactory(IdGeneratorFactory delegate) {
        this.delegate = delegate;
    }

    public abstract void initialize(FileSystemAbstraction var1, Path var2, Config var3, Supplier<IdController.TransactionSnapshot> var4, IdController.IdFreeCondition var5, MemoryTracker var6) throws IOException;

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, boolean readOnly, Config config, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
        IdGenerator generator = this.delegate.open(pageCache, filename, idType, highIdScanner, maxId, readOnly, config, contextFactory, openOptions, slotDistribution);
        return this.wrapAndKeep(idType, generator);
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path filename, IdType idType, long highId, boolean throwIfFileExists, long maxId, boolean readOnly, Config config, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
        IdGenerator idGenerator = this.delegate.create(pageCache, filename, idType, highId, throwIfFileExists, maxId, readOnly, config, contextFactory, openOptions, slotDistribution);
        return this.wrapAndKeep(idType, idGenerator);
    }

    @Override
    public Collection<Path> listIdFiles() {
        return this.delegate.listIdFiles();
    }

    protected abstract IdGenerator wrapAndKeep(IdType var1, IdGenerator var2);

    public abstract void maintenance(CursorContext var1);

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

