/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.common.EmptyDependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.SingleRoot;
import org.neo4j.index.internal.gbptree.StructureWriteLog;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.TreeNodeLayoutFactory;
import org.neo4j.index.internal.gbptree.ValueHolder;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.id.indexed.FreeIdScanner;
import org.neo4j.internal.id.indexed.HeaderReader;
import org.neo4j.internal.id.indexed.HeaderWriter;
import org.neo4j.internal.id.indexed.IdCache;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IdRangeLayout;
import org.neo4j.internal.id.indexed.IdRangeMarker;
import org.neo4j.internal.id.indexed.IdRangeMerger;
import org.neo4j.internal.id.range.ArrayBasedRange;
import org.neo4j.internal.id.range.ContinuousIdRange;
import org.neo4j.internal.id.range.PageIdRange;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.util.Preconditions;

public class IndexedIdGenerator
implements IdGenerator {
    public static final Monitor NO_MONITOR = new Monitor.Adapter();
    static final long NO_ID = -1L;
    public static final int IDS_PER_ENTRY = 128;
    static final int SMALL_CACHE_CAPACITY = 256;
    static final int LARGE_CACHE_CAPACITY = 8192;
    private static final long STARTING_GENERATION = 1L;
    private final GBPTree<IdRangeKey, IdRange> tree;
    private final IdCache cache;
    private final IdType idType;
    private final int idsPerEntry;
    private final int cacheOptimisticRefillThreshold;
    private final Lock transactionalMarkerLock = new ReentrantLock();
    private final IdRangeLayout layout;
    private final FreeIdScanner scanner;
    private final AtomicLong highId = new AtomicLong();
    private final long maxId;
    private final AtomicInteger freeIdsNotifier = new AtomicInteger();
    private final AtomicLong numUnusedIds = new AtomicLong(-1L);
    private final long generation;
    private final boolean needsRebuild;
    private final AtomicLong highestWrittenId = new AtomicLong();
    private final FileSystemAbstraction fileSystem;
    private final Path path;
    private volatile boolean started;
    private final boolean readOnly;
    private final IdSlotDistribution slotDistribution;
    private final PageCacheTracer pageCacheTracer;
    private final boolean useDirectToCache;
    private final CursorContextFactory contextFactory;
    private final Monitor monitor;
    private final boolean strictlyPrioritizeFreelist;
    private final int biggestSlotSize;
    private final Set<Long> lockedPageRanges;
    private final boolean respectsReservedIds;

    public IndexedIdGenerator(PageCache pageCache, FileSystemAbstraction fileSystem, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdType idType, boolean allowLargeIdCaches, LongSupplier initialHighId, long maxId, boolean readOnly, Config config, String databaseName, CursorContextFactory contextFactory, Monitor monitor, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution, PageCacheTracer tracer, boolean allocationEnabled, boolean useDirectToCache) {
        this.fileSystem = fileSystem;
        this.path = path;
        this.readOnly = readOnly;
        this.contextFactory = contextFactory;
        this.slotDistribution = slotDistribution;
        this.pageCacheTracer = tracer;
        this.useDirectToCache = useDirectToCache;
        int cacheCapacity = idType.highActivity() && allowLargeIdCaches ? 8192 : 256;
        this.idType = idType;
        IdSlotDistribution.Slot[] slots = slotDistribution.slots(cacheCapacity);
        this.cache = new IdCache(slots);
        this.biggestSlotSize = Arrays.stream(slots).map(IdSlotDistribution.Slot::slotSize).max((Comparator<Integer>)Comparators.naturalOrder()).orElseThrow();
        this.maxId = maxId;
        this.monitor = monitor;
        this.lockedPageRanges = IndexedIdGenerator.isMultiVersioned(openOptions) ? ConcurrentHashMap.newKeySet() : Collections.emptySet();
        this.idsPerEntry = slotDistribution.idsPerEntry();
        this.layout = new IdRangeLayout(this.idsPerEntry);
        HeaderReader header = new HeaderReader();
        this.tree = this.instantiateTree(pageCache, path, header, recoveryCleanupWorkCollector, readOnly, databaseName, contextFactory, openOptions, config);
        boolean bl = this.needsRebuild = !header.wasRead || header.generation == 1L;
        if (!this.needsRebuild) {
            this.highId.set(header.highId);
            this.highestWrittenId.set(header.highestWrittenId);
            this.generation = header.generation + 1L;
            Preconditions.checkState((this.idsPerEntry == header.idsPerEntry ? 1 : 0) != 0, (String)"ID generator was opened with a different idsPerEntry:%s than what it was created with:%s", (Object[])new Object[]{header.idsPerEntry, this.idsPerEntry});
            this.freeIdsNotifier.incrementAndGet();
            this.numUnusedIds.set(header.numUnusedIds);
        } else {
            this.highId.set(initialHighId.getAsLong());
            this.highestWrittenId.set(this.highId.get() - 1L);
            this.generation = 2L;
            this.numUnusedIds.set(0L);
        }
        monitor.opened(this.highestWrittenId.get(), this.highId.get(), this.numUnusedIds.get());
        this.strictlyPrioritizeFreelist = !IndexedIdGenerator.isMultiVersioned(openOptions) && (Boolean)config.get(GraphDatabaseInternalSettings.strictly_prioritize_id_freelist) != false;
        this.cacheOptimisticRefillThreshold = this.strictlyPrioritizeFreelist ? 0 : cacheCapacity / 4;
        this.scanner = new FreeIdScanner(this.idsPerEntry, this.tree, this.layout, this.cache, this.freeIdsNotifier, this::contextualMarker, this.generation, this.strictlyPrioritizeFreelist, monitor, allocationEnabled, useDirectToCache);
        this.respectsReservedIds = idType.respectsReservedId();
    }

    private GBPTree<IdRangeKey, IdRange> instantiateTree(PageCache pageCache, Path path, HeaderReader headerReader, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, String databaseName, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, Config config) {
        try {
            return new GBPTree(pageCache, this.fileSystem, path, (Layout)this.layout, MultiRootGBPTree.NO_MONITOR, (Header.Reader)headerReader, recoveryCleanupWorkCollector, readOnly, openOptions.newWithout((Object)PageCacheOpenOptions.MULTI_VERSIONED), databaseName, "Indexed ID generator", contextFactory, this.pageCacheTracer, EmptyDependencyResolver.EMPTY_RESOLVER, TreeNodeLayoutFactory.getInstance(), StructureWriteLog.structureWriteLog((FileSystemAbstraction)this.fileSystem, (Path)path, (Config)config));
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Id generator file could not be found, most likely this database needs to be recovered, file:" + path, e);
        }
    }

    private boolean isReservedId(long id) {
        return this.respectsReservedIds && IdValidator.isReservedId(id);
    }

    private boolean hasReservedIdInRange(long startIdInclusive, long endIdExclusive) {
        return this.respectsReservedIds && IdValidator.hasReservedIdInRange(startIdInclusive, endIdExclusive);
    }

    @Override
    public long nextId(CursorContext cursorContext) {
        long id;
        do {
            this.checkRefillCache(cursorContext);
            id = this.cache.takeOrDefault(-1L);
            if (id == -1L) continue;
            this.monitor.allocatedFromReused(id, 1);
            return id;
        } while (this.strictlyPrioritizeFreelist && this.scanner.hasMoreFreeIds(false));
        do {
            id = this.highId.getAndIncrement();
            IdValidator.assertIdWithinMaxCapacity(this.idType, id, this.maxId);
        } while (this.isReservedId(id));
        this.monitor.allocatedFromHigh(id, 1);
        return id;
    }

    @Override
    public PageIdRange nextPageRange(CursorContext cursorContext, int idsPerPage) {
        long requestSize;
        long currentHighId;
        this.checkRefillCache(cursorContext);
        long[] reusedIds = this.cache.drainRange(idsPerPage);
        if (reusedIds.length > 0) {
            Arrays.sort(reusedIds);
            PageIdRange range = PageIdRange.wrap(reusedIds, idsPerPage);
            if (this.lockedPageRanges.add(range.pageId())) {
                return range;
            }
            try (IdRangeMarker marker = this.lockAndInstantiateMarker(false, false, cursorContext);){
                range.unallocate(marker);
            }
        }
        while (!this.highId.weakCompareAndSetRelease(currentHighId = this.highId.getAcquire(), currentHighId + (requestSize = (long)idsPerPage - currentHighId % (long)idsPerPage))) {
        }
        IdValidator.assertIdWithinMaxCapacity(this.idType, currentHighId + (long)idsPerPage, this.maxId);
        this.monitor.allocatedFromHigh(currentHighId, (int)requestSize);
        PageIdRange pageIdRange = this.hasReservedIdInRange(currentHighId, currentHighId + (long)idsPerPage) ? IndexedIdGenerator.rangeWithoutReservedId(idsPerPage, currentHighId) : new ContinuousIdRange(currentHighId, (int)requestSize, idsPerPage);
        this.lockedPageRanges.add(pageIdRange.pageId());
        return pageIdRange;
    }

    @Override
    public void releasePageRange(PageIdRange range, CursorContext context) {
        if (range.hasNext()) {
            try (IdGenerator.TransactionalMarker marker = this.transactionalMarker(context);){
                range.unallocate(marker);
            }
        }
        this.lockedPageRanges.remove(range.pageId());
    }

    @Override
    public long nextConsecutiveIdRange(int numberOfIds, boolean favorSamePage, CursorContext cursorContext) {
        int skipped;
        long id;
        long endId;
        long readHighId;
        if (numberOfIds <= this.biggestSlotSize) {
            this.checkRefillCache(cursorContext);
            long id2 = this.cache.takeOrDefault(-1L, numberOfIds, this.monitor, this.scanner::queueWastedCachedId);
            if (id2 != -1L) {
                this.monitor.allocatedFromReused(id2, numberOfIds);
                return id2;
            }
        }
        do {
            id = readHighId = this.highId.get();
            endId = readHighId + (long)numberOfIds - 1L;
            skipped = 0;
            if (favorSamePage && this.layout.idRangeIndex(readHighId) != this.layout.idRangeIndex(endId)) {
                long newId = this.layout.idRangeIndex(endId) * (long)this.idsPerEntry;
                skipped = (int)(newId - id);
                id = newId;
                endId = id + (long)numberOfIds - 1L;
            }
            IdValidator.assertIdWithinMaxCapacity(this.idType, endId, this.maxId);
        } while (!this.highId.compareAndSet(readHighId, endId + 1L) || this.hasReservedIdInRange(id, endId + 1L));
        this.monitor.allocatedFromHigh(id, numberOfIds);
        if (skipped > 0) {
            int accepted = this.cache.offer(readHighId, skipped, this.monitor);
            if (accepted < skipped) {
                this.scanner.queueSkippedHighId(readHighId + (long)accepted, skipped - accepted);
            }
            this.monitor.skippedIdsAtHighId(id, numberOfIds);
        }
        return id;
    }

    @Override
    public IdGenerator.TransactionalMarker transactionalMarker(CursorContext cursorContext) {
        if (!this.started && this.needsRebuild) {
            return NOOP_MARKER;
        }
        final IdRangeMarker realMarker = this.lockAndInstantiateMarker(true, this.useDirectToCache && !this.scanner.allocationEnabled(), cursorContext);
        if (!this.useDirectToCache) {
            return realMarker;
        }
        return new IdGenerator.TransactionalMarker.Delegate(realMarker){

            @Override
            public void markDeletedAndFree(long id, int numberOfIds) {
                realMarker.markDeleted(id, numberOfIds);
                IndexedIdGenerator.this.feedDirectlyToCache(id, numberOfIds, realMarker);
            }
        };
    }

    @Override
    public IdGenerator.ContextualMarker contextualMarker(CursorContext cursorContext) {
        if (!this.allocationEnabled()) {
            throw new IllegalStateException("This ID generator has allocation disabled, which means it should not need to do contextual updates");
        }
        if (!this.started && this.needsRebuild) {
            return NOOP_MARKER;
        }
        final IdRangeMarker realMarker = this.instantiateMarker(null, true, false, cursorContext);
        if (!this.useDirectToCache) {
            return realMarker;
        }
        return new IdGenerator.ContextualMarker.Delegate(realMarker){

            @Override
            public void markFree(long id, int numberOfIds) {
                IndexedIdGenerator.this.feedDirectlyToCache(id, numberOfIds, realMarker);
            }
        };
    }

    private void feedDirectlyToCache(long id, int numberOfIds, IdRangeMarker realMarker) {
        int accepted = this.cache.offer(id, numberOfIds, this.monitor);
        if (accepted < numberOfIds) {
            realMarker.markFree(id + (long)accepted, numberOfIds - accepted);
        }
    }

    IdRangeMarker lockAndInstantiateMarker(boolean bridgeIdGaps, boolean deleteAlsoFrees, CursorContext cursorContext) {
        this.transactionalMarkerLock.lock();
        try {
            return this.instantiateMarker(this.transactionalMarkerLock, bridgeIdGaps, deleteAlsoFrees, cursorContext);
        }
        catch (Exception e) {
            this.transactionalMarkerLock.unlock();
            throw e;
        }
    }

    private IdRangeMarker instantiateMarker(Lock lock, boolean bridgeIdGaps, boolean deleteAlsoFrees, CursorContext cursorContext) {
        try {
            IdRangeMerger merger = new IdRangeMerger(!this.started, this.monitor, this.numUnusedIds.get() == -1L ? null : this.numUnusedIds);
            return new IdRangeMarker(this.idType, this.idsPerEntry, (Layout<IdRangeKey, IdRange>)this.layout, (Writer<IdRangeKey, IdRange>)this.tree.writer(cursorContext), lock, merger, this.started, this.freeIdsNotifier, this.generation, this.highestWrittenId, bridgeIdGaps, deleteAlsoFrees, this.monitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.tree, this.monitor});
    }

    @Override
    public long getHighId() {
        return this.highId.get();
    }

    @Override
    public void setHighId(long newHighId) {
        long expect;
        while (newHighId > (expect = this.highId.get()) && !this.highId.compareAndSet(expect, newHighId)) {
        }
    }

    @Override
    public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) throws IOException {
        if (this.needsRebuild) {
            this.assertNotReadOnly();
            boolean visitsDeletedIds = freeIdsForRebuild.visitsDeletedIds();
            try (IdRangeMarker idRangeMarker = this.lockAndInstantiateMarker(!visitsDeletedIds, true, cursorContext);){
                long highestId = freeIdsForRebuild.accept((id, numberOfIds) -> {
                    if (visitsDeletedIds) {
                        idRangeMarker.markDeleted(id, numberOfIds);
                    } else {
                        idRangeMarker.markUsed(id, numberOfIds);
                    }
                });
                this.highId.set(highestId + 1L);
                this.highestWrittenId.set(highestId);
            }
        }
        if (this.numUnusedIds.get() == -1L) {
            try (PrimitiveLongResourceIterator notUsedIterator = this.notUsedIdsIterator();){
                this.numUnusedIds.set(PrimitiveLongResourceCollections.count((PrimitiveLongResourceIterator)notUsedIterator));
            }
        }
        this.started = true;
        this.maintenance(cursorContext);
    }

    @Override
    public void checkpoint(FileFlushEvent flushEvent, CursorContext cursorContext) {
        this.tree.checkpoint((Consumer)new HeaderWriter(this.highId::get, this.highestWrittenId::get, this.generation, this.idsPerEntry, this.numUnusedIds::get), flushEvent, cursorContext);
        this.monitor.checkpoint(this.highestWrittenId.get(), this.highId.get());
    }

    @Override
    public void maintenance(CursorContext cursorContext) {
        if (this.started && !this.cache.isFull() && !this.readOnly) {
            this.scanner.tryLoadFreeIdsIntoCache(true, true, cursorContext);
        }
    }

    private void checkRefillCache(CursorContext cursorContext) {
        if (this.cache.size() <= this.cacheOptimisticRefillThreshold) {
            this.scanner.tryLoadFreeIdsIntoCache(this.strictlyPrioritizeFreelist, false, cursorContext);
        }
    }

    @Override
    public void clearCache(boolean allocationEnabled, CursorContext cursorContext) {
        if (!this.readOnly) {
            this.monitor.clearingCache();
            this.scanner.clearCache(allocationEnabled, cursorContext);
            this.monitor.clearedCache();
        }
    }

    @Override
    public boolean allocationEnabled() {
        return this.scanner.allocationEnabled();
    }

    @Override
    public IdType idType() {
        return this.idType;
    }

    @Override
    public boolean hasOnlySingleIds() {
        return this.slotDistribution.maxSlotSize() == 1;
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.getHighId() - 1L;
    }

    @Override
    public long getUnusedIdCount() {
        return this.numUnusedIds.get();
    }

    @Override
    public void markHighestWrittenAtHighId() {
        this.assertNotReadOnly();
        this.highestWrittenId.set(this.highId.get() - 1L);
    }

    @Override
    public long getHighestWritten() {
        return this.highestWrittenId.get();
    }

    public Path path() {
        return this.path;
    }

    private static Optional<HeaderReader> readHeader(FileSystemAbstraction fileSystem, Path path, ImmutableSet<OpenOption> openOptions) {
        HeaderReader headerReader = new HeaderReader();
        return MultiRootGBPTree.readHeader((FileSystemAbstraction)fileSystem, (Path)path, (Header.Reader)headerReader, openOptions);
    }

    public static void dump(PageCache pageCache, FileSystemAbstraction fileSystem, Path path, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, boolean onlySummary, ImmutableSet<OpenOption> openOptions, final PrintStream out) throws IOException {
        final HeaderReader header = IndexedIdGenerator.readHeader(fileSystem, path, openOptions).orElseThrow(() -> new NoSuchFileException(path.toAbsolutePath().toString()));
        final IdRangeLayout layout = new IdRangeLayout(header.idsPerEntry);
        try (GBPTree tree = new GBPTree(pageCache, fileSystem, path, (Layout)layout, MultiRootGBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, RecoveryCleanupWorkCollector.immediate(), true, openOptions.newWithout((Object)PageCacheOpenOptions.MULTI_VERSIONED), "neo4j", "Indexed ID generator", contextFactory, pageCacheTracer);){
            out.println(header);
            if (onlySummary) {
                final MutableLong numDeletedNotFreed = new MutableLong();
                final MutableLong numDeletedAndFreed = new MutableLong();
                out.println("Calculating summary...");
                try (CursorContext cursorContext = contextFactory.create("IndexDump");){
                    tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<SingleRoot, IdRangeKey, IdRange>(){

                        public void value(ValueHolder<IdRange> value) {
                            for (int i = 0; i < header.idsPerEntry; ++i) {
                                IdRange.IdState state = ((IdRange)value.value).getState(i);
                                if (state == IdRange.IdState.FREE) {
                                    numDeletedAndFreed.increment();
                                    continue;
                                }
                                if (state != IdRange.IdState.DELETED) continue;
                                numDeletedNotFreed.increment();
                            }
                        }
                    }, cursorContext);
                }
                out.println();
                out.println("Number of IDs deleted and available for reuse: " + numDeletedAndFreed);
                out.println("Number of IDs deleted, but not yet available for reuse: " + numDeletedNotFreed);
                out.printf("NOTE: A deleted ID not yet available for reuse is buffered until all transactions that were open%nat the time of its deletion have been closed, or the database is restarted%n", new Object[0]);
            } else {
                try (CursorContext cursorContext = contextFactory.create("IndexDump");){
                    tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<SingleRoot, IdRangeKey, IdRange>(){
                        private IdRangeKey key;

                        public void key(IdRangeKey key, boolean isLeaf, long offloadId) {
                            this.key = key;
                        }

                        public void value(ValueHolder<IdRange> value) {
                            long rangeIndex = this.key.getIdRangeIdx();
                            int idsPerEntry = layout.idsPerEntry();
                            out.printf("%s [rangeIndex: %d, i.e. IDs:%d-%d]%n", value.value, rangeIndex, rangeIndex * (long)idsPerEntry, (rangeIndex + 1L) * (long)idsPerEntry - 1L);
                        }
                    }, cursorContext);
                }
            }
            out.println(header);
        }
    }

    @Override
    public PrimitiveLongResourceIterator notUsedIdsIterator() throws IOException {
        return this.notUsedIdsIterator(0L, this.getHighId());
    }

    @Override
    public PrimitiveLongResourceIterator notUsedIdsIterator(long fromIdInclusive, long toIdExclusive) throws IOException {
        return this.conditionalIdIterator(fromIdInclusive, toIdExclusive, state -> IdRange.IdState.USED != state);
    }

    @Override
    public PrimitiveLongResourceIterator freeIdsIterator() throws IOException {
        return this.conditionalIdIterator(0L, this.getHighId(), state -> IdRange.IdState.FREE == state);
    }

    private PrimitiveLongResourceCollections.AbstractPrimitiveLongBaseResourceIterator conditionalIdIterator(final long fromIdInclusive, final long toIdExclusive, final Predicate<IdRange.IdState> idStatePredicate) throws IOException {
        Preconditions.checkArgument((fromIdInclusive <= toIdExclusive ? 1 : 0) != 0, (String)"From Id needs to be lesser than toId");
        long fromRange = fromIdInclusive / (long)this.idsPerEntry;
        long toRange = toIdExclusive / (long)this.idsPerEntry + 1L;
        CursorContext context = this.contextFactory.create("FreeIdIterator");
        final Seeker scanner = this.tree.seek((Object)new IdRangeKey(fromRange), (Object)new IdRangeKey(toRange), context);
        final long compareToIdExclusive = fromIdInclusive == toIdExclusive ? toIdExclusive + 1L : toIdExclusive;
        return new PrimitiveLongResourceCollections.AbstractPrimitiveLongBaseResourceIterator(() -> IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{scanner, context})){
            private IdRangeKey currentKey;
            private IdRange currentRange;
            private int nextIndex;
            private boolean reachedEnd;
            {
                super(resource);
                this.nextIndex = fromIdInclusive == toIdExclusive ? (int)(fromIdInclusive % (long)IndexedIdGenerator.this.idsPerEntry) : 0;
            }

            protected boolean fetchNext() {
                try {
                    while (!this.reachedEnd) {
                        if (this.currentRange == null) {
                            if (!scanner.next()) {
                                this.reachedEnd = true;
                                return false;
                            }
                            this.currentRange = (IdRange)scanner.value();
                            this.currentKey = (IdRangeKey)scanner.key();
                        }
                        while (this.nextIndex < IndexedIdGenerator.this.idsPerEntry) {
                            int index;
                            ++this.nextIndex;
                            long id = this.currentKey.getIdRangeIdx() * (long)IndexedIdGenerator.this.idsPerEntry + (long)index;
                            if (id >= compareToIdExclusive) {
                                return false;
                            }
                            if (id < fromIdInclusive || !idStatePredicate.test(this.currentRange.getState(index))) continue;
                            return this.next(id);
                        }
                        this.currentRange = null;
                        this.nextIndex = 0;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return false;
            }
        };
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
        return this.tree.consistencyCheck(reporterFactory, contextFactory, numThreads, progressMonitorFactory);
    }

    private void assertNotReadOnly() {
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (String)"ID generator '%s' is read-only", (Object[])new Object[]{this.path});
    }

    private static PageIdRange rangeWithoutReservedId(int idsPerPage, long currentHighId) {
        long[] ids = new long[idsPerPage - 1];
        for (int i = 0; i < ids.length; ++i) {
            long value;
            ++currentHighId;
            if (IdValidator.isReservedId(value)) continue;
            ids[i] = value;
        }
        return new ArrayBasedRange(ids, idsPerPage);
    }

    private static boolean isMultiVersioned(ImmutableSet<OpenOption> openOptions) {
        return openOptions.contains((Object)PageCacheOpenOptions.MULTI_VERSIONED);
    }

    public static interface Monitor
    extends AutoCloseable {
        public void opened(long var1, long var3, long var5);

        @Override
        public void close();

        public void allocatedFromHigh(long var1, int var3);

        public void allocatedFromReused(long var1, int var3);

        public void cached(long var1, int var3);

        public void markedAsUsed(long var1, int var3);

        public void markedAsDeleted(long var1, int var3);

        public void markedAsFree(long var1, int var3);

        public void markedAsReserved(long var1, int var3);

        public void markedAsUnreserved(long var1, int var3);

        public void markSessionDone();

        public void normalized(long var1);

        public void bridged(long var1, long var3);

        public void checkpoint(long var1, long var3);

        public void clearingCache();

        public void clearedCache();

        public void skippedIdsAtHighId(long var1, int var3);

        public void skippedIdsAtAllocation(long var1, int var3);

        public static class Adapter
        implements Monitor {
            @Override
            public void opened(long highestWrittenId, long highId, long numUnusedIds) {
            }

            @Override
            public void allocatedFromHigh(long allocatedId, int numberOfIds) {
            }

            @Override
            public void allocatedFromReused(long allocatedId, int numberOfIds) {
            }

            @Override
            public void cached(long cachedId, int numberOfIds) {
            }

            @Override
            public void markedAsUsed(long markedId, int numberOfIds) {
            }

            @Override
            public void markedAsDeleted(long markedId, int numberOfIds) {
            }

            @Override
            public void markedAsFree(long markedId, int numberOfIds) {
            }

            @Override
            public void markedAsReserved(long markedId, int numberOfIds) {
            }

            @Override
            public void markedAsUnreserved(long markedId, int numberOfIds) {
            }

            @Override
            public void markSessionDone() {
            }

            @Override
            public void normalized(long idRange) {
            }

            @Override
            public void bridged(long bridgedId, long numberOfIds) {
            }

            @Override
            public void checkpoint(long highestWrittenId, long highId) {
            }

            @Override
            public void clearingCache() {
            }

            @Override
            public void clearedCache() {
            }

            @Override
            public void skippedIdsAtHighId(long firstSkippedId, int numberOfIds) {
            }

            @Override
            public void skippedIdsAtAllocation(long firstWastedId, int numberOfIds) {
            }

            @Override
            public void close() {
            }
        }
    }
}

