/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;

class IdRangeMarker
implements IdGenerator.TransactionalMarker,
IdGenerator.ContextualMarker {
    private static final int TYPE_NONE = 0;
    private static final int TYPE_USED = 1;
    private static final int TYPE_DELETED = 2;
    private static final int TYPE_RESERVED = 3;
    private static final int TYPE_UNRESERVED = 4;
    private static final int TYPE_UNCACHED = 5;
    private static final int TYPE_FREE = 6;
    private static final int TYPE_DELETED_AND_FREE = 7;
    private static final int TYPE_UNALLOCATED = 8;
    private static final int TYPE_BRIDGED = 9;
    private final int idsPerEntry;
    private final int idsPerEntryShift;
    private final int idOffsetMask;
    private final Writer<IdRangeKey, IdRange> writer;
    private final Lock lock;
    private final ValueMerger<IdRangeKey, IdRange> merger;
    private final boolean started;
    private final AtomicInteger freeIdsNotifier;
    private final long generation;
    private final AtomicLong highestWrittenId;
    private final boolean bridgeIdGaps;
    private final boolean deleteAlsoFrees;
    private final IdRangeKey key;
    private final IdRange value;
    private final IndexedIdGenerator.Monitor monitor;
    private final boolean respectsReservedIds;
    private int type = 0;

    IdRangeMarker(IdType idType, int idsPerEntry, Layout<IdRangeKey, IdRange> layout, Writer<IdRangeKey, IdRange> writer, Lock lock, ValueMerger<IdRangeKey, IdRange> merger, boolean started, AtomicInteger freeIdsNotifier, long generation, AtomicLong highestWrittenId, boolean bridgeIdGaps, boolean deleteAlsoFrees, IndexedIdGenerator.Monitor monitor) {
        this.respectsReservedIds = idType.respectsReservedId();
        this.idsPerEntry = idsPerEntry;
        this.writer = writer;
        this.key = (IdRangeKey)layout.newKey();
        this.value = (IdRange)layout.newValue();
        this.lock = lock;
        this.merger = merger;
        this.started = started;
        this.freeIdsNotifier = freeIdsNotifier;
        this.generation = generation;
        this.highestWrittenId = highestWrittenId;
        this.bridgeIdGaps = bridgeIdGaps;
        this.deleteAlsoFrees = deleteAlsoFrees;
        this.monitor = monitor;
        this.idsPerEntryShift = Long.numberOfTrailingZeros(idsPerEntry);
        this.idOffsetMask = (1 << this.idsPerEntryShift) - 1;
    }

    @Override
    public void close() {
        try {
            try {
                this.flushRange();
            }
            finally {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
            this.monitor.markSessionDone();
        }
    }

    @Override
    public void flush() {
        this.flushRange();
        this.writer.yield();
    }

    private boolean hasReservedIdInRange(long startIdInclusive, long endIdExclusive) {
        return this.respectsReservedIds && IdValidator.hasReservedIdInRange(startIdInclusive, endIdExclusive);
    }

    @Override
    public void markUsed(long id, int numberOfIds) {
        this.bridgeGapBetweenHighestWrittenIdAndThisId(id, numberOfIds, false);
        if (!this.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(1, id, false);
            this.value.setBits(-1, this.idOffset(id), numberOfIds);
            this.monitor.markedAsUsed(id, numberOfIds);
        }
    }

    @Override
    public void markDeleted(long id, int numberOfIds) {
        if (!this.deleteAlsoFrees) {
            if (!this.hasReservedIdInRange(id, id + (long)numberOfIds)) {
                this.prepareRange(2, id, true);
                this.value.setBits(0, this.idOffset(id), numberOfIds);
                this.monitor.markedAsDeleted(id, numberOfIds);
            }
        } else {
            this.markDeletedAndFree(id, numberOfIds);
        }
    }

    @Override
    public void markReserved(long id, int numberOfIds) {
        if (!this.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(3, id, true);
            this.value.setBits(2, this.idOffset(id), numberOfIds);
            this.monitor.markedAsReserved(id, numberOfIds);
        }
    }

    @Override
    public void markUnreserved(long id, int numberOfIds) {
        if (!this.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(4, id, false);
            this.value.setBits(2, this.idOffset(id), numberOfIds);
            this.monitor.markedAsUnreserved(id, numberOfIds);
        }
    }

    @Override
    public void markUncached(long id, int numberOfIds) {
        if (!this.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(5, id, (byte)2);
            int idOffset = this.idOffset(id);
            this.value.setBits(1, idOffset, numberOfIds);
            this.value.setBits(2, idOffset, numberOfIds);
            this.monitor.markedAsFree(id, numberOfIds);
            this.monitor.markedAsUnreserved(id, numberOfIds);
        }
    }

    @Override
    public void markFree(long id, int numberOfIds) {
        if (!this.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(6, id, true);
            this.value.setBits(1, this.idOffset(id), numberOfIds);
            this.monitor.markedAsFree(id, numberOfIds);
        }
    }

    @Override
    public void markDeletedAndFree(long id, int numberOfIds) {
        if (!this.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(7, id, true);
            int idOffset = this.idOffset(id);
            this.value.setBits(0, idOffset, numberOfIds);
            this.value.setBits(1, idOffset, numberOfIds);
            this.monitor.markedAsDeleted(id, numberOfIds);
            this.monitor.markedAsFree(id, numberOfIds);
        }
    }

    @Override
    public void markUnallocated(long id, int numberOfIds) {
        this.bridgeGapBetweenHighestWrittenIdAndThisId(id, numberOfIds, true);
        if (!this.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.markWithSupportForLargerThanRange(8, id, numberOfIds, (byte)2, 1, 2);
            this.monitor.markedAsFree(id, numberOfIds);
            this.monitor.markedAsUnreserved(id, numberOfIds);
        }
    }

    private void markWithSupportForLargerThanRange(int type, long id, long numberOfIds, byte addition, int firstBitSet, int secondBitSet) {
        int idOffset = this.idOffset(id);
        while (numberOfIds > 0L) {
            this.prepareRange(type, id, addition);
            int numberOfIdsInThisRange = (int)Math.min(numberOfIds, (long)(this.idsPerEntry - idOffset));
            this.value.setBits(firstBitSet, idOffset, numberOfIdsInThisRange);
            if (secondBitSet != -1) {
                this.value.setBits(secondBitSet, idOffset, numberOfIdsInThisRange);
            }
            idOffset = 0;
            id += (long)numberOfIdsInThisRange;
            numberOfIds -= (long)numberOfIdsInThisRange;
        }
    }

    private void prepareRange(int newType, long id, boolean addition) {
        this.prepareRange(newType, id, addition ? (byte)7 : 0);
    }

    private void prepareRange(int newType, long id, byte addition) {
        long idRangeIdx = this.idRangeIndex(id);
        if (newType != this.type || idRangeIdx != this.key.getIdRangeIdx()) {
            this.flushRange();
            this.type = newType;
            this.key.setIdRangeIdx(idRangeIdx);
            this.value.clear(this.generation, addition);
        }
    }

    private void flushRange() {
        if (this.type == 1) {
            this.writer.mergeIfExists((Object)this.key, (Object)this.value, this.merger);
        } else if (this.type != 0) {
            this.writer.merge((Object)this.key, (Object)this.value, this.merger);
            if (this.type == 6 || this.type == 7 || this.type == 8) {
                this.freeIdsNotifier.incrementAndGet();
            }
        }
        this.type = 0;
    }

    private long idRangeIndex(long id) {
        return id >> this.idsPerEntryShift;
    }

    private int idOffset(long id) {
        return (int)(id & (long)this.idOffsetMask);
    }

    private void bridgeGapBetweenHighestWrittenIdAndThisId(long id, int numberOfIds, boolean includeThis) {
        long to;
        long highestWrittenId = this.highestWrittenId.get();
        long l = to = includeThis ? id + (long)numberOfIds : id;
        if (this.bridgeIdGaps && highestWrittenId < to) {
            if (highestWrittenId < to - 1L) {
                long bridgeId = highestWrittenId + 1L;
                long bridgeNumberOfIds = to - bridgeId;
                if (this.hasReservedIdInRange(bridgeId, bridgeId + bridgeNumberOfIds)) {
                    long idsBefore = 0xFFFFFFFFL - bridgeId;
                    if (idsBefore > 0L) {
                        this.markWithSupportForLargerThanRange(9, bridgeId, idsBefore, (byte)7, 0, this.started ? -1 : 1);
                        this.monitor.bridged(bridgeId, idsBefore);
                    }
                    bridgeId += idsBefore + 1L;
                    bridgeNumberOfIds -= idsBefore + 1L;
                }
                this.markWithSupportForLargerThanRange(9, bridgeId, bridgeNumberOfIds, (byte)7, 0, this.started ? -1 : 1);
                this.monitor.bridged(bridgeId, bridgeNumberOfIds);
            }
            this.highestWrittenId.set(id + (long)numberOfIds - 1L);
        }
    }
}

