/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import org.neo4j.util.Preconditions;

public interface IdSlotDistribution {
    public static final IdSlotDistribution SINGLE_IDS = new IdSlotDistribution(){

        @Override
        public Slot[] slots(int capacity) {
            return new Slot[]{new Slot(capacity, 1)};
        }

        @Override
        public int maxSlotSize() {
            return 1;
        }
    };

    public static IdSlotDistribution evenSlotDistribution(int ... slotSizes) {
        return IdSlotDistribution.evenSlotDistribution(128, slotSizes);
    }

    public static IdSlotDistribution evenSlotDistribution(int idsPerEntry, final int ... slotSizes) {
        return new BaseIdSlotDistribution(idsPerEntry, slotSizes){

            @Override
            public Slot[] slots(int capacity) {
                Slot[] slots = new Slot[slotSizes.length];
                int capacityPerSlot = this.nearestHigherPowerOfTwo(capacity / slotSizes.length);
                for (int i = 0; i < slotSizes.length; ++i) {
                    slots[i] = new Slot(capacityPerSlot, slotSizes[i]);
                }
                return slots;
            }

            private int nearestHigherPowerOfTwo(int value) {
                return Integer.bitCount(value) == 1 ? value : Integer.highestOneBit(value) << 1;
            }
        };
    }

    public static IdSlotDistribution diminishingSlotDistribution(int ... slotSizes) {
        return IdSlotDistribution.diminishingSlotDistribution(128, slotSizes);
    }

    public static IdSlotDistribution diminishingSlotDistribution(int idsPerEntry, final int ... slotSizes) {
        return new BaseIdSlotDistribution(idsPerEntry, slotSizes){

            @Override
            public Slot[] slots(int capacity) {
                Slot[] slots = new Slot[slotSizes.length];
                for (int i = 0; i < slotSizes.length; ++i) {
                    slots[i] = new Slot(capacity / (1 << i + 1), slotSizes[i]);
                }
                return slots;
            }
        };
    }

    public static IdSlotDistribution allWithSameCapacity(int ... slotSizes) {
        return IdSlotDistribution.allWithSameCapacity(128, slotSizes);
    }

    public static IdSlotDistribution allWithSameCapacity(int idsPerEntry, final int ... slotSizes) {
        return new BaseIdSlotDistribution(idsPerEntry, slotSizes){

            @Override
            public Slot[] slots(int capacity) {
                Slot[] slots = new Slot[slotSizes.length];
                for (int i = 0; i < slotSizes.length; ++i) {
                    slots[i] = new Slot(capacity, slotSizes[i]);
                }
                return slots;
            }
        };
    }

    public static int[] powerTwoSlotSizesDownwards(int highSlotSize) {
        Preconditions.checkArgument((Integer.bitCount(highSlotSize) == 1 ? 1 : 0) != 0, (String)"Requires a power of two");
        int[] slots = new int[Integer.numberOfTrailingZeros(highSlotSize) + 1];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = 1 << i;
        }
        return slots;
    }

    public Slot[] slots(int var1);

    public int maxSlotSize();

    default public int idsPerEntry() {
        return 128;
    }

    public static abstract class BaseIdSlotDistribution
    implements IdSlotDistribution {
        private final int idsPerEntry;
        private final int[] slotSizes;

        BaseIdSlotDistribution(int idsPerEntry, int[] slotSizes) {
            this.idsPerEntry = idsPerEntry;
            this.slotSizes = slotSizes;
        }

        @Override
        public int idsPerEntry() {
            return this.idsPerEntry;
        }

        @Override
        public int maxSlotSize() {
            return this.slotSizes[this.slotSizes.length - 1];
        }
    }

    public record Slot(int capacity, int slotSize) {
    }
}

