/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Set;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.function.ThrowingIntFunction;
import org.neo4j.internal.id.BufferedIds;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableChannel;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

class DiskBufferedIds
implements BufferedIds {
    static final int DEFAULT_SEGMENT_SIZE = (int)ByteUnit.mebiBytes((long)50L);
    private static final int INITIAL_SEGMENT_ID = 0;
    private static final byte HEADER_CHUNK = 1;
    private final FileSystemAbstraction fs;
    private final Path basePath;
    private final MemoryTracker memoryTracker;
    private final int segmentSize;
    private volatile Position<PhysicalFlushableChannel> writePosition;
    private volatile Position<ReadAheadChannel<StoreChannel>> readPosition;

    DiskBufferedIds(FileSystemAbstraction fs, Path basePath, MemoryTracker memoryTracker, int segmentSize) throws IOException {
        this.fs = fs;
        this.basePath = basePath;
        this.memoryTracker = memoryTracker;
        this.segmentSize = segmentSize;
        this.clearExistingSegments();
        this.writePosition = new Position<PhysicalFlushableChannel>(this.openSegmentForWriting(0), 0, 0L);
        this.readPosition = new Position<ReadAheadChannel<StoreChannel>>(this.openSegmentForReading(0), 0, 0L);
    }

    private PhysicalFlushableChannel openSegmentForWriting(int segmentId) throws IOException {
        return new PhysicalFlushableChannel(this.fs.open(this.segmentName(segmentId), Set.of(StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE)), (ScopedBuffer)new NativeScopedBuffer(PhysicalFlushableChannel.DEFAULT_BUFFER_SIZE, ByteOrder.LITTLE_ENDIAN, this.memoryTracker));
    }

    private ReadAheadChannel<StoreChannel> openSegmentForReading(int segmentId) throws IOException {
        return new ReadAheadChannel(this.fs.open(this.segmentName(segmentId), Set.of(StandardOpenOption.READ)), (ScopedBuffer)new NativeScopedBuffer(ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE, ByteOrder.LITTLE_ENDIAN, this.memoryTracker));
    }

    @VisibleForTesting
    Path segmentName(int segmentId) {
        return this.basePath.resolveSibling(this.basePath.getFileName().toString() + "." + segmentId);
    }

    @Override
    public void write(IdController.TransactionSnapshot snapshot, List<BufferingIdGeneratorFactory.IdBuffer> idBuffers) throws IOException {
        PhysicalFlushableChannel segment = (PhysicalFlushableChannel)this.writePosition.segment;
        segment.position(this.writePosition.offset);
        segment.put((byte)1);
        segment.putLong(snapshot.snapshotTimeMillis());
        segment.putLong(snapshot.lastCommittedTransactionId());
        long currentSequenceNumber = snapshot.currentSequenceNumber();
        segment.putLong(currentSequenceNumber);
        segment.putInt(idBuffers.size());
        for (BufferingIdGeneratorFactory.IdBuffer buffer : idBuffers) {
            segment.putInt(buffer.idTypeOrdinal());
            segment.putInt(buffer.ids().size());
            PrimitiveLongResourceIterator idIterator = buffer.ids().iterator();
            while (idIterator.hasNext()) {
                segment.putLong(idIterator.next());
            }
        }
        segment.prepareForFlush();
        this.writePosition = this.checkRotate(this.writePosition, segment.position(), this::openSegmentForWriting);
        IOUtils.closeAll(idBuffers);
    }

    @Override
    public void read(BufferedIds.BufferedIdVisitor visitor) throws IOException {
        while (this.hasMoreToRead()) {
            ReadAheadChannel segment = (ReadAheadChannel)this.readPosition.segment;
            segment.setCurrentPosition(this.readPosition.offset);
            byte header = segment.get();
            Preconditions.checkState((header == 1 ? 1 : 0) != 0, (String)"Expecting to read header, but instead read %d", (Object[])new Object[]{header});
            long timeMillis = segment.getLong();
            long lastCommittedTxId = segment.getLong();
            long transactionSequenceNumber = segment.getLong();
            if (!visitor.startChunk(new IdController.TransactionSnapshot(transactionSequenceNumber, timeMillis, lastCommittedTxId))) break;
            this.processChunk(visitor, (ReadAheadChannel<StoreChannel>)segment);
            this.readPosition = this.checkRotate(this.readPosition, segment.position(), segmentId -> {
                this.fs.deleteFile(this.segmentName(segmentId - 1));
                return this.openSegmentForReading(segmentId);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChunk(BufferedIds.BufferedIdVisitor visitor, ReadAheadChannel<StoreChannel> segment) throws IOException {
        try {
            int numIdTypes = segment.getInt();
            for (int t = 0; t < numIdTypes; ++t) {
                int idTypeOrdinal = segment.getInt();
                visitor.startType(idTypeOrdinal);
                try {
                    int numIds = segment.getInt();
                    for (int i = 0; i < numIds; ++i) {
                        long id = segment.getLong();
                        visitor.id(id);
                    }
                    continue;
                }
                finally {
                    visitor.endType();
                }
            }
        }
        finally {
            visitor.endChunk();
        }
    }

    private <CHANNEL extends Closeable> Position<CHANNEL> checkRotate(Position<CHANNEL> position, long offset, ThrowingIntFunction<CHANNEL, IOException> segmentFactory) throws IOException {
        Object segment = position.segment;
        int segmentId = position.segmentId;
        if (offset > (long)this.segmentSize) {
            segment.close();
            segment = (Closeable)segmentFactory.apply(++segmentId);
            offset = 0L;
        }
        return new Position(segment, segmentId, offset);
    }

    private boolean hasMoreToRead() {
        int positionComparison = this.comparePositions(this.readPosition, this.writePosition);
        Preconditions.checkState((positionComparison <= 0 ? 1 : 0) != 0, (String)("readPosition:" + this.readPosition + " writePosition:" + this.writePosition));
        return positionComparison < 0;
    }

    private int comparePositions(Position<?> left, Position<?> right) {
        int segmentIdComparison = Integer.compare(left.segmentId, right.segmentId);
        return segmentIdComparison != 0 ? segmentIdComparison : Long.compare(left.offset, right.offset);
    }

    private void clearExistingSegments() throws IOException {
        Path[] existing;
        try {
            existing = this.fs.listFiles(this.basePath.getParent(), entry -> !this.fs.isDirectory(entry) && entry.getFileName().toString().startsWith(this.basePath.getFileName().toString() + "."));
        }
        catch (NoSuchFileException e) {
            return;
        }
        for (Path path : existing) {
            this.fs.deleteFile(path);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.writePosition.segment, this.readPosition.segment});
        this.clearExistingSegments();
    }

    private record Position<CHANNEL extends Closeable>(CHANNEL segment, int segmentId, long offset) {
    }
}

