/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;

class IdRangeMarker
implements IndexedIdGenerator.InternalMarker {
    private final int idsPerEntry;
    private final Writer<IdRangeKey, IdRange> writer;
    private final Lock lock;
    private final ValueMerger<IdRangeKey, IdRange> merger;
    private final boolean started;
    private final AtomicBoolean freeIdsNotifier;
    private final long generation;
    private final AtomicLong highestWrittenId;
    private final boolean bridgeIdGaps;
    private final IdRangeKey key;
    private final IdRange value;
    private final IndexedIdGenerator.Monitor monitor;

    IdRangeMarker(int idsPerEntry, Layout<IdRangeKey, IdRange> layout, Writer<IdRangeKey, IdRange> writer, Lock lock, ValueMerger<IdRangeKey, IdRange> merger, boolean started, AtomicBoolean freeIdsNotifier, long generation, AtomicLong highestWrittenId, boolean bridgeIdGaps, IndexedIdGenerator.Monitor monitor) {
        this.idsPerEntry = idsPerEntry;
        this.writer = writer;
        this.key = (IdRangeKey)layout.newKey();
        this.value = (IdRange)layout.newValue();
        this.lock = lock;
        this.merger = merger;
        this.started = started;
        this.freeIdsNotifier = freeIdsNotifier;
        this.generation = generation;
        this.highestWrittenId = highestWrittenId;
        this.bridgeIdGaps = bridgeIdGaps;
        this.monitor = monitor;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.lock.unlock();
            this.monitor.markSessionDone();
        }
    }

    @Override
    public void markUsed(long id, int numberOfIds) {
        this.bridgeGapBetweenHighestWrittenIdAndThisId(id, numberOfIds, false);
        if (!IdValidator.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(id, false);
            this.value.setBitsForAllTypes(this.idOffset(id), numberOfIds);
            this.writer.mergeIfExists((Object)this.key, (Object)this.value, this.merger);
            this.monitor.markedAsUsed(id, numberOfIds);
        }
    }

    @Override
    public void markDeleted(long id, int numberOfIds) {
        if (!IdValidator.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(id, true);
            this.value.setBits(0, this.idOffset(id), numberOfIds);
            this.writer.merge((Object)this.key, (Object)this.value, this.merger);
            this.monitor.markedAsDeleted(id, numberOfIds);
        }
    }

    @Override
    public void markReserved(long id, int numberOfIds) {
        if (!IdValidator.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(id, true);
            this.value.setBits(2, this.idOffset(id), numberOfIds);
            this.writer.merge((Object)this.key, (Object)this.value, this.merger);
            this.monitor.markedAsReserved(id, numberOfIds);
        }
    }

    @Override
    public void markUnreserved(long id, int numberOfIds) {
        if (!IdValidator.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(id, false);
            this.value.setBits(2, this.idOffset(id), numberOfIds);
            this.writer.merge((Object)this.key, (Object)this.value, this.merger);
            this.monitor.markedAsUnreserved(id);
        }
    }

    @Override
    public void markFree(long id, int numberOfIds) {
        if (!IdValidator.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(id, true);
            this.value.setBits(1, this.idOffset(id), numberOfIds);
            this.writer.merge((Object)this.key, (Object)this.value, this.merger);
            this.monitor.markedAsFree(id, numberOfIds);
        }
        this.freeIdsNotifier.set(true);
    }

    @Override
    public void markDeletedAndFree(long id, int numberOfIds) {
        if (!IdValidator.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.prepareRange(id, true);
            this.value.setBits(0, this.idOffset(id), numberOfIds);
            this.value.setBits(1, this.idOffset(id), numberOfIds);
            this.writer.merge((Object)this.key, (Object)this.value, this.merger);
            this.monitor.markedAsDeleted(id, numberOfIds);
            this.monitor.markedAsFree(id, numberOfIds);
        }
        this.freeIdsNotifier.set(true);
    }

    @Override
    public void markUnallocated(long id, int numberOfIds) {
        this.bridgeGapBetweenHighestWrittenIdAndThisId(id, numberOfIds, true);
        if (!IdValidator.hasReservedIdInRange(id, id + (long)numberOfIds)) {
            this.key.setIdRangeIdx(this.idRangeIndex(id));
            this.value.clear(this.generation, true, true, false);
            int idOffset = this.idOffset(id);
            this.value.setBits(1, idOffset, numberOfIds);
            this.value.setBits(2, idOffset, numberOfIds);
            this.writer.merge((Object)this.key, (Object)this.value, this.merger);
            this.monitor.markedAsFree(id, numberOfIds);
        }
        this.freeIdsNotifier.set(true);
    }

    private void prepareRange(long id, boolean addition) {
        this.key.setIdRangeIdx(this.idRangeIndex(id));
        this.value.clear(this.generation, addition);
    }

    private long idRangeIndex(long id) {
        return id / (long)this.idsPerEntry;
    }

    private int idOffset(long id) {
        return (int)(id % (long)this.idsPerEntry);
    }

    private void bridgeGapBetweenHighestWrittenIdAndThisId(long id, int numberOfIds, boolean includeThis) {
        long to;
        long highestWrittenId = this.highestWrittenId.get();
        long l = to = includeThis ? id + (long)numberOfIds : id;
        if (this.bridgeIdGaps && highestWrittenId < to) {
            this.key.setIdRangeIdx(-1L);
            boolean dirty = false;
            while (highestWrittenId < to - 1L) {
                long bridgeId;
                if (IdValidator.isReservedId(bridgeId = ++highestWrittenId)) continue;
                if (this.idRangeIndex(bridgeId) != this.key.getIdRangeIdx()) {
                    if (this.key.getIdRangeIdx() != -1L) {
                        this.writer.merge((Object)this.key, (Object)this.value, this.merger);
                    }
                    this.prepareRange(bridgeId, true);
                }
                this.value.setBits(0, this.idOffset(bridgeId), 1);
                if (!this.started) {
                    this.value.setBits(1, this.idOffset(bridgeId), 1);
                }
                dirty = true;
                this.monitor.bridged(bridgeId);
            }
            if (dirty) {
                this.writer.merge((Object)this.key, (Object)this.value, this.merger);
            }
            this.highestWrittenId.set(id + (long)numberOfIds - 1L);
        }
    }
}

