/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.List;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;

class BufferingIdGenerator
extends IdGenerator.Delegate {
    private final int idTypeOrdinal;
    private final MemoryTracker memoryTracker;
    private final Runnable collector;
    private HeapTrackingLongArrayList bufferedDeletedIds;

    BufferingIdGenerator(IdGenerator delegate, int idTypeOrdinal, MemoryTracker memoryTracker, Runnable collector) {
        super(delegate);
        this.idTypeOrdinal = idTypeOrdinal;
        this.memoryTracker = memoryTracker;
        this.collector = collector;
        this.newFreeBuffer();
    }

    private void newFreeBuffer() {
        this.bufferedDeletedIds = HeapTrackingLongArrayList.newLongArrayList((int)10, (MemoryTracker)this.memoryTracker);
    }

    @Override
    public IdGenerator.Marker marker(CursorContext cursorContext) {
        return new IdGenerator.Marker.Delegate(super.marker(cursorContext)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markDeleted(long id, int numberOfIds) {
                this.actual.markDeleted(id, numberOfIds);
                BufferingIdGenerator bufferingIdGenerator = BufferingIdGenerator.this;
                synchronized (bufferingIdGenerator) {
                    BufferingIdGenerator.this.bufferedDeletedIds.add(IdUtils.combinedIdAndNumberOfIds(id, numberOfIds, false));
                }
                if (BufferingIdGenerator.this.bufferedDeletedIds.size() > 10000) {
                    BufferingIdGenerator.this.collector.run();
                }
            }
        };
    }

    synchronized void collectBufferedIds(List<BufferingIdGeneratorFactory.IdBuffer> idBuffers) {
        if (!this.bufferedDeletedIds.isEmpty()) {
            idBuffers.add(new BufferingIdGeneratorFactory.IdBuffer(this.idTypeOrdinal, this.bufferedDeletedIds));
            this.newFreeBuffer();
        }
    }
}

