/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.util.VisibleForTesting;

public interface IdGenerator
extends IdSequence,
Closeable,
ConsistencyCheckable {
    public static final Marker NOOP_MARKER = new Marker(){

        @Override
        public void markFree(long id, int numberOfIds) {
        }

        @Override
        public void markUsed(long id, int numberOfIds) {
        }

        @Override
        public void markDeleted(long id, int numberOfIds) {
        }

        @Override
        public void markDeletedAndFree(long id, int numberOfIds) {
        }

        @Override
        public void markUnallocated(long id, int numberOfIds) {
        }

        @Override
        public void close() {
        }
    };

    @Override
    public long nextId(CursorContext var1);

    public long nextConsecutiveIdRange(int var1, boolean var2, CursorContext var3);

    public void setHighId(long var1);

    default public void setHighestPossibleIdInUse(long highestInUse) {
        this.setHighId(highestInUse + 1L);
    }

    public void markHighestWrittenAtHighId();

    @VisibleForTesting
    public long getHighestWritten();

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public Marker marker(CursorContext var1);

    @Override
    public void close();

    public void checkpoint(FileFlushEvent var1, CursorContext var2);

    public void maintenance(CursorContext var1);

    public void start(FreeIds var1, CursorContext var2) throws IOException;

    public void clearCache(CursorContext var1);

    public IdType idType();

    public boolean hasOnlySingleIds();

    default public PrimitiveLongResourceIterator freeIdsIterator() throws IOException {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    default public PrimitiveLongResourceIterator freeIdsIterator(long fromIdInclusive, long toIdExclusive) throws IOException {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    public static interface Marker
    extends AutoCloseable {
        default public void markUsed(long id) {
            this.markUsed(id, 1);
        }

        public void markUsed(long var1, int var3);

        default public void markDeleted(long id) {
            this.markDeleted(id, 1);
        }

        public void markDeleted(long var1, int var3);

        default public void markFree(long id) {
            this.markFree(id, 1);
        }

        public void markFree(long var1, int var3);

        default public void markDeletedAndFree(long id) {
            this.markDeletedAndFree(id, 1);
        }

        public void markDeletedAndFree(long var1, int var3);

        default public void markUnallocated(long id) {
            this.markUnallocated(id, 1);
        }

        public void markUnallocated(long var1, int var3);

        @Override
        public void close();

        public static class Delegate
        implements Marker {
            protected final Marker actual;

            Delegate(Marker actual) {
                this.actual = actual;
            }

            @Override
            public void markUsed(long id, int numberOfIds) {
                this.actual.markUsed(id, numberOfIds);
            }

            @Override
            public void markDeleted(long id, int numberOfIds) {
                this.actual.markDeleted(id, numberOfIds);
            }

            @Override
            public void markFree(long id, int numberOfIds) {
                this.actual.markFree(id, numberOfIds);
            }

            @Override
            public void markDeletedAndFree(long id, int numberOfIds) {
                this.actual.markDeletedAndFree(id, numberOfIds);
            }

            @Override
            public void markUnallocated(long id, int numberOfIds) {
                this.actual.markUnallocated(id, numberOfIds);
            }

            @Override
            public void close() {
                this.actual.close();
            }
        }
    }

    public static class Delegate
    implements IdGenerator {
        protected final IdGenerator delegate;

        public Delegate(IdGenerator delegate) {
            this.delegate = delegate;
        }

        @Override
        public long nextId(CursorContext cursorContext) {
            return this.delegate.nextId(cursorContext);
        }

        @Override
        public long nextConsecutiveIdRange(int numberOfIds, boolean favorSamePage, CursorContext cursorContext) {
            return this.delegate.nextConsecutiveIdRange(numberOfIds, favorSamePage, cursorContext);
        }

        @Override
        public void setHighId(long id) {
            this.delegate.setHighId(id);
        }

        @Override
        public void markHighestWrittenAtHighId() {
            this.delegate.markHighestWrittenAtHighId();
        }

        @Override
        public long getHighestWritten() {
            return this.delegate.getHighestWritten();
        }

        @Override
        public long getHighId() {
            return this.delegate.getHighId();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.delegate.getHighestPossibleIdInUse();
        }

        @Override
        public Marker marker(CursorContext cursorContext) {
            return this.delegate.marker(cursorContext);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void checkpoint(FileFlushEvent fileFlushEvent, CursorContext cursorContext) {
            this.delegate.checkpoint(fileFlushEvent, cursorContext);
        }

        @Override
        public void maintenance(CursorContext cursorContext) {
            this.delegate.maintenance(cursorContext);
        }

        @Override
        public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) throws IOException {
            this.delegate.start(freeIdsForRebuild, cursorContext);
        }

        @Override
        public void clearCache(CursorContext cursorContext) {
            this.delegate.clearCache(cursorContext);
        }

        @Override
        public IdType idType() {
            return this.delegate.idType();
        }

        @Override
        public boolean hasOnlySingleIds() {
            return this.delegate.hasOnlySingleIds();
        }

        @Override
        public PrimitiveLongResourceIterator freeIdsIterator() throws IOException {
            return this.delegate.freeIdsIterator();
        }

        @Override
        public PrimitiveLongResourceIterator freeIdsIterator(long fromIdInclusive, long toIdExclusive) throws IOException {
            return this.delegate.freeIdsIterator(fromIdInclusive, toIdExclusive);
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
            return this.delegate.consistencyCheck(reporterFactory, contextFactory, numThreads, progressMonitorFactory);
        }
    }
}

