/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.range;

import java.util.Arrays;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.range.PageIdRange;

public class ArrayBasedRange
implements PageIdRange {
    private final long[] ids;
    private int cursor = 0;

    public ArrayBasedRange(long[] ids) {
        this.ids = ids;
    }

    @Override
    public long nextId() {
        return this.ids[this.cursor++];
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.ids.length;
    }

    @Override
    public void unallocate(IdGenerator.TransactionalMarker marker) {
        while (this.hasNext()) {
            marker.markUnallocated(this.nextId());
        }
    }

    public String toString() {
        return "ArrayBasedRange{ids=" + Arrays.toString(this.ids) + ", cursor=" + this.cursor + "}";
    }
}

