/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.range;

import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.range.PageIdRange;

public class ContinuousIdRange
implements PageIdRange {
    private final long rangeStart;
    private final int rangeSize;
    private int cursor = 0;

    public ContinuousIdRange(long rangeStart, int rangeSize) {
        this.rangeStart = rangeStart;
        this.rangeSize = rangeSize;
    }

    @Override
    public long nextId() {
        return this.rangeStart + (long)this.cursor++;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.rangeSize;
    }

    @Override
    public void unallocate(IdGenerator.TransactionalMarker marker) {
        while (this.hasNext()) {
            marker.markUnallocated(this.nextId());
        }
    }

    public String toString() {
        return "ContinuousIdRange{rangeStart=" + this.rangeStart + ", rangeSize=" + this.rangeSize + ", cursor=" + this.cursor + "}";
    }
}

