/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api;

import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.neo4j.internal.schema.IndexType;

public class IndexConfig {
    private final MutableSet<IndexType> excludedIndexTypes = Sets.mutable.empty();
    private boolean createLabelIndex;
    private boolean createRelationTypeIndex;

    public IndexConfig withLabelIndex() {
        this.createLabelIndex = true;
        return this;
    }

    public IndexConfig withRelationshipTypeIndex() {
        this.createRelationTypeIndex = true;
        return this;
    }

    public IndexConfig excludeTypeFromPopulating(IndexType indexType) {
        this.excludedIndexTypes.add((Object)indexType);
        return this;
    }

    public boolean createLabelIndex() {
        return this.createLabelIndex;
    }

    public boolean createRelationshipIndex() {
        return this.createRelationTypeIndex;
    }

    public boolean isTypeExcludedFromPopulating(IndexType type) {
        return this.excludedIndexTypes.contains((Object)type);
    }

    public static IndexConfig create() {
        return new IndexConfig();
    }
}

