/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api.input;

import java.util.Map;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.common.EntityType;

public interface Collector
extends AutoCloseable {
    public static final Collector EMPTY = new Collector(){

        @Override
        public void collectExtraColumns(String source, long row, String value) {
        }

        @Override
        public void close() {
        }

        @Override
        public long badEntries() {
            return 0L;
        }

        @Override
        public void collectBadRelationship(Object startId, Group startIdGroup, Object type, Object endId, Group endIdGroup, Object specificValue) {
        }

        @Override
        public void collectDuplicateNode(Object id, long actualId, Group group) {
        }

        @Override
        public void collectEntityViolatingConstraint(Object id, long actualId, Map<String, Object> properties, String constraintDescription, EntityType entityType) {
        }

        @Override
        public void collectRelationshipViolatingConstraint(Map<String, Object> properties, String constraintDescription, Object startId, Group startIdGroup, String type, Object endId, Group endIdGroup) {
        }

        @Override
        public void collectSchemaCommandFailure(EntityType entityType, String failureMessage) {
        }

        @Override
        public void collectOtherNodeViolation(String format, Object ... parameters) {
        }

        @Override
        public void collectOtherRelationshipViolation(String format, Object ... parameters) {
        }

        @Override
        public boolean isCollectingBadRelationships() {
            return true;
        }
    };
    public static final Collector STRICT = new Collector(){

        @Override
        public void collectExtraColumns(String source, long row, String value) {
            throw new IllegalStateException(String.format("Bad extra column '%s' index:%d in '%s'", value, row, source));
        }

        @Override
        public void close() {
        }

        @Override
        public long badEntries() {
            return 0L;
        }

        @Override
        public void collectBadRelationship(Object startId, Group startIdGroup, Object type, Object endId, Group endIdGroup, Object specificValue) {
            throw new IllegalStateException(String.format("Bad relationship (%s:%s)-[%s]->(%s:%s) %s", startId, startIdGroup, type, endId, endIdGroup, specificValue));
        }

        @Override
        public void collectDuplicateNode(Object id, long actualId, Group group) {
            throw new IllegalStateException(String.format("Bad duplicate node %s:%s id:%d", id, group, actualId));
        }

        @Override
        public void collectEntityViolatingConstraint(Object id, long actualId, Map<String, Object> properties, String constraintDescription, EntityType entityType) {
            throw new IllegalStateException(String.format("Bad %s with properties %s violating constraint %s id:%s", entityType == EntityType.NODE ? "node" : "relationship", properties, constraintDescription, id));
        }

        @Override
        public void collectRelationshipViolatingConstraint(Map<String, Object> properties, String constraintDescription, Object startId, Group startIdGroup, String type, Object endId, Group endIdGroup) {
            throw new IllegalStateException(String.format("Bad relationship (%s:%s)-[%s]->(%s:%s) with properties %s violating constraint %s", startId, startIdGroup, type, endId, endIdGroup, properties, constraintDescription));
        }

        @Override
        public void collectSchemaCommandFailure(EntityType entityType, String failureMessage) {
            throw new IllegalStateException(failureMessage);
        }

        @Override
        public void collectOtherNodeViolation(String format, Object ... parameters) {
            throw new IllegalStateException(String.format(format, parameters));
        }

        @Override
        public void collectOtherRelationshipViolation(String format, Object ... parameters) {
            throw new IllegalStateException(String.format(format, parameters));
        }

        @Override
        public boolean isCollectingBadRelationships() {
            return false;
        }
    };

    public void collectBadRelationship(Object var1, Group var2, Object var3, Object var4, Group var5, Object var6);

    public void collectDuplicateNode(Object var1, long var2, Group var4);

    public void collectEntityViolatingConstraint(Object var1, long var2, Map<String, Object> var4, String var5, EntityType var6);

    public void collectRelationshipViolatingConstraint(Map<String, Object> var1, String var2, Object var3, Group var4, String var5, Object var6, Group var7);

    public void collectExtraColumns(String var1, long var2, String var4);

    public void collectSchemaCommandFailure(EntityType var1, String var2);

    public void collectOtherNodeViolation(String var1, Object ... var2);

    public void collectOtherRelationshipViolation(String var1, Object ... var2);

    public long badEntries();

    public boolean isCollectingBadRelationships();

    @Override
    public void close();

    public static class Adapter
    implements Collector {
        @Override
        public void collectBadRelationship(Object startId, Group startIdGroup, Object type, Object endId, Group endIdGroup, Object specificValue) {
        }

        @Override
        public void collectDuplicateNode(Object id, long actualId, Group group) {
        }

        @Override
        public void collectEntityViolatingConstraint(Object id, long actualId, Map<String, Object> properties, String constraintDescription, EntityType entityType) {
        }

        @Override
        public void collectRelationshipViolatingConstraint(Map<String, Object> properties, String constraintDescription, Object startId, Group startIdGroup, String type, Object endId, Group endIdGroup) {
        }

        @Override
        public void collectExtraColumns(String source, long row, String value) {
        }

        @Override
        public void collectSchemaCommandFailure(EntityType entityType, String failureMessage) {
        }

        @Override
        public void collectOtherNodeViolation(String format, Object ... parameters) {
        }

        @Override
        public void collectOtherRelationshipViolation(String format, Object ... parameters) {
        }

        @Override
        public long badEntries() {
            return 0L;
        }

        @Override
        public boolean isCollectingBadRelationships() {
            return false;
        }

        @Override
        public void close() {
        }
    }
}

