/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api;

public interface Monitor {
    public static final Monitor NO_MONITOR = new Monitor(){};

    default public void doubleRelationshipRecordUnitsEnabled() {
    }

    default public void mayExceedNodeIdCapacity(long capacity, long estimatedCount) {
    }

    default public void mayExceedRelationshipIdCapacity(long capacity, long estimatedCount) {
    }

    default public void insufficientHeapSize(long optimalMinimalHeapSize, long heapSize) {
    }

    default public void abundantHeapSize(long optimalMinimalHeapSize, long heapSize) {
    }

    default public void insufficientAvailableMemory(long estimatedCacheSize, long optimalMinimalHeapSize, long availableMemory) {
    }

    default public void started() {
    }

    default public void percentageCompleted(int percentage) {
    }

    default public void completed(boolean success) {
    }

    public static class Delegate
    implements Monitor {
        private final Monitor delegate;

        public Delegate(Monitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void doubleRelationshipRecordUnitsEnabled() {
            this.delegate.doubleRelationshipRecordUnitsEnabled();
        }

        @Override
        public void mayExceedNodeIdCapacity(long capacity, long estimatedCount) {
            this.delegate.mayExceedNodeIdCapacity(capacity, estimatedCount);
        }

        @Override
        public void mayExceedRelationshipIdCapacity(long capacity, long estimatedCount) {
            this.delegate.mayExceedRelationshipIdCapacity(capacity, estimatedCount);
        }

        @Override
        public void insufficientHeapSize(long optimalMinimalHeapSize, long heapSize) {
            this.delegate.insufficientHeapSize(optimalMinimalHeapSize, heapSize);
        }

        @Override
        public void abundantHeapSize(long optimalMinimalHeapSize, long heapSize) {
            this.delegate.abundantHeapSize(optimalMinimalHeapSize, heapSize);
        }

        @Override
        public void insufficientAvailableMemory(long estimatedCacheSize, long optimalMinimalHeapSize, long availableMemory) {
            this.delegate.insufficientAvailableMemory(estimatedCacheSize, optimalMinimalHeapSize, availableMemory);
        }

        @Override
        public void started() {
            this.delegate.started();
        }

        @Override
        public void percentageCompleted(int percentage) {
            this.delegate.percentageCompleted(percentage);
        }

        @Override
        public void completed(boolean success) {
            this.delegate.completed(success);
        }
    }
}

