/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.neo4j.batchimport.api.BatchImporter;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.IncrementalBatchImporter;
import org.neo4j.batchimport.api.IndexConfig;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.UnsupportedFormatException;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.cloud.storage.SchemeFileSystemAbstraction;
import org.neo4j.cloud.storage.StorageUtils;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.importer.CharacterConverter;
import org.neo4j.importer.FileImporter;
import org.neo4j.importer.PrintingImportLogicMonitor;
import org.neo4j.importer.SchemaCommandReader;
import org.neo4j.internal.batchimport.DefaultAdditionalIds;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.locker.FileLockException;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.index.schema.DefaultIndexProvidersAccess;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.DeprecatedFormatWarning;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="import", description={"High-speed import of data from CSV files, optimized for fault-free data."}, subcommands={Full.class, CommandLine.HelpCommand.class})
public class ImportCommand {
    private static final String MULTI_FILE_DELIMITER = ",";
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit."})
    private boolean helpRequested;

    @VisibleForTesting
    static RelationshipFilesGroup parseRelationshipFilesGroup(String str) {
        Pair<String, String> p = ImportCommand.parseInputFilesGroup(str, String::trim);
        return new RelationshipFilesGroup((String)p.getOne(), (String)p.getTwo());
    }

    @VisibleForTesting
    static NodeFilesGroup parseNodeFilesGroup(String str) {
        Pair<Set, String> p = ImportCommand.parseInputFilesGroup(str, s -> Arrays.stream(s.split(":")).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toSet()));
        return new NodeFilesGroup((Set)p.getOne(), (String)p.getTwo());
    }

    private static <T> Pair<T, String> parseInputFilesGroup(String str, Function<String, ? extends T> keyParser) {
        int i = str.indexOf(61);
        if (i < 0) {
            return Tuples.pair(keyParser.apply(""), (Object)str);
        }
        if (i == 0 || i == str.length() - 1) {
            throw new IllegalArgumentException("illegal `=` position: " + str);
        }
        String keyStr = str.substring(0, i);
        return Tuples.pair(keyParser.apply(keyStr), (Object)str.substring(i + 1));
    }

    private static Path[] parseFilesList(FileSystemAbstraction fs, String str) {
        return (Path[])Converters.toFiles((String)MULTI_FILE_DELIMITER, (Function)Converters.regexFiles((FileSystemAbstraction)fs, (boolean)true)).apply(str);
    }

    protected boolean allowEnterpriseFeatures() {
        return false;
    }

    static class RelationshipFilesGroup
    extends InputFilesGroup<String> {
        RelationshipFilesGroup(String key, String files) {
            super(key, files);
        }
    }

    static class NodeFilesGroup
    extends InputFilesGroup<Set<String>> {
        NodeFilesGroup(Set<String> key, String files) {
            super(key, files);
        }
    }

    static enum IncrementalStage {
        prepare,
        build,
        merge,
        all;

    }

    static abstract class InputFilesGroup<T> {
        final T key;
        final String files;

        InputFilesGroup(T key, String files) {
            this.key = key;
            this.files = files;
        }

        Path[] toPaths(FileSystemAbstraction fs) {
            return ImportCommand.parseFilesList(fs, this.files);
        }
    }

    @CommandLine.Command(name="incremental", description={"Incremental import into an existing database."})
    public static class Incremental
    extends Base {
        @CommandLine.Option(names={"--stage"}, paramLabel="all|prepare|build|merge", description={"Stage of incremental import. For incremental import into an existing database use 'all' (which requires the database to be stopped). For semi-online incremental import run 'prepare' (on a stopped database) followed by 'build' (on a potentially running database) and finally 'merge' (on a stopped database)."}, converter={StageConverter.class})
        IncrementalStage stage = IncrementalStage.all;
        @CommandLine.Option(names={"--force"}, required=true, description={"Confirm incremental import by setting this flag."})
        boolean forced;
        @CommandLine.Option(names={"--update-all-matching-relationships"}, paramLabel="true|false", fallbackValue="true", defaultValue="false", description={"If one relationship data entry matches multiple existing relationships, this decides whether to update all matching, or to instead log as error"})
        boolean updateAllMatchingRelationships;

        public Incremental(ExecutionContext ctx) {
            super(ctx);
        }

        public void execute() throws Exception {
            if (!this.forced) {
                System.err.println("ERROR: Incremental import needs to be used with care. Please confirm by specifying --force.");
                throw new IllegalArgumentException("Missing force");
            }
            this.doExecute(true, null, false, layout -> () -> {});
        }

        @Override
        protected SchemaCommandReader.ReaderConfig schemaCommandsReaderConfig(VectorIndexVersion latestVectorIndexVersion) {
            throw new UnsupportedOperationException("Applying schema commands during incremental import is not currently supported");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void doImport(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, Config databaseConfig, JobScheduler jobScheduler, InternalLogProvider logProvider, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory, org.neo4j.batchimport.api.Configuration importConfig, LogService logService, PrintStream stdOut, PrintStream stdErr, boolean verbose, Collector badCollector, MemoryTracker memoryTracker, Input input) throws IOException {
            StorageEngineFactory storageEngineFactory = (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout).orElseThrow();
            try (Lifespan life = new Lifespan(new Lifecycle[0]);){
                DefaultIndexProvidersAccess indexProviders = (DefaultIndexProvidersAccess)life.add((Lifecycle)new DefaultIndexProvidersAccess(storageEngineFactory, fileSystem, databaseConfig, jobScheduler, (LogService)new SimpleLogService(logProvider), pageCacheTracer, contextFactory));
                IncrementalBatchImporter importer = storageEngineFactory.incrementalBatchImporter(databaseLayout, fileSystem, pageCacheTracer, this.withSpecificConfig(importConfig), logService, stdOut, verbose, DefaultAdditionalIds.EMPTY, () -> this.readLogTailMetaData(fileSystem, databaseLayout, storageEngineFactory), databaseConfig, (Monitor)new PrintingImportLogicMonitor(stdOut, stdErr), jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), memoryTracker, contextFactory, (IndexProvidersAccess)indexProviders);
                switch (this.stage.ordinal()) {
                    case 0: {
                        importer.prepare(input);
                        return;
                    }
                    case 1: {
                        importer.build(input);
                        return;
                    }
                    case 2: {
                        importer.merge();
                        return;
                    }
                    case 3: {
                        importer.doImport(input);
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown import mode " + String.valueOf((Object)this.stage));
                    }
                }
            }
        }

        private org.neo4j.batchimport.api.Configuration withSpecificConfig(org.neo4j.batchimport.api.Configuration importConfig) {
            return new Configuration.Overridden(importConfig){

                public boolean updateAllMatchingRelationships() {
                    return updateAllMatchingRelationships;
                }
            };
        }

        static class StageConverter
        implements CommandLine.ITypeConverter<IncrementalStage> {
            StageConverter() {
            }

            public IncrementalStage convert(String in) {
                in = switch (in) {
                    case "1" -> "prepare";
                    case "2" -> "build";
                    case "3" -> "merge";
                    default -> in.toLowerCase(Locale.ROOT);
                };
                try {
                    return IncrementalStage.valueOf(in);
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid stage: %s (%s)", in, e));
                }
            }
        }
    }

    @CommandLine.Command(name="full", description={"High-speed initial import of fault-free data from CSV files into a non-existent or empty database."})
    public static class Full
    extends Base {
        @CommandLine.Option(names={"--format"}, showDefaultValue=CommandLine.Help.Visibility.NEVER, description={"Name of database format. The imported database will be created in the specified format or use the format set in the configuration. Valid formats are `standard`, `aligned`, `high_limit`, and `block`."})
        private String format;
        @CommandLine.Option(names={"--overwrite-destination"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Delete any existing database files prior to the import."})
        private boolean overwriteDestination;

        public Full(ExecutionContext ctx) {
            super(ctx);
        }

        public void execute() throws Exception {
            this.doExecute(false, this.format, this.overwriteDestination, databaseLayout -> {
                this.ctx.fs().mkdirs(databaseLayout.databaseDirectory());
                return LockChecker.checkDatabaseLock((DatabaseLayout)databaseLayout);
            });
        }

        @Override
        protected SchemaCommandReader.ReaderConfig schemaCommandsReaderConfig(VectorIndexVersion latestVectorIndexVersion) {
            return new SchemaCommandReader.ReaderConfig(this.allowEnterpriseFeatures(), true, false, latestVectorIndexVersion);
        }

        @Override
        protected void doImport(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, Config databaseConfig, JobScheduler jobScheduler, InternalLogProvider logProvider, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory, org.neo4j.batchimport.api.Configuration importConfig, LogService logService, PrintStream stdOut, PrintStream stdErr, boolean verbose, Collector badCollector, MemoryTracker memoryTracker, Input input) throws IOException {
            StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine((Configuration)databaseConfig);
            BatchImporter importer = storageEngineFactory.batchImporter(databaseLayout, fileSystem, pageCacheTracer, importConfig, logService, stdOut, verbose, DefaultAdditionalIds.EMPTY, databaseConfig, (Monitor)new PrintingImportLogicMonitor(stdOut, stdErr), jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), memoryTracker, contextFactory);
            importer.doImport(input);
        }
    }

    protected static abstract class Base
    extends AbstractAdminCommand {
        private static final Function<String, Character> CHARACTER_CONVERTER = new CharacterConverter();
        private static final org.neo4j.csv.reader.Configuration DEFAULT_CSV_CONFIG = org.neo4j.csv.reader.Configuration.COMMAS;
        private static final org.neo4j.batchimport.api.Configuration DEFAULT_IMPORTER_CONFIG = org.neo4j.batchimport.api.Configuration.DEFAULT;
        @CommandLine.ParentCommand
        private ImportCommand importCommand;
        @CommandLine.Option(names={"--schema"}, paramLabel="<path>", description={"Path to the file containing the Cypher commands for creating indexes and constraints during data import."})
        private Path schemaCommands;
        @CommandLine.Parameters(index="0", converter={Converters.DatabaseNameConverter.class}, defaultValue="neo4j", description={"Name of the database to import.%n  If the database into which you import does not exist prior to importing,%n  you must create it subsequently using CREATE DATABASE."})
        private NormalizedDatabaseName database;
        @CommandLine.Option(names={"--report-file"}, paramLabel="<path>", defaultValue="import.report", description={"File in which to store the report of the csv-import."})
        private Path reportFile = Path.of("import.report", new String[0]);
        @CommandLine.Option(names={"--id-type"}, paramLabel="string|integer|actual", defaultValue="string", description={"Each node must provide a unique ID. This is used to find the correct nodes when creating relationships. Possible values are:%n  string: arbitrary strings for identifying nodes,%n  integer: arbitrary integer values for identifying nodes,%n  actual: (advanced) actual node IDs.%nFor more information on ID handling, please see the Neo4j Manual: https://neo4j.com/docs/operations-manual/current/tools/import/"}, converter={IdTypeConverter.class})
        IdType idType = IdType.STRING;
        @CommandLine.Option(names={"--input-encoding"}, paramLabel="<character-set>", description={"Character set that input data is encoded in."})
        private Charset inputEncoding = StandardCharsets.UTF_8;
        @CommandLine.Option(names={"--ignore-extra-columns"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"If unspecified columns should be ignored during the import."})
        private boolean ignoreExtraColumns;
        private static final String MULTILINE_FIELDS = "--multiline-fields";
        private static final String MULTILINE_FIELDS_FORMAT = "--multiline-fields-format";
        @CommandLine.ArgGroup(exclusive=false)
        private MultilineFieldOptions multilineFieldOptions;
        @CommandLine.Option(names={"--ignore-empty-strings"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not empty string fields, i.e. \"\" from input source are ignored, i.e. treated as null."})
        private boolean ignoreEmptyStrings = DEFAULT_CSV_CONFIG.emptyQuotedStringsAsNull();
        @CommandLine.Option(names={"--trim-strings"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not strings should be trimmed for whitespaces."})
        private boolean trimStrings = DEFAULT_CSV_CONFIG.trimStrings();
        @CommandLine.Option(names={"--legacy-style-quoting"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not a backslash-escaped quote e.g. \\\" is interpreted as an inner quote."})
        private boolean legacyStyleQuoting = DEFAULT_CSV_CONFIG.legacyStyleQuoting();
        @CommandLine.Option(names={"--delimiter"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Delimiter character between values in CSV data. Also accepts 'TAB' and e.g. 'U+20AC' for specifying a character using Unicode."})
        private char delimiter = DEFAULT_CSV_CONFIG.delimiter();
        @CommandLine.Option(names={"--array-delimiter"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Delimiter character between array elements within a value in CSV data. Also accepts 'TAB' and e.g. 'U+20AC' for specifying a character using Unicode."})
        private char arrayDelimiter = DEFAULT_CSV_CONFIG.arrayDelimiter();
        @CommandLine.Option(names={"--quote"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Character to treat as quotation character for values in CSV data. Quotes can be escaped as per RFC 4180 by doubling them, for example \"\" would be interpreted as a literal \". You cannot escape using \\."})
        private char quote = DEFAULT_CSV_CONFIG.quotationCharacter();
        @CommandLine.Option(names={"--read-buffer-size"}, paramLabel="<size>", converter={Converters.ByteUnitConverter.class}, description={"Size of each buffer for reading input data. It has to be at least large enough to hold the biggest single value in the input data. The value can be a plain number or a byte units string, e.g. 128k, 1m."})
        private long bufferSize = DEFAULT_CSV_CONFIG.bufferSize();
        @CommandLine.Option(names={"--max-off-heap-memory"}, paramLabel="<size>", defaultValue="90%", converter={Converters.MaxOffHeapMemoryConverter.class}, description={"Maximum memory that neo4j-admin can use for various data structures and caching to improve performance. Values can be plain numbers, such as 10000000, or 20G for 20 gigabytes. It can also be specified as a percentage of the available memory, for example 70%%."})
        private long maxOffHeapMemory;
        @CommandLine.Option(names={"--high-parallel-io"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="on|off|auto", defaultValue="auto", converter={OnOffAutoConverter.class}, description={"Ignore environment-based heuristics and indicate if the target storage subsystem can support parallel IO with high throughput or auto detect.  Typically this is on for SSDs, large raid arrays, and network-attached storage."})
        private OnOffAuto highIo;
        @CommandLine.Option(names={"--threads"}, paramLabel="<num>", description={"(advanced) Max number of worker threads used by the importer. Defaults to the number of available processors reported by the JVM. There is a certain amount of minimum threads needed so for that reason there is no lower bound for this value. For optimal performance, this value should not be greater than the number of available processors."})
        private int threads = DEFAULT_IMPORTER_CONFIG.maxNumberOfWorkerThreads();
        private static final String BAD_TOLERANCE_OPTION = "--bad-tolerance";
        @CommandLine.Option(names={"--bad-tolerance"}, paramLabel="<num>", description={"Number of bad entries before the import is aborted. The import process is optimized for error-free data. Therefore, cleaning the data before importing it is highly recommended. If you encounter any bad entries during the import process, you can set the number of bad entries to a specific value that suits your needs. However, setting a high value may affect the performance of the tool."})
        private long badTolerance = 1000L;
        public static final String SKIP_BAD_ENTRIES_LOGGING = "--skip-bad-entries-logging";
        @CommandLine.Option(names={"--skip-bad-entries-logging"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"When set to `true`, the details of bad entries are not written in the log. Disabling logging can improve performance when the data contains lots of faults. Cleaning the data before importing it is highly recommended because faults dramatically affect the tool's performance even without logging."})
        private boolean skipBadEntriesLogging;
        @CommandLine.Option(names={"--skip-bad-relationships"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not to skip importing relationships that refer to missing node IDs, i.e. either start or end node ID/group referring to a node that was not specified by the node input data. Skipped relationships will be logged, containing at most the number of entities specified by --bad-tolerance, unless otherwise specified by the --skip-bad-entries-logging option."})
        private boolean skipBadRelationships;
        @CommandLine.Option(names={"--strict"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", description={"Whether or not the lookup of nodes referred to from relationships needs to be checked strict. If disabled, most but not all relationships referring to non-existent nodes will be detected. If enabled all those relationships will be found but at the cost of lower performance."})
        private boolean strict = false;
        @CommandLine.Option(names={"--skip-duplicate-nodes"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not to skip importing nodes that have the same ID/group. In the event of multiple nodes within the same group having the same ID, the first encountered will be imported, whereas consecutive such nodes will be skipped. Skipped nodes will be logged, containing at most the number of entities specified by --bad-tolerance, unless otherwise specified by the --skip-bad-entries-logging option."})
        private boolean skipDuplicateNodes;
        @CommandLine.Option(names={"--normalize-types"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"When `true`, non-array property values are converted to their equivalent Cypher types. For example, all integer values will be converted to 64-bit long integers."})
        private boolean normalizeTypes = true;
        @CommandLine.Option(names={"--nodes"}, required=true, arity="1..*", converter={NodeFilesConverter.class}, paramLabel="[<label>[:<label>]...=]<files>", description={"Node CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Files can also be specified using regular expressions.\nIt is possible to import files from AWS S3 buckets, Google Cloud storage buckets, and Azure buckets using the appropriate URI as the path."})
        private List<NodeFilesGroup> nodes;
        @CommandLine.Option(names={"--relationships"}, arity="1..*", converter={RelationshipFilesConverter.class}, showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="[<type>=]<files>", description={"Relationship CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Files can also be specified using regular expressions.\nIt is possible to import files from AWS S3 buckets, Google Cloud storage buckets, and Azure buckets using the appropriate URI as the path."})
        private List<RelationshipFilesGroup> relationships = new ArrayList<RelationshipFilesGroup>();
        @CommandLine.Option(names={"--auto-skip-subsequent-headers"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Automatically skip accidental header lines in subsequent files in file groups with more than one file."})
        private boolean autoSkipHeaders;
        @CommandLine.Option(names={"--ranges"}, hidden=true, defaultValue="-1", description={"(advanced) override the number of ranges the relationship data is split into during import. Number of ranges relates to reducing unnecessary page faults during import and typically the number of ranges is automatically and optimally calculated for best performance. However, if it turns out that this calculation may not be optimal, this option can override this calculation"})
        private int overrideNumRanges;
        @CommandLine.Option(names={"--input-type"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="csv|parquet", defaultValue="csv", description={"File type to import from. Can be csv or parquet. Defaults to csv."}, converter={FileInputTypeConverter.class})
        FileImporter.FileInputType fileInputType;

        protected Base(ExecutionContext ctx) {
            super(ctx);
        }

        protected Optional<String> commandConfigName() {
            return Optional.of("database-import");
        }

        public boolean allowEnterpriseFeatures() {
            return this.importCommand.allowEnterpriseFeatures();
        }

        protected void doExecute(boolean incremental, String format, boolean overwriteDestination, MaybeLocker maybeLockChecker) {
            try {
                if (format != null && StorageEngineFactory.isFormatDeprecated((String)format)) {
                    this.ctx.out().println("WARNING: " + DeprecatedFormatWarning.getTargetFormatWarning((String)format));
                }
                Config databaseConfig = this.loadNeo4jConfig(format);
                DatabaseLayout databaseLayout = Neo4jLayout.of((Configuration)databaseConfig).databaseLayout(this.database.name());
                Path logFilePath = FileImporter.getLogFilePath(databaseConfig);
                this.ctx.fs().mkdirs(logFilePath.toAbsolutePath().getParent());
                try (Closeable ignore = maybeLockChecker.maybeCheckLock(databaseLayout);
                     BufferedOutputStream logFile = new BufferedOutputStream(this.ctx.fs().openAsOutputStream(logFilePath, true));
                     Log4jLogProvider logProvider = FileImporter.getLog(logFile, this.verbose);
                     SchemeFileSystemAbstraction fileSystem = new SchemeFileSystemAbstraction(this.ctx.fs(), databaseConfig, (InternalLogProvider)logProvider);){
                    this.ctx.out().println("Starting to import, output will be saved to: " + String.valueOf(logFilePath.toAbsolutePath()));
                    FileImporter.Builder importerBuilder = FileImporter.builder().withCsvConfig(this.csvConfiguration(fileSystem)).withImportConfig(this.importConfiguration()).withDatabaseLayout(databaseLayout).withDatabaseConfig(databaseConfig).withFileSystem((FileSystemAbstraction)fileSystem).withStdOut(this.ctx.out()).withStdErr(this.ctx.err()).withIdType(this.idType).withInputEncoding(this.inputEncoding).withReportFile(this.reportFile.toAbsolutePath()).withIgnoreExtraColumns(this.ignoreExtraColumns).withBadTolerance(this.badTolerance).withSkipBadRelationships(this.skipBadRelationships).withSkipDuplicateNodes(this.skipDuplicateNodes).withSkipBadEntriesLogging(this.skipBadEntriesLogging).withSkipBadRelationships(this.skipBadRelationships).withNormalizeTypes(this.normalizeTypes).withVerbose(this.verbose).withAutoSkipHeaders(this.autoSkipHeaders).withForce(overwriteDestination).withIncremental(incremental).withLogProvider((InternalLogProvider)logProvider).withSchemaCommands(this.parseSchemaCommands((FileSystemAbstraction)fileSystem, databaseConfig)).withLogProvider((InternalLogProvider)logProvider).withFileInputType(this.fileInputType);
                    if (incremental) {
                        importerBuilder.withCursorContextFactory(new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new FixedVersionContextSupplier(this.getLogTail((FileSystemAbstraction)fileSystem, databaseLayout, databaseConfig).getLastCommittedTransaction().id())));
                    } else {
                        importerBuilder.withCursorContextFactory(new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new FixedVersionContextSupplier(1L)));
                    }
                    for (NodeFilesGroup n : this.nodes) {
                        importerBuilder.addNodeFiles((Set)n.key, n.toPaths((FileSystemAbstraction)fileSystem));
                    }
                    for (RelationshipFilesGroup r : this.relationships) {
                        importerBuilder.addRelationshipFiles((String)r.key, r.toPaths((FileSystemAbstraction)fileSystem));
                    }
                    importerBuilder.build().doImport(this);
                }
                catch (FileLockException e) {
                    throw new CommandFailedException("The database is in use. Stop database '%s' and try again.".formatted(databaseLayout.getDatabaseName()), (Throwable)e, 1);
                }
                catch (CannotWriteException e) {
                    throw new CommandFailedException("You do not have permission to import.", (Throwable)e, 77);
                }
                catch (FileImporter.CsvImportException e) {
                    throw new CommandFailedException("Error importing csv file.", (Throwable)e, 70);
                }
                catch (UnsupportedFormatException e) {
                    throw new CommandFailedException("Unsupported format.", (Throwable)e, 70);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected abstract SchemaCommandReader.ReaderConfig schemaCommandsReaderConfig(VectorIndexVersion var1);

        protected abstract void doImport(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, JobScheduler var4, InternalLogProvider var5, PageCacheTracer var6, CursorContextFactory var7, org.neo4j.batchimport.api.Configuration var8, LogService var9, PrintStream var10, PrintStream var11, boolean var12, Collector var13, MemoryTracker var14, Input var15) throws IOException;

        private List<SchemaCommand> parseSchemaCommands(FileSystemAbstraction fileSystem, Config config) {
            if (this.schemaCommands == null) {
                return List.of();
            }
            if (!fileSystem.fileExists(this.schemaCommands)) {
                throw new CommandFailedException("The provided schema commands file does not exist.", 74);
            }
            if (fileSystem.isDirectory(this.schemaCommands)) {
                throw new CommandFailedException("The provided schema commands file is not a regular file.", 74);
            }
            SchemaCommandReader reader = new SchemaCommandReader(fileSystem, config, this.schemaCommandsReaderConfig(VectorIndexVersion.latestSupportedVersion((KernelVersion)KernelVersion.getLatestVersion((Config)config))));
            try {
                return reader.parse(this.schemaCommands);
            }
            catch (SchemaCommand.SchemaCommandReaderException ex) {
                throw new CommandFailedException(ex.getMessage(), (Throwable)ex, 70);
            }
        }

        private LogTailMetadata getLogTail(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config databaseConfig) throws IOException {
            Optional storageEngineFactory = StorageEngineFactory.SELECTOR.selectStorageEngine(fs, databaseLayout);
            return this.getLogTail(fs, databaseLayout, databaseConfig, (StorageEngineFactory)storageEngineFactory.orElseThrow());
        }

        private LogTailMetadata getLogTail(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, StorageEngineFactory storageEngineFactory) throws IOException {
            LogTailExtractor logTailExtractor = new LogTailExtractor(fs, config, storageEngineFactory, DatabaseTracers.EMPTY);
            return logTailExtractor.getTailMetadata(databaseLayout, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @VisibleForTesting
        Config loadNeo4jConfig(String format) {
            Config.Builder builder = this.createPrefilledConfigBuilder();
            if (StringUtils.isNotEmpty((CharSequence)format)) {
                builder.set(GraphDatabaseSettings.db_format, (Object)format);
            }
            return builder.build();
        }

        LogTailMetadata readLogTailMetaData(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory) throws IOException {
            return LogFilesBuilder.logFilesBasedOnlyBuilder((Path)databaseLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)fileSystem).withStorageEngineFactory(storageEngineFactory).build().getTailMetadata();
        }

        private org.neo4j.csv.reader.Configuration csvConfiguration(SchemeFileSystemAbstraction fs) {
            Configuration.Builder builder = DEFAULT_CSV_CONFIG.toBuilder().withDelimiter(this.delimiter).withArrayDelimiter(this.arrayDelimiter).withQuotationCharacter(this.quote).withEmptyQuotedStringsAsNull(this.ignoreEmptyStrings).withTrimStrings(this.trimStrings).withLegacyStyleQuoting(this.legacyStyleQuoting).withBufferSize(Math.toIntExact(this.bufferSize));
            if (this.multilineFieldOptions != null) {
                String multilineFields = this.multilineFieldOptions.multilineFields;
                switch (this.multilineFieldOptions.multilineFormat.ordinal()) {
                    case 0: {
                        if (Boolean.TRUE.toString().equalsIgnoreCase(multilineFields)) {
                            builder.withLegacyMultilineBehaviour();
                            break;
                        }
                        if (Boolean.FALSE.toString().equalsIgnoreCase(multilineFields)) break;
                        throw new IllegalArgumentException("Illegal format for %s when using the v1 format - must be either true or false".formatted(MULTILINE_FIELDS));
                    }
                    case 1: {
                        Set paths = Arrays.stream(ImportCommand.parseFilesList((FileSystemAbstraction)fs, multilineFields)).map(StorageUtils::toString).collect(Collectors.toSet());
                        builder.withMultilineDocuments(paths::contains);
                    }
                }
            }
            return builder.build();
        }

        private org.neo4j.batchimport.api.Configuration importConfiguration() {
            return new Configuration.Overridden(org.neo4j.batchimport.api.Configuration.defaultConfiguration()){

                public int maxNumberOfWorkerThreads() {
                    return threads;
                }

                public long maxOffHeapMemory() {
                    return maxOffHeapMemory;
                }

                public boolean highIO() {
                    return highIo == OnOffAuto.AUTO ? super.highIO() : highIo == OnOffAuto.ON;
                }

                public IndexConfig indexConfig() {
                    return IndexConfig.create().withLabelIndex().withRelationshipTypeIndex();
                }

                public boolean strictNodeCheck() {
                    return strict;
                }

                public int forcedNumberOfNodeIdRanges() {
                    if (overrideNumRanges != -1) {
                        return overrideNumRanges;
                    }
                    return super.forcedNumberOfNodeIdRanges();
                }
            };
        }

        @FunctionalInterface
        protected static interface MaybeLocker {
            public Closeable maybeCheckLock(DatabaseLayout var1) throws CannotWriteException, IOException;
        }

        static class MultilineFieldOptions {
            @CommandLine.Option(names={"--multiline-fields"}, required=true, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false|<path>[,<path>]", fallbackValue="true", description={"In v1, whether or not fields from an input source can span multiple lines, i.e. contain newline characters. Setting --multiline-fields=true can severely degrade the performance of the importer. Therefore, use it with care, especially with large imports. In v2, this option will specify the list of files that contain multiline fields. Files can also be specified using regular expressions."})
            private String multilineFields;
            @CommandLine.Option(names={"--multiline-fields-format"}, converter={MultilineFormatConverter.class}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="v1|v2", description={"Controls the parsing of input source that can span multiple lines, i.e. contain newline characters. When set to v1, the value for --multiline-fields can only be true or false. When set to v2, the value for --multiline-fields should be the list of files that contain multiline fields."})
            private MultilineFormat multilineFormat = MultilineFormat.V1;

            MultilineFieldOptions() {
            }
        }

        static enum MultilineFormat {
            V1,
            V2;

        }

        static class FileInputTypeConverter
        implements CommandLine.ITypeConverter<FileImporter.FileInputType> {
            FileInputTypeConverter() {
            }

            public FileImporter.FileInputType convert(String in) {
                try {
                    return FileImporter.FileInputType.valueOf(in.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid file import type: %s. Only %s are supported as values", in, Arrays.stream(FileImporter.FileInputType.values()).map(value -> String.format("'%s'", value.name().toLowerCase(Locale.ROOT))).collect(Collectors.joining(", "))));
                }
            }
        }

        static class IdTypeConverter
        implements CommandLine.ITypeConverter<IdType> {
            IdTypeConverter() {
            }

            public IdType convert(String in) {
                try {
                    return IdType.valueOf((String)in.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid id type: %s (%s)", in, e));
                }
            }
        }

        static class RelationshipFilesConverter
        implements CommandLine.ITypeConverter<InputFilesGroup<String>> {
            RelationshipFilesConverter() {
            }

            public InputFilesGroup<String> convert(String value) {
                try {
                    return ImportCommand.parseRelationshipFilesGroup(value);
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid relationships file: %s (%s)", value, e));
                }
            }
        }

        static class NodeFilesConverter
        implements CommandLine.ITypeConverter<NodeFilesGroup> {
            NodeFilesConverter() {
            }

            public NodeFilesGroup convert(String value) {
                try {
                    return ImportCommand.parseNodeFilesGroup(value);
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid nodes file: %s (%s)", value, e));
                }
            }
        }

        static class EscapedCharacterConverter
        implements CommandLine.ITypeConverter<Character> {
            EscapedCharacterConverter() {
            }

            public Character convert(String value) {
                return CHARACTER_CONVERTER.apply(value);
            }
        }

        static class MultilineFormatConverter
        implements CommandLine.ITypeConverter<MultilineFormat> {
            MultilineFormatConverter() {
            }

            public MultilineFormat convert(String value) throws Exception {
                return MultilineFormat.valueOf(value.toUpperCase(Locale.ROOT));
            }
        }

        static class OnOffAutoConverter
        implements CommandLine.ITypeConverter<OnOffAuto> {
            OnOffAutoConverter() {
            }

            public OnOffAuto convert(String value) throws Exception {
                return OnOffAuto.valueOf(value.toUpperCase(Locale.ROOT));
            }
        }

        static enum OnOffAuto {
            ON,
            OFF,
            AUTO;

        }
    }
}

