/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.PrintStream;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.io.ByteUnit;

public class PrintingImportLogicMonitor
implements Monitor {
    private final PrintStream out;
    private final PrintStream err;

    public PrintingImportLogicMonitor(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public void doubleRelationshipRecordUnitsEnabled() {
        this.out.println("Will use double record units for all relationships");
    }

    public void mayExceedNodeIdCapacity(long capacity, long estimatedCount) {
        this.err.printf("WARNING: estimated number of relationships %d may exceed capacity %d of selected record format%n", estimatedCount, capacity);
    }

    public void mayExceedRelationshipIdCapacity(long capacity, long estimatedCount) {
        this.err.printf("WARNING: estimated number of nodes %d may exceed capacity %d of selected record format%n", estimatedCount, capacity);
    }

    public void insufficientHeapSize(long optimalMinimalHeapSize, long heapSize) {
        this.err.printf("WARNING: heap size %s may be too small to complete this import. Suggested heap size is %s", ByteUnit.bytesToString((long)heapSize), ByteUnit.bytesToString((long)optimalMinimalHeapSize));
    }

    public void abundantHeapSize(long optimalMinimalHeapSize, long heapSize) {
        this.err.printf("WARNING: heap size %s is unnecessarily large for completing this import.%nThe abundant heap memory will leave less memory for off-heap importer caches. Suggested heap size is %s", ByteUnit.bytesToString((long)heapSize), ByteUnit.bytesToString((long)optimalMinimalHeapSize));
    }

    public void insufficientAvailableMemory(long estimatedCacheSize, long optimalMinimalHeapSize, long availableMemory) {
        this.err.printf("WARNING: %s memory may not be sufficient to complete this import. Suggested memory distribution is:%nheap size: %s%nminimum free and available memory excluding heap size: %s", ByteUnit.bytesToString((long)availableMemory), ByteUnit.bytesToString((long)optimalMinimalHeapSize), ByteUnit.bytesToString((long)estimatedCacheSize));
    }
}

