/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.neo4j.internal.batchimport.cache.BufferFactory;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.helpers.VarHandleUtils;
import org.neo4j.io.IOUtils;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

abstract class BaseDynamicArray
implements NumberArray,
MemoryStatsVisitor.Visitable,
AutoCloseable {
    private static final VarHandle VH_BUFFERS = VarHandleUtils.arrayElementVarHandle(ByteBuffer[].class);
    private static final VarHandle VH_CURRENT_DYNAMIC_SIZE = VarHandleUtils.getVarHandle((MethodHandles.Lookup)MethodHandles.lookup(), (String)"currentDynamicSize");
    private final int bufferSize;
    private final long maxNumberOfElements;
    private final int lastBufferIndex;
    protected final int bufferPower;
    protected final int bufferMask;
    private final byte defaultValue;
    private final BufferFactory bufferFactory;
    private final MemoryTracker memoryTracker;
    private final long totalSize;
    private final ArrayList<AutoCloseable> closeables = new ArrayList();
    protected final int elementSize;
    private int currentDynamicSize;
    private ByteBuffer[] buffers;

    BaseDynamicArray(long maxNumberOfElements, int elementSize, int elementsPerChunk, byte defaultValue, BufferFactory bufferFactory, MemoryTracker memoryTracker) {
        this.maxNumberOfElements = maxNumberOfElements;
        this.elementSize = elementSize;
        this.defaultValue = defaultValue;
        this.bufferFactory = bufferFactory;
        this.memoryTracker = new DefaultScopedMemoryTracker(memoryTracker);
        int maxChunkSize = 0x7FFFFFF7 / elementSize;
        if (maxNumberOfElements == 0L) {
            Preconditions.checkArgument((elementsPerChunk > 0 ? 1 : 0) != 0, (String)"Array with dynamic size should have a chunk size");
            elementsPerChunk = Math.min(elementsPerChunk, maxChunkSize);
            this.totalSize = 0L;
            this.lastBufferIndex = -1;
            this.bufferPower = Numbers.log2floor((long)elementsPerChunk);
            this.bufferMask = (1 << this.bufferPower) - 1;
            this.bufferSize = Math.multiplyExact(1 << this.bufferPower, elementSize);
            VH_CURRENT_DYNAMIC_SIZE.set(this, 1);
            this.buffers = new ByteBuffer[1];
        } else {
            Preconditions.checkArgument((elementsPerChunk == 0 ? 1 : 0) != 0, (String)"Array with fixed size should not have a chunk size");
            this.bufferPower = Numbers.log2floor((long)maxChunkSize);
            this.bufferMask = (1 << this.bufferPower) - 1;
            int elementsPerBuffer = 1 << this.bufferPower;
            int numberOfBuffers = (int)Math.ceilDiv(maxNumberOfElements, elementsPerBuffer);
            this.buffers = new ByteBuffer[numberOfBuffers];
            this.lastBufferIndex = numberOfBuffers - 1;
            this.totalSize = maxNumberOfElements * (long)elementSize;
            this.bufferSize = elementsPerBuffer * elementSize;
        }
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.heapUsage(this.memoryTracker.estimatedHeapMemory());
        visitor.offHeapUsage(this.memoryTracker.usedNativeMemory());
    }

    @Override
    public long length() {
        if (this.isDynamic()) {
            int currentSize = VH_CURRENT_DYNAMIC_SIZE.getAcquire(this);
            return (long)currentSize << this.bufferPower;
        }
        return this.maxNumberOfElements;
    }

    @Override
    public synchronized void clear() {
        for (ByteBuffer buffer : this.buffers) {
            if (buffer == null) continue;
            this.bufferFactory.clear(buffer, this.defaultValue);
        }
    }

    @Override
    public synchronized void close() {
        try {
            IOUtils.closeAll(this.closeables);
            this.memoryTracker.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ByteBuffer getBuffer(long idx) {
        ByteBuffer buffer;
        int index = (int)(idx >>> this.bufferPower);
        if (this.isDynamic() && VH_CURRENT_DYNAMIC_SIZE.getAcquire(this) <= index) {
            this.growToHold(index);
        }
        if ((buffer = VH_BUFFERS.getAcquire(this.buffers, index)) == null) {
            buffer = this.createBufferFor(index);
        }
        return buffer;
    }

    protected int offset(long index) {
        return (int)(index & (long)this.bufferMask) * this.elementSize;
    }

    private synchronized ByteBuffer createBufferFor(int index) {
        ByteBuffer buffer = VH_BUFFERS.get(this.buffers, index);
        if (buffer == null) {
            BufferFactory.AllocatedBuffer alloc = index == this.lastBufferIndex ? this.bufferFactory.allocate((int)(this.totalSize % (long)this.bufferSize), this.memoryTracker) : this.bufferFactory.allocate(this.bufferSize, this.memoryTracker);
            if (alloc.closeable() != null) {
                this.closeables.add(alloc.closeable());
            }
            buffer = alloc.buffer().order(ByteOrder.LITTLE_ENDIAN);
            if (this.defaultValue != 0) {
                this.bufferFactory.clear(buffer, this.defaultValue);
            }
            VH_BUFFERS.setRelease(this.buffers, index, buffer);
        }
        return buffer;
    }

    private synchronized void growToHold(int index) {
        int currentSize = VH_CURRENT_DYNAMIC_SIZE.get(this);
        if (currentSize <= index) {
            int newSize = currentSize;
            while (newSize <= index) {
                newSize = Math.multiplyExact(newSize, 2);
            }
            ByteBuffer[] newArray = new ByteBuffer[newSize];
            System.arraycopy(this.buffers, 0, newArray, 0, currentSize);
            this.buffers = newArray;
            VH_CURRENT_DYNAMIC_SIZE.setRelease(this, newSize);
        }
    }

    private boolean isDynamic() {
        return this.maxNumberOfElements == 0L;
    }
}

