/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.batchimport.cache.BufferFactory;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;

class SwappingBufferFactory
implements BufferFactory,
AutoCloseable {
    private static final Set<OpenOption> OPEN_OPTIONS = Set.of(StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);
    private final AtomicLong currentEnd = new AtomicLong();
    private final StoreChannel channel;
    private final FileSystemAbstraction fs;
    private final Path file;

    SwappingBufferFactory(FileSystemAbstraction fs, Path workDirectory) throws IOException {
        this.fs = fs;
        this.file = fs.createTempFile(workDirectory, ".swap", ".tmp");
        this.channel = fs.open(this.file, OPEN_OPTIONS);
    }

    @Override
    public void close() {
        try {
            this.channel.close();
            this.fs.deleteFile(this.file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public BufferFactory.AllocatedBuffer allocate(int size, MemoryTracker memoryTracker) {
        try {
            long start = this.currentEnd.getAndAdd(size);
            MappedByteBuffer mapped = this.channel.map(FileChannel.MapMode.PRIVATE, start, (long)size);
            AutoCloseable closeable = null;
            if (UnsafeUtil.isCheckNativeAccessEnabled()) {
                long address = UnsafeUtil.getDirectByteBufferAddress((Buffer)mapped);
                UnsafeUtil.addAllocatedPointer((long)address, (long)size);
                closeable = () -> UnsafeUtil.removeAllocatedPointer((long)address);
            }
            return new BufferFactory.AllocatedBuffer(mapped, closeable);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear(ByteBuffer buffer, byte defaultValue) {
        UnsafeUtil.setMemory((long)UnsafeUtil.getDirectByteBufferAddress((Buffer)buffer), (long)buffer.capacity(), (byte)defaultValue);
    }

    public String toString() {
        return "SwappingBufferFactory";
    }

    @Override
    public void warnForUsage(InternalLog log) {
        log.warn("Running low on memory and will start swapping to hard drive. This will have a significant impact on performance.");
    }
}

