/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.cuckoo;

import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.KeyCollisionException;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.IOUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class CuckooTable
implements AutoCloseable {
    private static final double INITIAL_LOAD_FACTOR = 0.95;
    private static final int INITIAL_TABLES = 4;
    private static final int MAX_TABLES = 8;
    private static final long RELOCATING_BIT = Long.MIN_VALUE;
    private static final long VALUE_MASK = 0xFFFFFFFFFFFFL;
    private static final long DESTINATION_MASK = 0x7000000000000000L;
    private static final int DESTINATION_SHIFT = 60;
    private static final int PARTIAL_KEY_MASK = 4095;
    private static final int PARTIAL_KEY_SHIFT = 48;
    private static final int MAX_RELOCATIONS = 20;
    private static final long EMPTY_ENTRY = 0L;
    private final long tablesSize;
    private final NumberArrayFactory arrayFactory;
    private final MemoryTracker memoryTracker;
    private final int hashShift;
    private final AtomicInteger currentNumberOfTables;
    private final LongArray[] tables;
    private final LongArray keys;
    private final RandomMultiplicativeHashing[] hashing;
    private final AtomicLong zeroValue = new AtomicLong(-1L);

    public CuckooTable(long expectedNumberOfEntries, NumberArrayFactory arrayFactory, MemoryTracker memoryTracker) {
        this.tablesSize = CuckooTable.calculateTableSize(expectedNumberOfEntries);
        this.arrayFactory = arrayFactory;
        this.memoryTracker = memoryTracker;
        this.hashShift = 64 - Long.numberOfTrailingZeros(this.tablesSize);
        int chunkSize = Math.clamp(expectedNumberOfEntries, 1, 0x7FFFFFF7);
        this.keys = arrayFactory.newDynamicLongArray(chunkSize, 0L, memoryTracker);
        this.currentNumberOfTables = new AtomicInteger(4);
        this.tables = new LongArray[8];
        this.hashing = new RandomMultiplicativeHashing[8];
        for (int i = 0; i < 4; ++i) {
            this.tables[i] = arrayFactory.newLongArray(this.tablesSize, 0L, memoryTracker);
            this.hashing[i] = new RandomMultiplicativeHashing(this.hashShift);
        }
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.keys, () -> IOUtils.closeAllUnchecked((AutoCloseable[])this.tables)});
    }

    public long get(long key) {
        if (key == 0L) {
            return this.zeroValue.getPlain();
        }
        int num = this.currentNumberOfTables.getPlain();
        int partialKey = CuckooTable.keyToPartial(key);
        for (int i = 0; i < num; ++i) {
            long value;
            long entry = this.tables[i].get(this.hashing[i].hash(key));
            if (!CuckooTable.isInUse(entry) || CuckooTable.getPartialKey(entry) != partialKey || this.keys.get(value = CuckooTable.getValue(entry)) != key) continue;
            return value;
        }
        return -1L;
    }

    public void insert(long key, long value) throws KeyCollisionException {
        Preconditions.checkArgument(((value & 0xFFFFFFFFFFFFL) == value ? 1 : 0) != 0, (String)("Value must be in the range: 0 <= value <= 281474976710655 but was " + (value & 0xFFFFFFFFFFFFL)));
        if (key == 0L) {
            if (this.zeroValue.compareAndSet(-1L, value)) {
                return;
            }
            throw new KeyCollisionException(key);
        }
        if (!this.keys.compareAndSet(value, 0L, key)) {
            throw new IllegalArgumentException("Non unique value inserted " + value);
        }
        int partialKey = CuckooTable.keyToPartial(key);
        int numberOfTables;
        while (!this.insertToEmptySlot(key, value, partialKey, numberOfTables = this.currentNumberOfTables.get())) {
            if (this.relocate(key, numberOfTables)) continue;
            this.expand(numberOfTables);
        }
        return;
    }

    private boolean insertToEmptySlot(long key, long value, int partial, int numberOfTables) throws KeyCollisionException {
        block5: {
            while (true) {
                int candidateTable = -1;
                long candidateEntry = -1L;
                long candidateHash = -1L;
                for (int i = 0; i < numberOfTables; ++i) {
                    long hash = this.hashing[i].hash(key);
                    long entry = this.tables[i].get(hash);
                    if (CuckooTable.isRelocating(entry)) {
                        this.helpMove(i, hash, entry);
                        continue;
                    }
                    if (CuckooTable.isInUse(entry)) {
                        long currentValue;
                        if (CuckooTable.getPartialKey(entry) != partial || this.keys.get(currentValue = CuckooTable.getValue(entry)) != key) continue;
                        this.keys.set(value, 0L);
                        throw new KeyCollisionException(key);
                    }
                    if (candidateTable != -1) continue;
                    candidateTable = i;
                    candidateEntry = entry;
                    candidateHash = hash;
                }
                if (candidateTable == -1) break block5;
                if (!this.tables[candidateTable].compareAndSet(candidateHash, candidateEntry, CuckooTable.makeEntry(value, partial))) continue;
                int postNum = this.currentNumberOfTables.get();
                if (postNum != numberOfTables) {
                    this.deleteValue(key, value, numberOfTables);
                    numberOfTables = postNum;
                    continue;
                }
                if (this.validateNoDuplicates(key, partial, postNum)) break;
                this.deleteValue(key, value, numberOfTables);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteValue(long key, long value, int numberOfTables) {
        block0: while (true) {
            int i = 0;
            while (true) {
                long currentValue;
                if (i >= numberOfTables) continue block0;
                long hash = this.hashing[i].hash(key);
                long entry = this.tables[i].get(hash);
                if (CuckooTable.isRelocating(entry)) {
                    this.helpMove(i, hash, entry);
                    continue block0;
                }
                if (CuckooTable.isInUse(entry) && (currentValue = CuckooTable.getValue(entry)) == value) {
                    if (this.tables[i].compareAndSet(hash, entry, 0L)) return;
                    continue block0;
                }
                ++i;
            }
            break;
        }
    }

    private boolean validateNoDuplicates(long key, int partial, int numberOfTables) {
        int count;
        block0: while (true) {
            count = 0;
            for (int i = 0; i < numberOfTables; ++i) {
                long currentValue;
                long currentKey;
                long hash = this.hashing[i].hash(key);
                long entry = this.tables[i].get(hash);
                if (CuckooTable.isRelocating(entry)) {
                    this.helpMove(i, hash, entry);
                    continue block0;
                }
                if (!CuckooTable.isInUse(entry) || CuckooTable.getPartialKey(entry) != partial || (currentKey = this.keys.get(currentValue = CuckooTable.getValue(entry))) != key) continue;
                ++count;
            }
            break;
        }
        return count <= 1;
    }

    /*
     * Unable to fully structure code
     */
    private boolean relocate(long key, int numberOfTables) {
        rnd = ThreadLocalRandom.current();
        route = new long[40];
        block0: while (true) {
            tbl = CuckooTable.nextRandomTable(-1, numberOfTables, rnd);
            idx = this.hashing[tbl].hash(key);
            found = false;
            depth = 0;
            do {
                entry = this.tables[tbl].get(idx);
                while (CuckooTable.isRelocating(entry)) {
                    this.helpMove(tbl, idx, entry);
                    entry = this.tables[tbl].get(idx);
                }
                route[depth * 2] = tbl;
                route[depth * 2 + 1] = idx;
                if (CuckooTable.isInUse(entry)) {
                    tbl = CuckooTable.nextRandomTable(tbl, numberOfTables, rnd);
                    idx = this.hashing[tbl].hash(this.keys.get(CuckooTable.getValue(entry)));
                    continue;
                }
                found = true;
            } while (!found && ++depth < 20);
            if (!found) break;
            for (i = depth; i >= 0; --i) {
                srcTbl = (int)route[i * 2];
                srcIdx = route[i * 2 + 1];
                srcEntry = this.tables[srcTbl].get(srcIdx);
                if (CuckooTable.isRelocating(srcEntry)) {
                    this.helpMove(srcTbl, srcIdx, srcEntry);
                    continue block0;
                }
                if (CuckooTable.isInUse(srcEntry)) {
                    destEntry = this.tables[tbl].get(idx);
                    if (!CuckooTable.isInUse(destEntry)) ** break;
                    continue block0;
                    this.moveEntry(srcTbl, srcIdx, tbl, srcEntry);
                }
                tbl = srcTbl;
                idx = srcIdx;
            }
            break;
        }
        return found;
    }

    private void moveEntry(int srcTbl, long srcIndex, int destTbl, long srcEntry) {
        while (!CuckooTable.isRelocating(srcEntry)) {
            if (CuckooTable.isInUse(srcEntry = this.tables[srcTbl].compareAndExchange(srcIndex, srcEntry, CuckooTable.setRelocating(srcEntry, destTbl)))) continue;
            return;
        }
        this.move(srcTbl, srcIndex, destTbl, srcEntry);
    }

    private void helpMove(int srcTbl, long srcIndex, long srcEntry) {
        this.move(srcTbl, srcIndex, CuckooTable.getDestinationTable(srcEntry), srcEntry);
    }

    private void move(int srcTbl, long srcIndex, int destTbl, long srcEntry) {
        long srcValue = CuckooTable.getValue(srcEntry);
        long destHash = this.hashing[destTbl].hash(this.keys.get(srcValue));
        long destEntry = this.tables[destTbl].get(destHash);
        if (!CuckooTable.isInUse(destEntry) && this.tables[destTbl].compareAndSet(destHash, 0L, CuckooTable.clearRelocating(srcEntry))) {
            this.tables[srcTbl].compareAndSet(srcIndex, srcEntry, 0L);
            return;
        }
        if (srcValue == CuckooTable.getValue(destEntry) && !CuckooTable.isRelocating(destEntry)) {
            this.tables[srcTbl].compareAndSet(srcIndex, srcEntry, 0L);
            return;
        }
        this.tables[srcTbl].compareAndSet(srcIndex, srcEntry, CuckooTable.clearRelocating(srcEntry));
    }

    private synchronized void expand(int oldNumberOfTables) {
        LongArray newTables;
        int n = this.currentNumberOfTables.get();
        if (n > oldNumberOfTables) {
            return;
        }
        this.hashing[oldNumberOfTables] = new RandomMultiplicativeHashing(this.hashShift);
        this.tables[oldNumberOfTables] = newTables = this.arrayFactory.newLongArray(this.tablesSize, 0L, this.memoryTracker);
        this.currentNumberOfTables.incrementAndGet();
    }

    private static long calculateTableSize(long expectedNumberOfEntries) {
        double capacity = (double)expectedNumberOfEntries / 0.95;
        long minCapacityPerTable = (long)(capacity / 4.0);
        return Numbers.ceilingPowerOfTwo((long)Math.max(minCapacityPerTable, 1024L));
    }

    private static int nextRandomTable(int tbl, int numberOfTables, ThreadLocalRandom rnd) {
        int t = tbl;
        while (t == tbl) {
            t = rnd.nextInt(numberOfTables);
        }
        return t;
    }

    private static int keyToPartial(long key) {
        int i = Long.hashCode(key);
        int a = i >>> 16 ^ i & 0xFFFF;
        return a & 0xFFF;
    }

    private static int getPartialKey(long entry) {
        return (int)(entry >>> 48 & 0xFFFL);
    }

    private static long getValue(long entry) {
        return entry & 0xFFFFFFFFFFFFL;
    }

    private static boolean isInUse(long entry) {
        return entry != 0L;
    }

    private static boolean isRelocating(long entry) {
        return (entry & Long.MIN_VALUE) != 0L;
    }

    private static long setRelocating(long entry, long destTbl) {
        return entry & 0x8FFFFFFFFFFFFFFFL | Long.MIN_VALUE | destTbl << 60;
    }

    private static long clearRelocating(long entry) {
        return entry & Long.MAX_VALUE | 0x7000000000000000L;
    }

    private static int getDestinationTable(long entry) {
        return (int)((entry & 0x7000000000000000L) >>> 60);
    }

    private static long makeEntry(long value, int partialKey) {
        return (long)partialKey << 48 | value & 0xFFFFFFFFFFFFL | 0x7000000000000000L;
    }

    private static final class RandomMultiplicativeHashing {
        private final long shift;
        private final long factor;

        private RandomMultiplicativeHashing(int shift) {
            this.shift = shift;
            this.factor = BigInteger.probablePrime(64, ThreadLocalRandom.current()).longValue();
        }

        private long hash(long key) {
            return this.factor * key >>> (int)this.shift;
        }
    }
}

