/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.context.CursorContext;

public class BatchingIdGetter
implements IdSequence {
    private final IdGenerator source;
    private final int batchSize;
    private long currentBatchStartId = -1L;
    private int currentBatchIndex;

    public BatchingIdGetter(IdGenerator idGenerator, int recordsPerPage) {
        this.source = idGenerator;
        this.batchSize = recordsPerPage;
    }

    public long nextId(CursorContext cursorContext) {
        long id = this.nextIdFromCurrentBatch();
        if (id != -1L) {
            return id;
        }
        this.currentBatchStartId = this.source.nextConsecutiveIdRange(this.batchSize, false, cursorContext);
        this.currentBatchIndex = 0;
        return this.nextIdFromCurrentBatch();
    }

    private long nextIdFromCurrentBatch() {
        return this.currentBatchStartId == -1L || this.currentBatchIndex == this.batchSize ? -1L : this.currentBatchStartId + (long)this.currentBatchIndex++;
    }

    public void markUnusedIdsAsDeleted(CursorContext cursorContext) {
        try (IdGenerator.TransactionalMarker marker = this.source.transactionalMarker(cursorContext);){
            long id;
            while ((id = this.nextIdFromCurrentBatch()) != -1L) {
                marker.markDeleted(id);
            }
        }
    }

    public void markIdAsDeleted(long id, CursorContext cursorContext) {
        try (IdGenerator.TransactionalMarker marker = this.source.transactionalMarker(cursorContext);){
            marker.markDeleted(id);
        }
    }
}

