/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.util.TriConsumer;
import org.neo4j.batchimport.api.InputIterable;
import org.neo4j.batchimport.api.InputIterator;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityDecorators;
import org.neo4j.internal.batchimport.input.Inputs;
import org.neo4j.internal.batchimport.input.csv.CsvGroupInputIterator;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunkProxy;
import org.neo4j.internal.batchimport.input.csv.CsvInputIterator;
import org.neo4j.internal.batchimport.input.csv.Data;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Preconditions;

public class CsvInput
implements Input {
    private static final String MIXED_COMPOSITE_ID_REFERRALS = "How to refer to composite IDs (multiple :ID columns) from :START_ID/:END_ID must be consistent: Either using a single :START_ID/:END_ID column, or a matching amount of :START_ID/:END_ID columns.";
    private static final long ESTIMATE_SAMPLE_SIZE = ByteUnit.mebiBytes((long)1L);
    private final Iterable<DataFactory> nodeDataFactory;
    private final Header.Factory nodeHeaderFactory;
    private final Iterable<DataFactory> relationshipDataFactory;
    private final Header.Factory relationshipHeaderFactory;
    private final List<SchemaCommand> schemaCommands;
    private final IdType idType;
    private final Configuration config;
    private final Monitor monitor;
    private final Groups groups;
    private final boolean autoSkipHeaders;
    private final MemoryTracker memoryTracker;
    private List<Header> cachedNodeHeaders;
    private boolean delimitIds;
    private boolean hasBeenValidated;
    public static final Monitor NO_MONITOR = new Monitor(){

        @Override
        public void duplicateSourceFile(String sourceFile) {
        }

        @Override
        public void noNodeLabelsSpecified(String sourceFile) {
        }

        @Override
        public void noRelationshipTypeSpecified(String sourceFile) {
        }

        @Override
        public void typeNormalized(String sourceDescription, String header, String fromType, String toType) {
        }
    };

    public CsvInput(Iterable<DataFactory> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, boolean autoSkipHeaders, Monitor monitor, MemoryTracker memoryTracker) {
        this(nodeDataFactory, nodeHeaderFactory, relationshipDataFactory, relationshipHeaderFactory, List.of(), idType, config, autoSkipHeaders, monitor, new Groups(), memoryTracker);
    }

    public CsvInput(Iterable<DataFactory> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, boolean autoSkipHeaders, Monitor monitor, Groups groups, MemoryTracker memoryTracker) {
        this(nodeDataFactory, nodeHeaderFactory, relationshipDataFactory, relationshipHeaderFactory, List.of(), idType, config, autoSkipHeaders, monitor, groups, memoryTracker);
    }

    public CsvInput(Iterable<DataFactory> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory> relationshipDataFactory, Header.Factory relationshipHeaderFactory, List<SchemaCommand> schemaCommands, IdType idType, Configuration config, boolean autoSkipHeaders, Monitor monitor, Groups groups, MemoryTracker memoryTracker) {
        this.autoSkipHeaders = autoSkipHeaders;
        this.memoryTracker = memoryTracker;
        CsvInput.assertSaneConfiguration(config);
        this.nodeDataFactory = nodeDataFactory;
        this.nodeHeaderFactory = nodeHeaderFactory;
        this.relationshipDataFactory = relationshipDataFactory;
        this.relationshipHeaderFactory = relationshipHeaderFactory;
        this.schemaCommands = schemaCommands;
        this.idType = idType;
        this.config = config;
        this.monitor = monitor;
        this.groups = groups;
    }

    private static void assertSaneConfiguration(Configuration config) {
        HashMap<Character, String> delimiters = new HashMap<Character, String>();
        delimiters.put(Character.valueOf(config.delimiter()), "delimiter");
        CsvInput.checkUniqueCharacter(delimiters, config.arrayDelimiter(), "array delimiter");
        CsvInput.checkUniqueCharacter(delimiters, config.quotationCharacter(), "quotation character");
    }

    private static void checkUniqueCharacter(Map<Character, String> characters, char character, String characterDescription) {
        String conflict = characters.put(Character.valueOf(character), characterDescription);
        if (conflict != null) {
            throw new IllegalArgumentException("Character '" + character + "' specified by " + characterDescription + " is the same as specified by " + conflict);
        }
    }

    public List<SchemaCommand> schemaCommands() {
        return this.schemaCommands;
    }

    public InputIterable nodes(Collector badCollector) {
        Preconditions.checkState((boolean)this.hasBeenValidated, (String)"must call validateAndEstimate before calling nodes");
        return () -> this.stream(this.nodeDataFactory, this.nodeHeaderFactory, badCollector);
    }

    public InputIterable relationships(Collector badCollector) {
        Preconditions.checkState((boolean)this.hasBeenValidated, (String)"must call validateAndEstimate before calling relationships");
        return () -> this.stream(this.relationshipDataFactory, this.relationshipHeaderFactory, badCollector);
    }

    private InputIterator stream(Iterable<DataFactory> data, Header.Factory headerFactory, Collector badCollector) {
        return new CsvGroupInputIterator(data.iterator(), headerFactory, this.idType, this.config, badCollector, this.groups, this.autoSkipHeaders, this.delimitIds, NO_MONITOR);
    }

    public IdType idType() {
        return this.idType;
    }

    public ReadableGroups groups() {
        return this.groups;
    }

    public Input.Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) throws IOException {
        HashSet<String> seenSourceFiles = new HashSet<String>();
        MutableBoolean nodesHasAction = new MutableBoolean();
        MutableBoolean relationshipsHasAction = new MutableBoolean();
        MutableBoolean hasCompositeIdColumns = new MutableBoolean(false);
        HashMap numberOfIdsPerGroup = new HashMap();
        this.cachedNodeHeaders = new ArrayList<Header>();
        long[] nodeSample = this.validateAndEstimate(this.nodeDataFactory, this.nodeHeaderFactory, (TriConsumer<Header, String, Boolean>)((TriConsumer)(header, source, noDecorator) -> {
            long numIdColumnsGroups;
            List<Header.Entry> idHeaders;
            int numIdColumns;
            this.cachedNodeHeaders.add((Header)header);
            if (Arrays.stream(header.entries()).noneMatch(entry -> entry.type() == Type.LABEL) && noDecorator.booleanValue()) {
                this.monitor.noNodeLabelsSpecified((String)source);
            }
            if (Arrays.stream(header.entries()).anyMatch(e -> e.type() == Type.ACTION)) {
                nodesHasAction.setTrue();
            }
            if ((numIdColumns = (idHeaders = Arrays.stream(header.entries()).filter(e -> e.type() == Type.ID).toList()).size()) > 1) {
                hasCompositeIdColumns.setTrue();
                Preconditions.checkState((this.idType == IdType.STRING ? 1 : 0) != 0, (String)("Having multiple :ID columns requires idType: " + String.valueOf(IdType.STRING)));
            }
            Preconditions.checkState(((numIdColumnsGroups = idHeaders.stream().map(Header.Entry::group).distinct().count()) <= 1L ? 1 : 0) != 0, (String)"There are multiple :ID columns, but they are referring to different groups");
            if (!idHeaders.isEmpty()) {
                Group group = idHeaders.getFirst().group();
                if (numberOfIdsPerGroup.getOrDefault(group, numIdColumns) == numIdColumns) {
                    numberOfIdsPerGroup.put(group, numIdColumns);
                } else {
                    numberOfIdsPerGroup.put(group, -1);
                }
            }
        }), valueSizeCalculator, node -> node.labels().length, seenSourceFiles);
        MutableBoolean singleStartEndIdColumnRefersToCompositeId = new MutableBoolean(false);
        MutableBoolean multipleStartEndIdColumnsRefersToCompositeId = new MutableBoolean(false);
        long[] relationshipSample = this.validateAndEstimate(this.relationshipDataFactory, this.relationshipHeaderFactory, (TriConsumer<Header, String, Boolean>)((TriConsumer)(header, source, noDecorator) -> {
            if (Arrays.stream(header.entries()).noneMatch(entry -> entry.type() == Type.TYPE) && noDecorator.booleanValue()) {
                this.monitor.noRelationshipTypeSpecified((String)source);
            }
            if (Arrays.stream(header.entries()).anyMatch(e -> e.type() == Type.ACTION)) {
                relationshipsHasAction.setTrue();
            }
            List<Header.Entry> startIdHeaders = Arrays.stream(header.entries()).filter(e -> e.type() == Type.START_ID).toList();
            List<Header.Entry> endIdHeaders = Arrays.stream(header.entries()).filter(e -> e.type() == Type.END_ID).toList();
            long numStartIdColumnsGroups = startIdHeaders.stream().map(Header.Entry::group).distinct().count();
            Preconditions.checkState((numStartIdColumnsGroups <= 1L ? 1 : 0) != 0, (String)"There are multiple :START_ID columns, but they are referring to different groups");
            long numEndIdColumnsGroups = endIdHeaders.stream().map(Header.Entry::group).distinct().count();
            Preconditions.checkState((numEndIdColumnsGroups <= 1L ? 1 : 0) != 0, (String)"There are multiple :END_ID columns, but they are referring to different groups");
            Group startIdGroup = startIdHeaders.getFirst().group();
            Group endIdGroup = endIdHeaders.getFirst().group();
            CsvInput.validateStartAndEndIdColumnAmounts("START_ID", numberOfIdsPerGroup.getOrDefault(startIdGroup, 1), startIdHeaders.size(), startIdGroup, singleStartEndIdColumnRefersToCompositeId, multipleStartEndIdColumnsRefersToCompositeId);
            CsvInput.validateStartAndEndIdColumnAmounts("END_ID", numberOfIdsPerGroup.getOrDefault(endIdGroup, 1), endIdHeaders.size(), endIdGroup, singleStartEndIdColumnRefersToCompositeId, multipleStartEndIdColumnsRefersToCompositeId);
        }), valueSizeCalculator, entity -> 0, seenSourceFiles);
        this.delimitIds = hasCompositeIdColumns.isTrue() && singleStartEndIdColumnRefersToCompositeId.isFalse();
        this.hasBeenValidated = true;
        long propPreAllocAdditional = CsvInput.propertyPreAllocateRounding(nodeSample[2] + relationshipSample[2]) / 2L;
        return Input.knownEstimates((long)nodeSample[0], (long)relationshipSample[0], (long)nodeSample[1], (long)relationshipSample[1], (long)(nodeSample[2] + propPreAllocAdditional), (long)(relationshipSample[2] + propPreAllocAdditional), (long)nodeSample[3], (boolean)nodesHasAction.isTrue(), (boolean)relationshipsHasAction.isTrue());
    }

    private static void validateStartAndEndIdColumnAmounts(String columnName, int numberOfIdColumnsForGroup, int numIdColumns, Group group, MutableBoolean singleStartEndIdColumnRefersToCompositeIdColumn, MutableBoolean multipleStartEndIdColumnsRefersToCompositeIdColumn) {
        if (numberOfIdColumnsForGroup == 1) {
            Preconditions.checkState((numberOfIdColumnsForGroup == numIdColumns ? 1 : 0) != 0, (String)"There are %d :%s columns for group '%s', but %d :%s columns is expected.".formatted(numIdColumns, columnName, group.name(), numberOfIdColumnsForGroup, columnName));
        } else if (numIdColumns == 1) {
            singleStartEndIdColumnRefersToCompositeIdColumn.setTrue();
            Preconditions.checkState((boolean)multipleStartEndIdColumnsRefersToCompositeIdColumn.isFalse(), (String)MIXED_COMPOSITE_ID_REFERRALS);
        } else {
            multipleStartEndIdColumnsRefersToCompositeIdColumn.setTrue();
            int expectedNumberOfStartIdColumns = numberOfIdColumnsForGroup == -1 ? 1 : numberOfIdColumnsForGroup;
            Preconditions.checkState((expectedNumberOfStartIdColumns == numIdColumns ? 1 : 0) != 0, (String)"There are %d :%s columns for group '%s', but %d :%s columns is expected.".formatted(numIdColumns, columnName, group.name(), expectedNumberOfStartIdColumns, columnName));
            Preconditions.checkState((boolean)singleStartEndIdColumnRefersToCompositeIdColumn.isFalse(), (String)MIXED_COMPOSITE_ID_REFERRALS);
        }
    }

    private long[] validateAndEstimate(Iterable<DataFactory> dataFactories, Header.Factory headerFactory, TriConsumer<Header, String, Boolean> headerChecker, PropertySizeCalculator valueSizeCalculator, ToIntFunction<InputEntity> additionalCalculator, Set<String> seenSourceFiles) throws IOException {
        long[] estimates = new long[4];
        try (CsvInputChunkProxy chunk = new CsvInputChunkProxy();){
            Configuration sampleConfig = this.config.toBuilder().withReadIsForSampling(true).build();
            int groupId = 0;
            for (DataFactory dataFactory : dataFactories) {
                ++groupId;
                Header header = null;
                Data data = dataFactory.create(sampleConfig);
                Decorator decorator = data.decorator();
                try {
                    RawIterator<CharReadable, IOException> stream = data.stream();
                    while (stream.hasNext()) {
                        CharReadable source = (CharReadable)stream.next();
                        try {
                            String sourceDescription = source.sourceDescription();
                            if (!seenSourceFiles.add(sourceDescription)) {
                                this.monitor.duplicateSourceFile(sourceDescription);
                            }
                            if (header == null) {
                                header = CsvInputIterator.extractHeader(source, headerFactory, this.idType, sampleConfig, this.groups, this.monitor);
                                headerChecker.accept((Object)header, (Object)sourceDescription, (Object)(decorator == InputEntityDecorators.NO_DECORATOR ? 1 : 0));
                            }
                            this.sample(chunk, sampleConfig, source, groupId, header, decorator, valueSizeCalculator, additionalCalculator, estimates);
                        }
                        finally {
                            if (source == null) continue;
                            source.close();
                        }
                    }
                }
                finally {
                    if (decorator == null) continue;
                    decorator.close();
                }
            }
        }
        return estimates;
    }

    private void sample(CsvInputChunkProxy chunk, Configuration sampleConfig, CharReadable source, int groupId, Header header, Decorator decorator, PropertySizeCalculator valueSizeCalculator, ToIntFunction<InputEntity> additionalCalculator, long[] estimates) throws IOException {
        try (CsvInputIterator iterator = new CsvInputIterator(source, decorator, header, sampleConfig, this.idType, Collector.EMPTY, CsvGroupInputIterator.extractors(sampleConfig), groupId, this.autoSkipHeaders, false);
             InputEntity entity = new InputEntity();){
            int entities = 0;
            double properties = 0.0;
            double propertySize = 0.0;
            double additional = 0.0;
            while (iterator.position() < ESTIMATE_SAMPLE_SIZE && iterator.next(chunk)) {
                while (chunk.next(entity)) {
                    properties += (double)entity.properties.size();
                    propertySize += (double)Inputs.calculatePropertySize(entity, valueSizeCalculator, CursorContext.NULL_CONTEXT, this.memoryTracker);
                    additional += (double)additionalCalculator.applyAsInt(entity);
                    ++entities;
                }
            }
            if (entities > 0) {
                long position = iterator.position();
                float actualFileSize = (float)source.length() / iterator.compressionRatio();
                float entityCountInSource = actualFileSize / (float)position * (float)entities;
                estimates[0] = estimates[0] + (long)entityCountInSource;
                estimates[1] = estimates[1] + (long)(properties / (double)entities * (double)entityCountInSource);
                estimates[2] = estimates[2] + (long)(propertySize / (double)entities * (double)entityCountInSource);
                estimates[3] = estimates[3] + (long)(additional / (double)entities * (double)entityCountInSource);
            }
        }
    }

    public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        if (this.cachedNodeHeaders == null) {
            this.cachedNodeHeaders = new ArrayList<Header>();
            try {
                for (DataFactory dataFactory : this.nodeDataFactory) {
                    Data data = dataFactory.create(this.config);
                    CharSeeker dataStream = CharSeekers.charSeeker((CharReadable)new MultiReadable(data.stream()), (Configuration)this.config, (boolean)false);
                    try {
                        this.cachedNodeHeaders.add(DataFactories.defaultFormatNodeFileHeader().create(dataStream, this.config, this.idType, this.groups));
                    }
                    finally {
                        if (dataStream == null) continue;
                        dataStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        HashMap<String, SchemaDescriptor> result = new HashMap<String, SchemaDescriptor>();
        for (Header header : this.cachedNodeHeaders) {
            CsvInput.collectReferencedNodeSchemaFromHeader(header, tokenHolders, result);
        }
        return result;
    }

    public static void collectReferencedNodeSchemaFromHeader(Header header, TokenHolders tokenHolders, Map<String, SchemaDescriptor> result) {
        Arrays.stream(header.entries()).filter(e -> e.type() == Type.ID).findAny().ifPresent(entry -> {
            Map<String, String> options = entry.rawOptions();
            String labelName = options.get("label");
            Preconditions.checkState((labelName != null ? 1 : 0) != 0, (String)"No label was specified for the node index in '%s'", (Object[])new Object[]{entry});
            String keyName = entry.name();
            Preconditions.checkState((keyName != null ? 1 : 0) != 0, (String)"No property key was specified for node index in '%s'", (Object[])new Object[]{entry});
            int label = tokenHolders.labelTokens().getIdByName(labelName);
            int key = tokenHolders.propertyKeyTokens().getIdByName(keyName);
            Preconditions.checkState((label != -1 ? 1 : 0) != 0, (String)"Label '%s' for node index specified in '%s' does not exist", (Object[])new Object[]{labelName, entry});
            Preconditions.checkState((key != -1 ? 1 : 0) != 0, (String)"Property key '%s' for node index specified in '%s' does not exist", (Object[])new Object[]{keyName, entry});
            LabelSchemaDescriptor schemaDescriptor = SchemaDescriptors.forLabel((int)label, (int[])new int[]{key});
            SchemaDescriptor prev = (SchemaDescriptor)result.put(entry.group().name(), (SchemaDescriptor)schemaDescriptor);
            Preconditions.checkState((prev == null || prev.equals((Object)schemaDescriptor) ? 1 : 0) != 0, (String)("Multiple different indexes for group " + String.valueOf(entry.group())));
        });
    }

    private static long propertyPreAllocateRounding(long initialEstimatedPropertyStoreSize) {
        if (!SystemUtils.IS_OS_LINUX) {
            return 0L;
        }
        long preAllocSize = ByteUnit.mebiBytes((long)32L);
        if (initialEstimatedPropertyStoreSize < preAllocSize) {
            return 0L;
        }
        long chunks = 1L + initialEstimatedPropertyStoreSize / preAllocSize;
        long estimatedFinalPropertyStoreSize = chunks * preAllocSize;
        return estimatedFinalPropertyStoreSize - initialEstimatedPropertyStoreSize;
    }

    public static Extractor<?> idExtractor(IdType idType, Extractors extractors) {
        return switch (idType) {
            default -> throw new MatchException(null, null);
            case IdType.STRING -> extractors.string();
            case IdType.INTEGER, IdType.ACTUAL -> extractors.long_();
        };
    }

    public static interface Monitor
    extends Header.Monitor {
        public void duplicateSourceFile(String var1);

        public void noNodeLabelsSpecified(String var1);

        public void noRelationshipTypeSpecified(String var1);
    }

    public static class PrintingMonitor
    extends Header.PrintingMonitor
    implements Monitor {
        private final PrintStream out;

        public PrintingMonitor(PrintStream out) {
            super(out);
            this.out = out;
        }

        @Override
        public void duplicateSourceFile(String sourceFile) {
            this.out.printf("WARN: source file %s has been specified multiple times, this may result in unwanted duplicates%n", sourceFile);
        }

        @Override
        public void noNodeLabelsSpecified(String sourceFile) {
            this.out.printf("WARN: file group with header file %s specifies no node labels, which could be a mistake%n", sourceFile);
        }

        @Override
        public void noRelationshipTypeSpecified(String sourceFile) {
            this.out.printf("WARN: file group with header file %s specifies no relationship type, which could be a mistake%n", sourceFile);
        }
    }
}

