/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import blue.strategic.parquet.ParquetReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.batchimport.api.InputIterable;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.cloud.storage.io.ReadableChannel;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.HeaderException;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.parquet.DuplicatedColumnException;
import org.neo4j.internal.batchimport.input.parquet.EntityType;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetGroupInputIterator;
import org.neo4j.internal.batchimport.input.parquet.ParquetLogicalColumnType;
import org.neo4j.internal.batchimport.input.parquet.ParquetMonitor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Preconditions;

public class ParquetInput
implements Input {
    public static final char DELIMITER = '\u0007';
    private static final Supplier<ZoneId> defaultTimezoneSupplier = () -> ZoneOffset.UTC;
    private final List<ParquetData> nodeDatas;
    private final List<ParquetData> relationshipDatas;
    private final List<SchemaCommand> schemaCommands;
    private final IdType idType;
    private final Groups groups;
    private final ParquetMonitor monitor;
    private final Map<Set<String>, List<Path[]>> nodeFiles;
    private final Map<String, List<Path[]>> relationshipFiles;
    private final Map<Path, List<ParquetColumn>> verifiedColumns;
    private final String arrayDelimiter;
    private final String vectorDelimiter;
    private final String csvDelimiter;

    public ParquetInput(Map<Set<String>, List<Path[]>> nodeFiles, Map<String, List<Path[]>> relationshipFiles, List<SchemaCommand> schemaCommands, IdType idType, Configuration csvConfig, Groups groups, ParquetMonitor monitor) {
        this.idType = idType;
        this.groups = groups;
        this.monitor = monitor;
        this.arrayDelimiter = Character.valueOf(csvConfig.arrayDelimiter()).toString();
        this.vectorDelimiter = Character.valueOf(csvConfig.vectorDelimiter()).toString();
        this.csvDelimiter = Character.valueOf(csvConfig.delimiter()).toString();
        this.nodeFiles = nodeFiles;
        this.relationshipFiles = relationshipFiles;
        this.schemaCommands = schemaCommands;
        this.verifiedColumns = this.verifyColumns(nodeFiles, relationshipFiles);
        this.nodeDatas = ParquetInput.nodeData(this.verifiedColumns, nodeFiles);
        this.relationshipDatas = ParquetInput.relationshipData(this.verifiedColumns, relationshipFiles);
    }

    public InputIterable nodes(Collector badCollector) {
        return () -> new ParquetGroupInputIterator(this.nodeDatas, this.groups, this.idType, this.arrayDelimiter, this.vectorDelimiter);
    }

    public InputIterable relationships(Collector badCollector) {
        return () -> new ParquetGroupInputIterator(this.relationshipDatas, this.groups, this.idType, this.arrayDelimiter, this.vectorDelimiter);
    }

    public IdType idType() {
        return this.idType;
    }

    public ReadableGroups groups() {
        return this.groups;
    }

    public List<SchemaCommand> schemaCommands() {
        return this.schemaCommands;
    }

    private static List<ParquetData> nodeData(Map<Path, List<ParquetColumn>> verifiedColumns, Map<Set<String>, List<Path[]>> nodeFiles) {
        return ParquetInput.parquetData(verifiedColumns, nodeFiles, Function.identity());
    }

    private static List<ParquetData> relationshipData(Map<Path, List<ParquetColumn>> verifiedColumns, Map<String, List<Path[]>> relationshipFiles) {
        return ParquetInput.parquetData(verifiedColumns, relationshipFiles, typeGroupOrNull -> typeGroupOrNull == null ? Set.of() : Set.of(typeGroupOrNull));
    }

    private static <KEY> List<ParquetData> parquetData(Map<Path, List<ParquetColumn>> verifiedColumns, Map<KEY, List<Path[]>> files, Function<KEY, Set<String>> keyExtractor) {
        MutableList columnData = Lists.mutable.empty();
        files.forEach((key, allPaths) -> {
            Iterator iterator = allPaths.iterator();
            while (iterator.hasNext()) {
                Path[] paths;
                for (Path path : paths = (Path[])iterator.next()) {
                    if (path.toString().endsWith(".csv")) continue;
                    columnData.add((Object)new ParquetData((Set)keyExtractor.apply(key), path, (List)verifiedColumns.get(path), defaultTimezoneSupplier));
                }
            }
        });
        return columnData;
    }

    private Map<Path, List<ParquetColumn>> verifyColumns(Map<Set<String>, List<Path[]>> labelsAndNodeFiles, Map<String, List<Path[]>> typeAndRelationshipFiles) {
        HeaderContext headerContext = new HeaderContext();
        HashMap<Path, List<ParquetColumn>> columnInfo = new HashMap<Path, List<ParquetColumn>>();
        try {
            List columns;
            for (Map.Entry<Set<String>, List<Path[]>> entry : labelsAndNodeFiles.entrySet()) {
                boolean hasLabelColumn = !entry.getKey().isEmpty() && entry.getKey().stream().anyMatch(label -> !label.isBlank());
                List<Path> nodeFiles = entry.getValue().stream().flatMap(Arrays::stream).toList();
                for (Path nodeFile : nodeFiles) {
                    ParquetMetadata metadata;
                    if (this.processPotentialHeaderFile(nodeFile, nodeFiles, headerContext)) {
                        headerContext.setHeaderFileExistsFor(entry.getKey());
                        continue;
                    }
                    try {
                        metadata = ParquetReader.readMetadata((InputFile)ParquetImportInputFile.of(nodeFile));
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Could not read parquet file %s".formatted(nodeFile.toAbsolutePath()), e);
                    }
                    ArrayList<ParquetColumn> currentColumnInfo = new ArrayList<ParquetColumn>();
                    HashSet<String> propertyNames = new HashSet<String>();
                    String previousGroupName = null;
                    columns = metadata.getFileMetaData().getSchema().getColumns();
                    HashSet<String> mapColumns = new HashSet<String>();
                    HashSet<String> structColumns = new HashSet<String>();
                    String fileName = nodeFile.getFileName().toString();
                    boolean hasIdColumn = false;
                    for (int i = 0; i < columns.size(); ++i) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)columns.get(i);
                        String[] namePath = columnDescriptor.getPath();
                        String columnName = namePath[0];
                        if (columnName.isBlank()) {
                            throw new InputException("column name must not be blank");
                        }
                        try {
                            String firstPropertyNamePart;
                            String propertyName;
                            ParquetColumn parquetColumn;
                            if (headerContext.columnShouldBeSkipped(entry.getKey(), nodeFiles, i, columnName) || (parquetColumn = ParquetColumn.from(headerContext.getHeaderDefinition(nodeFiles, i, columnName), EntityType.NODE)).isIgnoredColumn()) continue;
                            String string = propertyName = parquetColumn.propertyName() != null ? parquetColumn.propertyName() : parquetColumn.logicalColumnType().name();
                            if (parquetColumn.isIdColumn() && parquetColumn.groupName() != null) {
                                if (previousGroupName != null && !previousGroupName.equals(parquetColumn.groupName())) {
                                    throw new IllegalStateException("There are multiple :ID columns, but they are referring to different groups");
                                }
                                previousGroupName = parquetColumn.groupName();
                            }
                            if (hasIdColumn && parquetColumn.isIdColumn()) {
                                Preconditions.checkState((this.idType == IdType.STRING ? 1 : 0) != 0, (String)("Having multiple :ID columns requires idType: " + String.valueOf(IdType.STRING)));
                            }
                            if (parquetColumn.isIdColumn()) {
                                hasIdColumn = true;
                            }
                            if (propertyNames.contains(propertyName) && parquetColumn.isIdColumn()) {
                                throw new DuplicatedColumnException("Cannot store composite IDs as properties, only individual part. Property %s / File: %s".formatted(propertyName, fileName));
                            }
                            String string2 = firstPropertyNamePart = propertyName.contains(".") ? propertyName.split("\\.")[0] : propertyName;
                            if ((propertyNames.contains(propertyName) || propertyNames.contains(firstPropertyNamePart)) && !mapColumns.contains(propertyName) && !structColumns.contains(propertyName)) {
                                throw new DuplicatedColumnException("Duplicated header property %s found in file %s.".formatted(propertyName, fileName));
                            }
                            propertyNames.add(propertyName);
                            if (parquetColumn.logicalColumnType() == ParquetLogicalColumnType.ID) {
                                this.groups.getOrCreate(parquetColumn.groupName());
                            }
                            if (parquetColumn.columnType().needsConversion()) {
                                this.monitor.typeNormalized(fileName, propertyName, parquetColumn.columnType().name(), parquetColumn.columnType().convertedType().name());
                            }
                            if (parquetColumn.logicalColumnType() == ParquetLogicalColumnType.LABEL) {
                                hasLabelColumn = true;
                            }
                            if (!mapColumns.contains(propertyName)) {
                                currentColumnInfo.add(parquetColumn);
                            }
                            if (namePath.length > 1 && "key_value".equals(namePath[1])) {
                                mapColumns.add(propertyName);
                                continue;
                            }
                            if (namePath.length <= 1) continue;
                            structColumns.add(propertyName);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw new InputException("Column name " + columnName + " is used as a special type but is unknown. Allowed types are " + ParquetColumn.getReservedColumns(EntityType.NODE), e);
                        }
                    }
                    if (!hasLabelColumn) {
                        this.monitor.noNodeLabelsSpecified(fileName);
                    }
                    columnInfo.put(nodeFile, currentColumnInfo);
                }
            }
            for (Map.Entry<Object, List<Path[]>> entry : typeAndRelationshipFiles.entrySet()) {
                List<Path> relationshipFileList = entry.getValue().stream().flatMap(Arrays::stream).toList();
                HashSet<String> mapColumns = new HashSet<String>();
                HashSet<String> structColumns = new HashSet<String>();
                for (Path relationshipFile : relationshipFileList) {
                    ParquetMetadata metadata;
                    if (this.processPotentialHeaderFile(relationshipFile, relationshipFileList, headerContext)) {
                        headerContext.setHeaderFileExistsFor((String)entry.getKey());
                        continue;
                    }
                    try {
                        metadata = ParquetReader.readMetadata((InputFile)ParquetImportInputFile.of(relationshipFile));
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Could not read parquet file %s".formatted(relationshipFile.toAbsolutePath()), e);
                    }
                    ArrayList<ParquetColumn> currentColumnInfo = new ArrayList<ParquetColumn>();
                    HashSet<String> propertyNames = new HashSet<String>();
                    columns = metadata.getFileMetaData().getSchema().getColumns();
                    boolean hasTypeColumn = entry.getKey() != null && !((String)entry.getKey()).isBlank();
                    String fileName = relationshipFile.getFileName().toString();
                    for (int i = 0; i < columns.size(); ++i) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)columns.get(i);
                        String[] namePath = columnDescriptor.getPath();
                        String columnName = namePath[0];
                        try {
                            String propertyName;
                            ParquetColumn parquetColumn;
                            if (headerContext.columnShouldBeSkipped((String)entry.getKey(), relationshipFileList, i, columnName) || (parquetColumn = ParquetColumn.from(headerContext.getHeaderDefinition(relationshipFileList, i, columnName), EntityType.RELATIONSHIP)).isIgnoredColumn()) continue;
                            String string = propertyName = parquetColumn.propertyName() != null ? parquetColumn.propertyName() : parquetColumn.logicalColumnType().name();
                            if (propertyNames.contains(propertyName) && !mapColumns.contains(propertyName) && !structColumns.contains(propertyName)) {
                                throw new DuplicatedColumnException("Duplicated header property %s found in file %s.".formatted(propertyName, fileName));
                            }
                            propertyNames.add(propertyName);
                            if (parquetColumn.columnType().needsConversion()) {
                                this.monitor.typeNormalized(fileName, propertyName, parquetColumn.columnType().name(), parquetColumn.columnType().convertedType().name());
                            }
                            if (parquetColumn.logicalColumnType() == ParquetLogicalColumnType.START_ID || parquetColumn.logicalColumnType() == ParquetLogicalColumnType.END_ID) {
                                try {
                                    this.groups.get(parquetColumn.groupName());
                                }
                                catch (HeaderException e) {
                                    throw new InputException(e.getMessage());
                                }
                            }
                            if (parquetColumn.logicalColumnType() == ParquetLogicalColumnType.TYPE) {
                                hasTypeColumn = true;
                            }
                            if (!mapColumns.contains(propertyName)) {
                                currentColumnInfo.add(parquetColumn);
                            }
                            if (namePath.length > 1 && "key_value".equals(namePath[1])) {
                                mapColumns.add(propertyName);
                            }
                            if (namePath.length <= 1) continue;
                            structColumns.add(propertyName);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw new InputException("Column name " + columnName + " is used as a special type but is unknown. Allowed types are " + ParquetColumn.getReservedColumns(EntityType.RELATIONSHIP));
                        }
                    }
                    columnInfo.put(relationshipFile, currentColumnInfo);
                    if (hasTypeColumn) continue;
                    this.monitor.noRelationshipTypeSpecified(fileName);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return columnInfo;
    }

    private boolean processPotentialHeaderFile(Path path, List<Path> paths, HeaderContext headerContext) throws IOException {
        if (!this.isHeaderFile(path, paths)) {
            return false;
        }
        try (BufferedReader csvInputStream = new BufferedReader(new InputStreamReader(path.getFileSystem().provider().newInputStream(path, new OpenOption[0])));){
            List<String> lines = csvInputStream.lines().toList();
            if (lines.isEmpty() || lines.stream().allMatch(String::isBlank)) {
                throw new IllegalArgumentException("The header definition is empty");
            }
            if (lines.size() > 2) {
                throw new IllegalArgumentException("The header is expected to have one or two lines");
            }
            if (lines.size() == 1) {
                List<String> targetColumnNames = Arrays.stream(lines.getFirst().split(this.csvDelimiter)).map(String::trim).toList();
                for (int i = 0; i < targetColumnNames.size(); ++i) {
                    headerContext.addHeaderDefinition(paths, i, ParquetColumn.HeaderDefinition.from(targetColumnNames.get(i)));
                }
            } else {
                List<String> targetColumnNames = Arrays.stream(lines.get(0).split(this.csvDelimiter)).map(String::trim).toList();
                List<String> existingParquetColumns = Arrays.stream(lines.get(1).split(this.csvDelimiter)).map(String::trim).toList();
                for (int i = 0; i < targetColumnNames.size(); ++i) {
                    headerContext.addHeaderDefinition(paths, existingParquetColumns.get(i), ParquetColumn.HeaderDefinition.from(targetColumnNames.get(i), existingParquetColumns.get(i)));
                }
            }
        }
        return true;
    }

    private boolean isHeaderFile(Path path, List<Path> paths) {
        boolean isHeaderFile = path.toString().endsWith(".csv");
        if (isHeaderFile && paths.indexOf(path) != 0) {
            throw new IllegalArgumentException("CSV header file for parquet data import must appear only once, as the first entry");
        }
        return isHeaderFile;
    }

    public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        List<ParquetColumn> idColumns = this.verifiedColumns.values().stream().flatMap(Collection::stream).filter(ParquetColumn::isIdColumn).toList();
        HashMap<String, SchemaDescriptor> result = new HashMap<String, SchemaDescriptor>();
        this.checkReferencedNodeSchema(idColumns, tokenHolders, result);
        return result;
    }

    private void checkReferencedNodeSchema(List<ParquetColumn> idColumns, TokenHolders tokenHolders, Map<String, SchemaDescriptor> result) {
        idColumns.forEach(column -> {
            String labelName = column.idLabel();
            Preconditions.checkState((labelName != null ? 1 : 0) != 0, (String)"No label was specified for the node index in '%s'", (Object[])new Object[]{column});
            String keyName = column.propertyName();
            Preconditions.checkState((keyName != null ? 1 : 0) != 0, (String)"No property key was specified for node index in '%s'", (Object[])new Object[]{column});
            int label = tokenHolders.labelTokens().getIdByName(labelName);
            int key = tokenHolders.propertyKeyTokens().getIdByName(keyName);
            Preconditions.checkState((label != -1 ? 1 : 0) != 0, (String)"Label '%s' for node index specified in '%s' does not exist", (Object[])new Object[]{labelName, column});
            Preconditions.checkState((key != -1 ? 1 : 0) != 0, (String)"Property key '%s' for node index specified in '%s' does not exist", (Object[])new Object[]{keyName, column});
            LabelSchemaDescriptor schemaDescriptor = SchemaDescriptors.forLabel((int)label, (int[])new int[]{key});
            SchemaDescriptor prev = (SchemaDescriptor)result.put(column.groupName(), (SchemaDescriptor)schemaDescriptor);
            Preconditions.checkState((prev == null || prev.equals((Object)schemaDescriptor) ? 1 : 0) != 0, (String)("Multiple different indexes for group " + column.groupName()));
        });
    }

    public Input.Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) throws IOException {
        long numberOfNodes = 0L;
        long numberOfNodeProperties = 0L;
        long totalNodePropertiesSize = 0L;
        HashSet<String> mergedLabels = new HashSet<String>();
        for (Map.Entry<Set<String>, List<Path[]>> nodePathEntries : this.nodeFiles.entrySet()) {
            mergedLabels.addAll(Collections.unmodifiableSet(nodePathEntries.getKey()));
            for (Path[] nodePaths : nodePathEntries.getValue()) {
                for (Path nodePath : nodePaths) {
                    try {
                        if (nodePath.endsWith("csv")) continue;
                        ParquetMetadata metadata = ParquetReader.readMetadata((InputFile)ParquetImportInputFile.of(nodePath));
                        List blocks = metadata.getBlocks();
                        for (BlockMetaData block : blocks) {
                            numberOfNodes += block.getRowCount();
                            int currentColumnCount = block.getColumns().size();
                            if ((long)currentColumnCount > numberOfNodeProperties) {
                                numberOfNodeProperties = currentColumnCount;
                            }
                            for (ColumnChunkMetaData column : block.getColumns()) {
                                totalNodePropertiesSize += column.getTotalUncompressedSize();
                            }
                        }
                    }
                    catch (RuntimeException metadata) {
                        // empty catch block
                    }
                }
            }
        }
        int numberOfNodeLabels = mergedLabels.size();
        long numberOfRelationships = 0L;
        long numberOfRelationshipProperties = 0L;
        long totalRelationshipPropertiesSize = 0L;
        for (Map.Entry<String, List<Path[]>> relationshipFileEntries : this.relationshipFiles.entrySet()) {
            for (Path[] relationshipPaths : relationshipFileEntries.getValue()) {
                for (Path relationshipPath : relationshipPaths) {
                    try {
                        if (relationshipPath.endsWith("csv")) continue;
                        ParquetMetadata metadata = ParquetReader.readMetadata((InputFile)ParquetImportInputFile.of(relationshipPath));
                        for (BlockMetaData block : metadata.getBlocks()) {
                            numberOfNodes += block.getRowCount();
                            int currentColumnCount = block.getColumns().size();
                            if ((long)currentColumnCount > numberOfNodeProperties) {
                                numberOfNodeProperties = currentColumnCount;
                            }
                            for (ColumnChunkMetaData column : block.getColumns()) {
                                totalRelationshipPropertiesSize += column.getTotalUncompressedSize();
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
        return Input.knownEstimates((long)numberOfNodes, (long)numberOfRelationships, (long)numberOfNodeProperties, (long)numberOfRelationshipProperties, (long)totalNodePropertiesSize, (long)totalRelationshipPropertiesSize, (long)numberOfNodeLabels);
    }

    private static class HeaderContext {
        private final Set<Set<String>> nodeHeaders = new HashSet<Set<String>>();
        private final Set<String> relationshipHeaders = new HashSet<String>();
        private final Map<List<Path>, Map<String, ParquetColumn.HeaderDefinition>> headerColumnNameDefinitions = new HashMap<List<Path>, Map<String, ParquetColumn.HeaderDefinition>>();
        private final Map<List<Path>, Map<Integer, ParquetColumn.HeaderDefinition>> headerColumnIndexDefinitions = new HashMap<List<Path>, Map<Integer, ParquetColumn.HeaderDefinition>>();

        private HeaderContext() {
        }

        private void setHeaderFileExistsFor(Set<String> labels) {
            this.nodeHeaders.add(labels);
        }

        private boolean hasHeader(Set<String> labels) {
            return this.nodeHeaders.contains(labels);
        }

        private void setHeaderFileExistsFor(String type) {
            this.relationshipHeaders.add(type);
        }

        private boolean hasHeader(String type) {
            return this.relationshipHeaders.contains(type);
        }

        private void addHeaderDefinition(List<Path> files, String columnName, ParquetColumn.HeaderDefinition headerDefinition) {
            this.headerColumnNameDefinitions.putIfAbsent(files, new HashMap());
            this.headerColumnNameDefinitions.get(files).put(columnName, headerDefinition);
        }

        private void addHeaderDefinition(List<Path> files, Integer index, ParquetColumn.HeaderDefinition headerDefinition) {
            this.headerColumnIndexDefinitions.putIfAbsent(files, new HashMap());
            this.headerColumnIndexDefinitions.get(files).put(index, headerDefinition);
        }

        private ParquetColumn.HeaderDefinition getHeaderDefinition(List<Path> files, Integer index, String columnName) {
            if (this.headerColumnNameDefinitions.get(files) != null) {
                return this.headerColumnNameDefinitions.get(files).get(columnName);
            }
            if (this.headerColumnIndexDefinitions.get(files) != null) {
                return this.headerColumnIndexDefinitions.get(files).get(index).addParquetColumnName(columnName);
            }
            return new ParquetColumn.SingleRowHeaderDefinition(columnName);
        }

        private boolean isNotIncludedInHeaderDefinition(List<Path> value, Integer index, String columnName) {
            return this.headerColumnNameDefinitions.containsKey(value) && !this.headerColumnNameDefinitions.get(value).containsKey(columnName) || this.headerColumnIndexDefinitions.containsKey(value) && !this.headerColumnIndexDefinitions.get(value).containsKey(index);
        }

        private boolean columnShouldBeSkipped(Set<String> labels, List<Path> nodeFiles, int index, String columnName) {
            return this.hasHeader(labels) && this.isNotIncludedInHeaderDefinition(nodeFiles, index, columnName);
        }

        private boolean columnShouldBeSkipped(String type, List<Path> relationshipFiles, int index, String columnName) {
            return this.hasHeader(type) && this.isNotIncludedInHeaderDefinition(relationshipFiles, index, columnName);
        }
    }

    static class ParquetImportInputFile
    implements InputFile {
        static Map<Path, ParquetImportInputFile> importFileCache = new HashMap<Path, ParquetImportInputFile>();
        private final Path filePath;

        static ParquetImportInputFile of(Path importFilePath) {
            return importFileCache.computeIfAbsent(importFilePath, any -> new ParquetImportInputFile(importFilePath));
        }

        private ParquetImportInputFile(Path lePath) {
            this.filePath = lePath;
        }

        public long getLength() throws IOException {
            return Files.size(this.filePath);
        }

        public SeekableInputStream newStream() throws IOException {
            InputStream inputStream = Files.newInputStream(this.filePath, new OpenOption[0]);
            if (inputStream instanceof ReadableChannel) {
                final ReadableChannel cloudFileChannel = (ReadableChannel)inputStream;
                return new DelegatingSeekableInputStream(this, inputStream){
                    private long position;
                    {
                        super(stream);
                        this.position = 0L;
                    }

                    public long getPos() {
                        return this.position;
                    }

                    public void seek(long newPos) throws IOException {
                        cloudFileChannel.position(newPos);
                        this.position = newPos;
                    }
                };
            }
            inputStream = new FileInputStream(this.filePath.toFile());
            final FileInputStream fis = (FileInputStream)inputStream;
            return new DelegatingSeekableInputStream(this, fis){
                private long position;
                {
                    super(stream);
                    this.position = 0L;
                }

                public long getPos() {
                    return this.position;
                }

                public void seek(long newPos) throws IOException {
                    fis.getChannel().position(newPos);
                    this.position = newPos;
                }
            };
        }

        public String toString() {
            return "ParquetFile{path=" + String.valueOf(this.filePath) + "}";
        }
    }
}

