/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.neo4j.internal.batchimport.cache.BaseDynamicArray;
import org.neo4j.internal.batchimport.cache.BufferFactory;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.memory.MemoryTracker;

class IntArrayImpl
extends BaseDynamicArray
implements IntArray {
    private static final VarHandle VH_INTEGER_BYTE_BUFFER = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);

    IntArrayImpl(long maxNumberOfElements, int elementsPerChunk, byte defaultValue, BufferFactory bufferFactory, MemoryTracker memoryTracker) {
        super(maxNumberOfElements, 4, elementsPerChunk, defaultValue, bufferFactory, memoryTracker);
    }

    @Override
    public int get(long index) {
        return VH_INTEGER_BYTE_BUFFER.get(this.getBuffer(index), this.offset(index));
    }

    @Override
    public void set(long index, int value) {
        VH_INTEGER_BYTE_BUFFER.set(this.getBuffer(index), this.offset(index), value);
    }

    @Override
    public boolean compareAndSet(long index, int expected, int value) {
        return VH_INTEGER_BYTE_BUFFER.compareAndSet(this.getBuffer(index), this.offset(index), expected, value);
    }

    @Override
    public int compareAndExchange(long index, int expected, int value) {
        return VH_INTEGER_BYTE_BUFFER.compareAndExchange(this.getBuffer(index), this.offset(index), expected, value);
    }

    @Override
    protected int offset(long index) {
        return (int)(index & (long)this.bufferMask) << 2;
    }
}

