/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.DynamicByteArray;
import org.neo4j.internal.batchimport.cache.DynamicIntArray;
import org.neo4j.internal.batchimport.cache.DynamicLongArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;

public class ChunkedNumberArrayFactory
extends NumberArrayFactory.Adapter {
    static final int MAGIC_CHUNK_COUNT = 10;
    private static final int MAX_ARRAY_SIZE = 2147450880;
    private final NumberArrayFactory delegate;

    ChunkedNumberArrayFactory(NumberArrayFactory.Monitor monitor, NumberArrayFactory ... delegateList) {
        this.delegate = new NumberArrayFactories.Auto(monitor, delegateList);
    }

    @Override
    public LongArray newLongArray(long length, long defaultValue, long base) {
        return this.newDynamicLongArray(this.fractionOf(length), defaultValue);
    }

    @Override
    public IntArray newIntArray(long length, int defaultValue, long base) {
        return this.newDynamicIntArray(this.fractionOf(length), defaultValue);
    }

    @Override
    public ByteArray newByteArray(long length, byte[] defaultValue, long base) {
        return this.newDynamicByteArray(this.fractionOf(length), defaultValue);
    }

    private long fractionOf(long length) {
        if (length < 10L) {
            return length;
        }
        return Long.min(length / 10L, 2147450880L);
    }

    @Override
    public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
        return new DynamicIntArray(this.delegate, chunkSize, defaultValue);
    }

    @Override
    public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
        return new DynamicLongArray(this.delegate, chunkSize, defaultValue);
    }

    @Override
    public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue) {
        return new DynamicByteArray(this.delegate, chunkSize, defaultValue);
    }

    public String toString() {
        return "ChunkedNumberArrayFactory with delegate " + this.delegate;
    }
}

