/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.apache.commons.lang3.mutable.MutableInt;

public abstract class RadixCalculator {
    protected static final int RADIX_BITS = 24;
    protected static final long LENGTH_BITS = -144115188075855872L;
    protected static final int LENGTH_MASK = 0xFE0000;
    protected static final int HASHCODE_MASK = 65535;

    public abstract int radixOf(long var1);

    public static class Long
    extends RadixCalculator {
        private final MutableInt radixShift;

        public Long(MutableInt radixShift) {
            this.radixShift = radixShift;
        }

        @Override
        public int radixOf(long value) {
            long val1 = value & 0x1FFFFFFFFFFFFFFL;
            int index = (int)(val1 >>>= this.radixShift.intValue());
            return index;
        }
    }

    public static class String
    extends RadixCalculator {
        @Override
        public int radixOf(long value) {
            int index = (int)(value >>> 40);
            index = (index & 0xFE0000) >>> 1 | index & 0xFFFF;
            return index;
        }
    }
}

