/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.PageCacheNumberArray;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

public class PageCacheIntArray
extends PageCacheNumberArray<IntArray>
implements IntArray {
    PageCacheIntArray(PagedFile pagedFile, long length, long defaultValue, long base) throws IOException {
        super(pagedFile, 4, length, defaultValue | defaultValue << 32, base);
    }

    @Override
    public int get(long index) {
        int n;
        block9: {
            long pageId = this.pageId(index);
            int offset = this.offset(index);
            PageCursor cursor = this.pagedFile.io(pageId, 1);
            try {
                int result;
                cursor.next();
                do {
                    result = cursor.getInt(offset);
                } while (cursor.shouldRetry());
                this.checkBounds(cursor);
                n = result;
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            cursor.close();
        }
        return n;
    }

    @Override
    public void set(long index, int value) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putInt(offset, value);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

