/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.PageCacheNumberArray;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class PageCacheLongArray
extends PageCacheNumberArray<LongArray>
implements LongArray {
    private static final String PAGE_CACHE_LONG_ARRAY_WORKER_TAG = "pageCacheLongArrayWorker";

    PageCacheLongArray(PagedFile pagedFile, PageCacheTracer pageCacheTracer, long length, long defaultValue, long base) throws IOException {
        super(pagedFile, pageCacheTracer, 8, length, defaultValue, base);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long get(long index) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(PAGE_CACHE_LONG_ARRAY_WORKER_TAG);){
            long l;
            block15: {
                PageCursor cursor = this.pagedFile.io(pageId, 1, cursorTracer);
                try {
                    long result;
                    cursor.next();
                    do {
                        result = cursor.getLong(offset);
                    } while (cursor.shouldRetry());
                    this.checkBounds(cursor);
                    l = result;
                    if (cursor == null) break block15;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cursor.close();
            }
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void set(long index, long value) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(PAGE_CACHE_LONG_ARRAY_WORKER_TAG);
             PageCursor cursor = this.pagedFile.io(pageId, 6, cursorTracer);){
            cursor.next();
            cursor.putLong(offset, value);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

