/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.PageCacheByteArray;
import org.neo4j.internal.batchimport.cache.PageCacheIntArray;
import org.neo4j.internal.batchimport.cache.PageCacheLongArray;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.Log;
import org.neo4j.memory.MemoryTracker;

public class PageCachedNumberArrayFactory
extends NumberArrayFactory.Adapter {
    private final PageCache pageCache;
    private final File storeDir;
    private final PageCacheTracer pageCacheTracer;
    private final Log log;

    public PageCachedNumberArrayFactory(PageCache pageCache, PageCacheTracer pageCacheTracer, File storeDir, Log log) {
        this.pageCache = Objects.requireNonNull(pageCache);
        this.log = log;
        this.pageCacheTracer = Objects.requireNonNull(pageCacheTracer);
        this.storeDir = Objects.requireNonNull(storeDir);
    }

    @Override
    public IntArray newIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
        try {
            File tempFile = File.createTempFile("intArray", ".tmp", this.storeDir);
            PagedFile pagedFile = this.pageCache.map(tempFile, this.pageCache.pageSize(), Sets.immutable.of((Object)StandardOpenOption.DELETE_ON_CLOSE, (Object)StandardOpenOption.CREATE));
            this.log.info("Using page-cache backed caching, this may affect performance negatively. IntArray length:" + length);
            return new PageCacheIntArray(pagedFile, this.pageCacheTracer, length, (long)defaultValue, base);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public LongArray newLongArray(long length, long defaultValue, long base, MemoryTracker memoryTracker) {
        try {
            File tempFile = File.createTempFile("longArray", ".tmp", this.storeDir);
            PagedFile pagedFile = this.pageCache.map(tempFile, this.pageCache.pageSize(), Sets.immutable.of((Object)StandardOpenOption.DELETE_ON_CLOSE, (Object)StandardOpenOption.CREATE));
            this.log.info("Using page-cache backed caching, this may affect performance negatively. LongArray length:" + length);
            return new PageCacheLongArray(pagedFile, this.pageCacheTracer, length, defaultValue, base);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ByteArray newByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
        try {
            File tempFile = File.createTempFile("byteArray", ".tmp", this.storeDir);
            PagedFile pagedFile = this.pageCache.map(tempFile, this.pageCache.pageSize(), Sets.immutable.of((Object)StandardOpenOption.DELETE_ON_CLOSE, (Object)StandardOpenOption.CREATE));
            this.log.info("Using page-cache backed caching, this may affect performance negatively. ByteArray length:" + length);
            return new PageCacheByteArray(pagedFile, this.pageCacheTracer, length, defaultValue, base);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

