/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.ChunkedNumberArrayFactory;
import org.neo4j.internal.batchimport.cache.DynamicByteArray;
import org.neo4j.internal.batchimport.cache.DynamicIntArray;
import org.neo4j.internal.batchimport.cache.DynamicLongArray;
import org.neo4j.internal.batchimport.cache.HeapByteArray;
import org.neo4j.internal.batchimport.cache.HeapIntArray;
import org.neo4j.internal.batchimport.cache.HeapLongArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.OffHeapByteArray;
import org.neo4j.internal.batchimport.cache.OffHeapIntArray;
import org.neo4j.internal.batchimport.cache.OffHeapLongArray;
import org.neo4j.internal.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.unsafe.NativeMemoryAllocationRefusedError;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.MemoryTracker;

public interface NumberArrayFactory {
    public static final Monitor NO_MONITOR = (memory, successfulFactory, attemptedAllocationFailures) -> {};
    public static final NumberArrayFactory HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
            return new HeapIntArray(Math.toIntExact(length), defaultValue, base, memoryTracker);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base, MemoryTracker memoryTracker) {
            return new HeapLongArray(Math.toIntExact(length), defaultValue, base, memoryTracker);
        }

        @Override
        public HeapByteArray newByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
            return new HeapByteArray(Math.toIntExact(length), defaultValue, base, memoryTracker);
        }

        public String toString() {
            return "HEAP";
        }
    };
    public static final NumberArrayFactory OFF_HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
            return new OffHeapIntArray(length, defaultValue, base, memoryTracker);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base, MemoryTracker memoryTracker) {
            return new OffHeapLongArray(length, defaultValue, base, memoryTracker);
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
            return new OffHeapByteArray(length, defaultValue, base, memoryTracker);
        }

        public String toString() {
            return "OFF_HEAP";
        }
    };
    public static final NumberArrayFactory CHUNKED_FIXED_SIZE = new ChunkedNumberArrayFactory(NO_MONITOR);
    public static final NumberArrayFactory AUTO_WITHOUT_PAGECACHE = new Auto(NO_MONITOR, OFF_HEAP, HEAP, CHUNKED_FIXED_SIZE);

    public static NumberArrayFactory auto(PageCache pageCache, PageCacheTracer pageCacheTracer, Path dir, boolean allowHeapAllocation, Monitor monitor) {
        PageCachedNumberArrayFactory pagedArrayFactory = new PageCachedNumberArrayFactory(pageCache, pageCacheTracer, dir);
        ChunkedNumberArrayFactory chunkedArrayFactory = new ChunkedNumberArrayFactory(monitor, NumberArrayFactory.allocationAlternatives(allowHeapAllocation, pagedArrayFactory));
        return new Auto(monitor, NumberArrayFactory.allocationAlternatives(allowHeapAllocation, chunkedArrayFactory));
    }

    public static NumberArrayFactory[] allocationAlternatives(boolean allowHeapAllocation, NumberArrayFactory ... additional) {
        ArrayList<NumberArrayFactory> result = new ArrayList<NumberArrayFactory>(Collections.singletonList(OFF_HEAP));
        if (allowHeapAllocation) {
            result.add(HEAP);
        }
        result.addAll(Arrays.asList(additional));
        return result.toArray(new NumberArrayFactory[0]);
    }

    default public IntArray newIntArray(long length, int defaultValue, MemoryTracker memoryTracker) {
        return this.newIntArray(length, defaultValue, 0L, memoryTracker);
    }

    public IntArray newIntArray(long var1, int var3, long var4, MemoryTracker var6);

    public IntArray newDynamicIntArray(long var1, int var3, MemoryTracker var4);

    default public LongArray newLongArray(long length, long defaultValue, MemoryTracker memoryTracker) {
        return this.newLongArray(length, defaultValue, 0L, memoryTracker);
    }

    public LongArray newLongArray(long var1, long var3, long var5, MemoryTracker var7);

    public LongArray newDynamicLongArray(long var1, long var3, MemoryTracker var5);

    default public ByteArray newByteArray(long length, byte[] defaultValue, MemoryTracker memoryTracker) {
        return this.newByteArray(length, defaultValue, 0L, memoryTracker);
    }

    public ByteArray newByteArray(long var1, byte[] var3, long var4, MemoryTracker var6);

    public ByteArray newDynamicByteArray(long var1, byte[] var3, MemoryTracker var4);

    public static abstract class Adapter
    implements NumberArrayFactory {
        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue, MemoryTracker memoryTracker) {
            return new DynamicIntArray(this, chunkSize, defaultValue, memoryTracker);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue, MemoryTracker memoryTracker) {
            return new DynamicLongArray(this, chunkSize, defaultValue, memoryTracker);
        }

        @Override
        public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue, MemoryTracker memoryTracker) {
            return new DynamicByteArray(this, chunkSize, defaultValue, memoryTracker);
        }
    }

    public static class Auto
    extends Adapter {
        private final Monitor monitor;
        private final NumberArrayFactory[] candidates;

        public Auto(Monitor monitor, NumberArrayFactory ... candidates) {
            Objects.requireNonNull(monitor);
            this.monitor = monitor;
            this.candidates = candidates;
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base, MemoryTracker memoryTracker) {
            return this.tryAllocate(length, 8, f -> f.newLongArray(length, defaultValue, base, memoryTracker));
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
            return this.tryAllocate(length, 4, f -> f.newIntArray(length, defaultValue, base, memoryTracker));
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
            return this.tryAllocate(length, defaultValue.length, f -> f.newByteArray(length, defaultValue, base, memoryTracker));
        }

        private <T extends NumberArray<? extends T>> T tryAllocate(long length, int itemSize, Function<NumberArrayFactory, T> allocator) {
            ArrayList<AllocationFailure> failures = new ArrayList<AllocationFailure>();
            Throwable error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    try {
                        NumberArray array = (NumberArray)allocator.apply(candidate);
                        this.monitor.allocationSuccessful(length * (long)itemSize, candidate, failures);
                        return (T)array;
                    }
                    catch (ArithmeticException e) {
                        throw new OutOfMemoryError(e.getMessage());
                    }
                }
                catch (OutOfMemoryError | NativeMemoryAllocationRefusedError e) {
                    if (error == null) {
                        error = e;
                    } else {
                        e.addSuppressed(error);
                        error = e;
                    }
                    failures.add(new AllocationFailure(e, candidate));
                }
            }
            throw this.error(length, itemSize, (Error)error);
        }

        private Error error(long length, int itemSize, Error error) {
            return (Error)Exceptions.withMessage((Throwable)error, (String)String.format("%s: Not enough memory available for allocating %s, tried %s", error.getMessage(), ByteUnit.bytesToString((long)(length * (long)itemSize)), Arrays.toString(this.candidates)));
        }
    }

    public static class AllocationFailure {
        private final Throwable failure;
        private final NumberArrayFactory factory;

        AllocationFailure(Throwable failure, NumberArrayFactory factory) {
            this.failure = failure;
            this.factory = factory;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public NumberArrayFactory getFactory() {
            return this.factory;
        }
    }

    public static interface Monitor {
        public void allocationSuccessful(long var1, NumberArrayFactory var3, Iterable<AllocationFailure> var4);
    }
}

