/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.Arrays;
import java.util.function.LongFunction;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.function.Factory;
import org.neo4j.internal.batchimport.HighestId;
import org.neo4j.internal.batchimport.PropertyValueLookup;
import org.neo4j.internal.batchimport.Utils;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.LongBitsManipulator;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.CollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.GroupCache;
import org.neo4j.internal.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.internal.batchimport.cache.idmapping.string.Radix;
import org.neo4j.internal.batchimport.cache.idmapping.string.SameGroupDetector;
import org.neo4j.internal.batchimport.cache.idmapping.string.Tracker;
import org.neo4j.internal.batchimport.cache.idmapping.string.TrackerFactory;
import org.neo4j.internal.batchimport.cache.idmapping.string.Workers;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.MemoryTracker;

public class EncodingIdMapper
implements IdMapper {
    private static final String IMPORT_COLLISION_INFO_TAG = "importCollisionInfo";
    public static final Monitor NO_MONITOR = count -> {};
    private static final LongBitsManipulator COLLISION_BIT = new LongBitsManipulator(56, 1);
    private static final int DEFAULT_CACHE_CHUNK_SIZE = 1000000;
    private static final int COLLISION_ENTRY_SIZE = 11;
    private static final long GAP_VALUE = 0L;
    private final Factory<Radix> radixFactory;
    private final NumberArrayFactory cacheFactory;
    private final TrackerFactory trackerFactory;
    private final LongArray dataCache;
    private final GroupCache groupCache;
    private final HighestId candidateHighestSetIndex = new HighestId(-1L);
    private long highestSetIndex;
    private Tracker trackerCache;
    private final Encoder encoder;
    private final Radix radix;
    private final int processorsForParallelWork;
    private final MemoryTracker memoryTracker;
    private final ParallelSort.Comparator comparator;
    private ByteArray collisionNodeIdCache;
    private Tracker collisionTrackerCache;
    private boolean readyForUse;
    private long[][] sortBuckets;
    private final Monitor monitor;
    private final ReadableGroups groups;
    private long numberOfCollisions;
    private final LongFunction<CollisionValues> collisionValuesFactory;
    private CollisionValues collisionValues;
    private final PageCacheTracer pageCacheTracer;

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Factory<Radix> radixFactory, Monitor monitor, TrackerFactory trackerFactory, ReadableGroups groups, LongFunction<CollisionValues> collisionValuesFactory, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this(cacheFactory, encoder, radixFactory, monitor, trackerFactory, groups, collisionValuesFactory, 1000000, Runtime.getRuntime().availableProcessors() - 1, ParallelSort.DEFAULT, pageCacheTracer, memoryTracker);
    }

    EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Factory<Radix> radixFactory, Monitor monitor, TrackerFactory trackerFactory, ReadableGroups groups, LongFunction<CollisionValues> collisionValuesFactory, int chunkSize, int processorsForParallelWork, ParallelSort.Comparator comparator, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.radixFactory = radixFactory;
        this.monitor = monitor;
        this.cacheFactory = cacheFactory;
        this.trackerFactory = trackerFactory;
        this.collisionValuesFactory = collisionValuesFactory;
        this.comparator = comparator;
        this.processorsForParallelWork = Math.max(processorsForParallelWork, 1);
        this.memoryTracker = memoryTracker;
        this.dataCache = cacheFactory.newDynamicLongArray(chunkSize, 0L, memoryTracker);
        this.groupCache = GroupCache.select(cacheFactory, chunkSize, groups.size(), memoryTracker);
        this.groups = groups;
        this.encoder = encoder;
        this.radix = (Radix)radixFactory.newInstance();
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    public long get(Object inputId, Group group) {
        assert (this.readyForUse);
        return this.binarySearch(inputId, group.id());
    }

    @Override
    public void put(Object inputId, long nodeId, Group group) {
        long eId = this.encode(inputId);
        this.dataCache.set(nodeId, eId);
        this.groupCache.set(nodeId, group.id());
        this.candidateHighestSetIndex.offer(nodeId);
    }

    private long encode(Object inputId) {
        long eId = this.encoder.encode(inputId);
        if (eId == 0L) {
            throw new IllegalStateException("Encoder " + this.encoder + " returned an illegal encoded value 0");
        }
        return eId;
    }

    @Override
    public boolean needsPreparation() {
        return true;
    }

    @Override
    public void prepare(PropertyValueLookup inputIdLookup, Collector collector, ProgressListener progress) {
        this.highestSetIndex = this.candidateHighestSetIndex.get();
        EncodingIdMapper.updateRadix(this.dataCache, this.radix, this.highestSetIndex);
        this.trackerCache = this.trackerFactory.create(this.cacheFactory, this.highestSetIndex + 1L);
        try {
            this.sortBuckets = new ParallelSort(this.radix, this.dataCache, this.highestSetIndex, this.trackerCache, this.processorsForParallelWork, progress, this.comparator).run();
            long pessimisticNumberOfCollisions = this.detectAndMarkCollisions(progress);
            if (pessimisticNumberOfCollisions > 0L) {
                this.buildCollisionInfo(inputIdLookup, pessimisticNumberOfCollisions, collector, progress);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException("Got interrupted while preparing the index. Throwing this exception onwards will cause a chain reaction which will cause a panic in the whole import, so mission accomplished");
        }
        this.readyForUse = true;
    }

    private static void updateRadix(LongArray values, Radix radix, long highestSetIndex) {
        for (long dataIndex = 0L; dataIndex <= highestSetIndex; ++dataIndex) {
            radix.registerRadixOf(values.get(dataIndex));
        }
    }

    private int radixOf(long value) {
        return this.radix.calculator().radixOf(value);
    }

    private long binarySearch(Object inputId, int groupId) {
        long returnVal;
        long low = 0L;
        long high = this.highestSetIndex;
        long x = this.encode(inputId);
        int rIndex = this.radixOf(x);
        for (int k = 0; k < this.sortBuckets.length; ++k) {
            if ((long)rIndex > this.sortBuckets[k][0]) continue;
            low = this.sortBuckets[k][1];
            high = k == this.sortBuckets.length - 1 ? this.highestSetIndex : this.sortBuckets[k + 1][1];
            break;
        }
        if ((returnVal = this.binarySearch(x, inputId, low, high, groupId)) == -1L) {
            low = 0L;
            high = this.highestSetIndex;
            returnVal = this.binarySearch(x, inputId, low, high, groupId);
        }
        return returnVal;
    }

    private static long setCollision(long eId) {
        return COLLISION_BIT.set(eId, 1, 1L);
    }

    static long clearCollision(long eId) {
        return COLLISION_BIT.clear(eId, 1, false);
    }

    private static boolean isCollision(long eId) {
        return COLLISION_BIT.get(eId, 1) != 0L;
    }

    private long detectAndMarkCollisions(ProgressListener progress) {
        progress.started("DETECT");
        long totalCount = this.highestSetIndex + 1L;
        Workers<DetectWorker> workers = new Workers<DetectWorker>("DETECT");
        int processors = this.processorsForParallelWork;
        long stride = totalCount / (long)this.processorsForParallelWork;
        if (stride < 10L) {
            processors = 1;
            stride = totalCount;
        }
        long toExclusive = 0L;
        for (int i = 0; i < processors; ++i) {
            boolean last = i == processors - 1;
            long fromInclusive = toExclusive;
            toExclusive = last ? totalCount : toExclusive + stride;
            workers.start(new DetectWorker(fromInclusive, toExclusive, last, progress));
        }
        workers.awaitAndThrowOnErrorStrict();
        long numberOfCollisions = 0L;
        for (DetectWorker detectWorker : workers) {
            numberOfCollisions += (long)detectWorker.numberOfCollisions;
        }
        progress.done();
        if (numberOfCollisions > Integer.MAX_VALUE) {
            throw new InputException("Too many collisions: " + numberOfCollisions);
        }
        int intNumberOfCollisions = Math.toIntExact(numberOfCollisions);
        this.monitor.numberOfCollisions(intNumberOfCollisions);
        return intNumberOfCollisions;
    }

    private boolean markAsCollision(long nodeId) {
        long eId = this.dataCache.get(nodeId);
        boolean isAlreadyMarked = EncodingIdMapper.isCollision(eId);
        if (isAlreadyMarked) {
            return false;
        }
        this.dataCache.set(nodeId, EncodingIdMapper.setCollision(eId));
        return true;
    }

    private void unmarkAsCollision(long dataIndex) {
        long eId = this.dataCache.get(dataIndex);
        boolean isMarked = EncodingIdMapper.isCollision(eId);
        if (isMarked) {
            this.dataCache.set(dataIndex, EncodingIdMapper.clearCollision(eId));
        }
    }

    private void buildCollisionInfo(PropertyValueLookup inputIdLookup, long pessimisticNumberOfCollisions, Collector collector, ProgressListener progress) throws InterruptedException {
        progress.started("RESOLVE (~" + pessimisticNumberOfCollisions + " collisions)");
        Radix radix = (Radix)this.radixFactory.newInstance();
        this.collisionNodeIdCache = this.cacheFactory.newByteArray(pessimisticNumberOfCollisions, new byte[11], this.memoryTracker);
        this.collisionTrackerCache = this.trackerFactory.create(this.cacheFactory, pessimisticNumberOfCollisions);
        this.collisionValues = this.collisionValuesFactory.apply(pessimisticNumberOfCollisions);
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(IMPORT_COLLISION_INFO_TAG));){
            for (long nodeId = 0L; nodeId <= this.highestSetIndex; ++nodeId) {
                long eId = this.dataCache.get(nodeId);
                if (EncodingIdMapper.isCollision(eId)) {
                    long collisionIndex;
                    ++this.numberOfCollisions;
                    Object id = inputIdLookup.lookupProperty(nodeId, cursorContext);
                    long eIdFromInputId = this.encode(id);
                    long eIdWithoutCollisionBit = EncodingIdMapper.clearCollision(eId);
                    assert (eIdFromInputId == eIdWithoutCollisionBit) : String.format("Encoding mismatch during building of collision info. input id %s (a %s) marked as collision where this id was encoded into %d when put, but was now encoded into %d", id, id.getClass().getSimpleName(), eIdWithoutCollisionBit, eIdFromInputId);
                    long offset = this.collisionValues.add(id);
                    this.collisionNodeIdCache.set5ByteLong(collisionIndex, 0, nodeId);
                    this.collisionNodeIdCache.set6ByteLong(collisionIndex, 5, offset);
                    radix.registerRadixOf(eIdWithoutCollisionBit);
                }
                progress.add(1L);
            }
        }
        progress.done();
        this.detectDuplicateInputIds(radix, collector, progress);
        this.collisionTrackerCache.close();
        this.collisionTrackerCache = null;
    }

    private void detectDuplicateInputIds(Radix radix, Collector collector, ProgressListener progress) throws InterruptedException {
        ParallelSort.Comparator duplicateComparator = new ParallelSort.Comparator(){

            @Override
            public boolean lt(long left, long pivot) {
                long pivotEId;
                long leftEId = EncodingIdMapper.this.dataCache.get(left);
                if (EncodingIdMapper.this.comparator.lt(leftEId, pivotEId = EncodingIdMapper.this.dataCache.get(pivot))) {
                    return true;
                }
                if (leftEId == pivotEId) {
                    return left < pivot;
                }
                return false;
            }

            @Override
            public boolean ge(long right, long pivot) {
                long pivotEId;
                long rightEId = EncodingIdMapper.this.dataCache.get(right);
                if (EncodingIdMapper.this.comparator.ge(rightEId, pivotEId = EncodingIdMapper.this.dataCache.get(pivot))) {
                    return rightEId != pivotEId || right > pivot;
                }
                return false;
            }

            @Override
            public long dataValue(long nodeId) {
                return EncodingIdMapper.this.dataCache.get(nodeId);
            }
        };
        new ParallelSort(radix, EncodingIdMapper.as5ByteLongArray(this.collisionNodeIdCache), this.numberOfCollisions - 1L, this.collisionTrackerCache, this.processorsForParallelWork, progress, duplicateComparator).run();
        long previousEid = 0L;
        int previousGroupId = -1;
        SameInputIdDetector detector = new SameInputIdDetector();
        progress.started("DEDUPLICATE");
        int i = 0;
        while ((long)i < this.numberOfCollisions) {
            Object inputId;
            long nonDuplicateNodeId;
            boolean same;
            long collisionIndex = this.collisionTrackerCache.get(i);
            long nodeId = this.collisionNodeIdCache.get5ByteLong(collisionIndex, 0);
            long offset = this.collisionNodeIdCache.get6ByteLong(collisionIndex, 5);
            long eid = this.dataCache.get(nodeId);
            int groupId = this.groupOf(nodeId);
            boolean bl = same = eid == previousEid && previousGroupId == groupId;
            if (!same) {
                detector.clear();
            }
            if ((nonDuplicateNodeId = detector.add(nodeId, inputId = this.collisionValues.get(offset))) != -1L) {
                collector.collectDuplicateNode(inputId, nodeId, this.groups.get(groupId).name());
                this.trackerCache.markAsDuplicate(nodeId);
                this.unmarkAsCollision(nonDuplicateNodeId);
            }
            previousEid = eid;
            previousGroupId = groupId;
            progress.add(1L);
            ++i;
        }
        progress.done();
    }

    private static LongArray as5ByteLongArray(final ByteArray byteArray) {
        return new LongArray(){

            @Override
            public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
                byteArray.acceptMemoryStatsVisitor(visitor);
            }

            @Override
            public long length() {
                return byteArray.length();
            }

            @Override
            public void close() {
                byteArray.close();
            }

            @Override
            public void clear() {
                byteArray.clear();
            }

            @Override
            public LongArray at(long index) {
                return null;
            }

            @Override
            public void set(long index, long value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long get(long index) {
                return byteArray.get5ByteLong(index, 0);
            }
        };
    }

    private int groupOf(long dataIndex) {
        return this.groupCache.get(dataIndex);
    }

    private long binarySearch(long x, Object inputId, long low, long high, int groupId) {
        block4: while (low <= high) {
            long mid = low + (high - low) / 2L;
            long dataIndex = this.trackerCache.get(mid);
            if (dataIndex == -1L) {
                return -1L;
            }
            long midValue = this.dataCache.get(dataIndex);
            switch (Utils.unsignedDifference(EncodingIdMapper.clearCollision(midValue), x)) {
                case EQ: {
                    boolean rightEq;
                    boolean leftEq = mid > 0L && Utils.unsignedCompare(x, this.dataValue(mid - 1L), Utils.CompareType.EQ);
                    boolean bl = rightEq = mid < this.highestSetIndex && Utils.unsignedCompare(x, this.dataValue(mid + 1L), Utils.CompareType.EQ);
                    if (leftEq || rightEq) {
                        return this.findFromEIdRange(leftEq ? mid - 1L : mid, rightEq ? mid + 1L : mid, midValue, inputId, x, groupId);
                    }
                    return this.groupOf(dataIndex) == groupId ? dataIndex : -1L;
                }
                case LT: {
                    low = mid + 1L;
                    continue block4;
                }
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long dataValue(long index) {
        return EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index)));
    }

    private long findCollisionIndex(long value) {
        long low = 0L;
        long high = this.numberOfCollisions - 1L;
        block4: while (low <= high) {
            long mid = (low + high) / 2L;
            long midValue = this.collisionNodeIdCache.get5ByteLong(mid, 0);
            switch (Utils.unsignedDifference(midValue, value)) {
                case EQ: {
                    return mid;
                }
                case LT: {
                    low = mid + 1L;
                    continue block4;
                }
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long findFromEIdRange(long fromIndex, long toIndex, long val, Object inputId, long x, int groupId) {
        val = EncodingIdMapper.clearCollision(val);
        assert (val == x);
        while (fromIndex > 0L && Utils.unsignedCompare(val, this.dataValue(fromIndex - 1L), Utils.CompareType.EQ)) {
            --fromIndex;
        }
        while (toIndex < this.highestSetIndex && Utils.unsignedCompare(val, this.dataValue(toIndex + 1L), Utils.CompareType.EQ)) {
            ++toIndex;
        }
        return this.findFromEIdRange(fromIndex, toIndex, groupId, inputId);
    }

    private long findFromEIdRange(long fromIndex, long toIndex, int groupId, Object inputId) {
        long lowestFound = -1L;
        for (long index = fromIndex; index <= toIndex; ++index) {
            long nodeId = this.trackerCache.get(index);
            int group = this.groupOf(nodeId);
            if (groupId != group) continue;
            long eId = this.dataCache.get(nodeId);
            if (EncodingIdMapper.isCollision(eId)) {
                long collisionIndex;
                long offset;
                Object value;
                if (this.trackerCache.isMarkedAsDuplicate(nodeId) || !inputId.equals(value = this.collisionValues.get(offset = this.collisionNodeIdCache.get6ByteLong(collisionIndex = this.findCollisionIndex(nodeId), 5)))) continue;
                lowestFound = lowestFound == -1L ? nodeId : Math.min(lowestFound, nodeId);
                continue;
            }
            lowestFound = nodeId;
            break;
        }
        return lowestFound;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        EncodingIdMapper.nullSafeAcceptMemoryStatsVisitor(visitor, this.dataCache);
        EncodingIdMapper.nullSafeAcceptMemoryStatsVisitor(visitor, this.trackerCache);
        EncodingIdMapper.nullSafeAcceptMemoryStatsVisitor(visitor, this.collisionTrackerCache);
        EncodingIdMapper.nullSafeAcceptMemoryStatsVisitor(visitor, this.collisionNodeIdCache);
        EncodingIdMapper.nullSafeAcceptMemoryStatsVisitor(visitor, this.collisionValues);
    }

    private static void nullSafeAcceptMemoryStatsVisitor(MemoryStatsVisitor visitor, MemoryStatsVisitor.Visitable mem) {
        if (mem != null) {
            mem.acceptMemoryStatsVisitor(visitor);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.encoder + "," + this.radix + "]";
    }

    @Override
    public void close() {
        this.dataCache.close();
        this.groupCache.close();
        if (this.trackerCache != null) {
            this.trackerCache.close();
        }
        if (this.collisionNodeIdCache != null) {
            this.collisionNodeIdCache.close();
        }
        if (this.collisionValues != null) {
            this.collisionValues.close();
        }
    }

    @Override
    public MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
        return visitor -> {
            int trackerSize = numberOfNodes > Integer.MAX_VALUE ? 5 : 4;
            visitor.offHeapUsage(numberOfNodes * (long)(8 + trackerSize));
        };
    }

    @Override
    public LongIterator leftOverDuplicateNodesIds() {
        if (this.numberOfCollisions == 0L) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
        return new PrimitiveLongCollections.AbstractPrimitiveLongBaseIterator(){
            private long nodeId;

            protected boolean fetchNext() {
                while (this.nodeId <= EncodingIdMapper.this.highestSetIndex) {
                    long candidate;
                    ++this.nodeId;
                    if (!EncodingIdMapper.this.trackerCache.isMarkedAsDuplicate(candidate)) continue;
                    return this.next(candidate);
                }
                return false;
            }
        };
    }

    private static class SameInputIdDetector {
        private long[] nodeIdArray = new long[10];
        private Object[] inputIdArray = new Object[10];
        private int cursor;

        private SameInputIdDetector() {
        }

        long add(long nodeId, Object inputId) {
            for (int i = 0; i < this.cursor; ++i) {
                if (!this.inputIdArray[i].equals(inputId)) continue;
                return this.nodeIdArray[i];
            }
            if (this.cursor == this.inputIdArray.length) {
                this.inputIdArray = Arrays.copyOf(this.inputIdArray, this.cursor * 2);
                this.nodeIdArray = Arrays.copyOf(this.nodeIdArray, this.cursor * 2);
            }
            this.inputIdArray[this.cursor] = inputId;
            this.nodeIdArray[this.cursor] = nodeId;
            ++this.cursor;
            return -1L;
        }

        void clear() {
            this.cursor = 0;
        }
    }

    private class DetectWorker
    implements Runnable {
        private final long fromInclusive;
        private final long toExclusive;
        private final boolean last;
        private final ProgressListener progress;
        private int numberOfCollisions;
        private int localProgress;

        DetectWorker(long fromInclusive, long toExclusive, boolean last, ProgressListener progress) {
            this.fromInclusive = fromInclusive;
            this.toExclusive = toExclusive;
            this.last = last;
            this.progress = progress;
        }

        @Override
        public void run() {
            SameGroupDetector sameGroupDetector = new SameGroupDetector();
            long end = this.last ? this.toExclusive - 1L : this.toExclusive;
            for (long i = this.fromInclusive; i < end; ++i) {
                this.detect(sameGroupDetector, i);
                if (++this.localProgress != 1000) continue;
                this.progress.add((long)this.localProgress);
                this.localProgress = 0;
            }
            this.progress.add((long)this.localProgress);
        }

        private void detect(SameGroupDetector sameGroupDetector, long i) {
            long dataIndexA = EncodingIdMapper.this.trackerCache.get(i);
            long dataIndexB = EncodingIdMapper.this.trackerCache.get(i + 1L);
            if (dataIndexA == -1L || dataIndexB == -1L) {
                sameGroupDetector.reset();
                return;
            }
            long eIdA = EncodingIdMapper.clearCollision(EncodingIdMapper.this.dataCache.get(dataIndexA));
            long eIdB = EncodingIdMapper.clearCollision(EncodingIdMapper.this.dataCache.get(dataIndexB));
            if (eIdA == 0L || eIdB == 0L) {
                sameGroupDetector.reset();
                return;
            }
            switch (Utils.unsignedDifference(eIdA, eIdB)) {
                case GT: {
                    throw new IllegalStateException("Unsorted data, a > b Failure:[" + i + "] " + Long.toHexString(eIdA) + " > " + Long.toHexString(eIdB) + " | " + EncodingIdMapper.this.radixOf(eIdA) + ":" + EncodingIdMapper.this.radixOf(eIdB));
                }
                case EQ: {
                    long collision = sameGroupDetector.collisionWithinSameGroup(dataIndexA, EncodingIdMapper.this.groupOf(dataIndexA), dataIndexB, EncodingIdMapper.this.groupOf(dataIndexB));
                    if (dataIndexA > dataIndexB) {
                        EncodingIdMapper.this.trackerCache.swap(i, i + 1L);
                    }
                    if (collision == -1L) break;
                    if (EncodingIdMapper.this.markAsCollision(collision)) {
                        ++this.numberOfCollisions;
                    }
                    if (!EncodingIdMapper.this.markAsCollision(dataIndexB)) break;
                    ++this.numberOfCollisions;
                    break;
                }
                default: {
                    sameGroupDetector.reset();
                }
            }
        }
    }

    public static interface Monitor {
        public void numberOfCollisions(long var1);
    }
}

