/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongBitsManipulator;
import org.neo4j.internal.batchimport.cache.idmapping.string.AbstractTracker;

public class IntTracker
extends AbstractTracker<IntArray> {
    static final int SIZE = 4;
    static final int ID_BITS = 31;
    static final long MAX_ID = Integer.MAX_VALUE;
    static final int DEFAULT_VALUE = -1;
    private static final LongBitsManipulator BITS = new LongBitsManipulator(31, 1);

    public IntTracker(IntArray array) {
        super(array);
    }

    @Override
    public long get(long index) {
        return BITS.get(((IntArray)this.array).get(index), 0);
    }

    @Override
    public void set(long index, long value) {
        long field = ((IntArray)this.array).get(index);
        field = BITS.set(field, 0, value);
        ((IntArray)this.array).set(index, (int)field);
    }

    @Override
    public void markAsDuplicate(long index) {
        long field = ((IntArray)this.array).get(index);
        field = BITS.set(field, 1, 0L);
        ((IntArray)this.array).set(index, (int)field);
    }

    @Override
    public boolean isMarkedAsDuplicate(long index) {
        long field = ((IntArray)this.array).get(index);
        return BITS.get(field, 1) == 0L;
    }
}

