/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.ProgressReporter;
import org.neo4j.internal.batchimport.Configuration;

public interface RecordIdIterator {
    public LongIterator nextBatch();

    public static RecordIdIterator backwards(long lowIncluded, long highExcluded, Configuration config) {
        return new Backwards(lowIncluded, highExcluded, config);
    }

    public static RecordIdIterator forwards(long lowIncluded, long highExcluded, Configuration config) {
        return new Forwards(lowIncluded, highExcluded, config);
    }

    public static RecordIdIterator withProgress(RecordIdIterator iterator, final ProgressReporter reporter) {
        return () -> {
            final LongIterator actual = iterator.nextBatch();
            if (actual == null) {
                return null;
            }
            return new LongIterator(){

                public long next() {
                    reporter.progress(1L);
                    return actual.next();
                }

                public boolean hasNext() {
                    return actual.hasNext();
                }
            };
        };
    }

    public static class Backwards
    implements RecordIdIterator {
        private final long lowIncluded;
        private final long highExcluded;
        private final int batchSize;
        private long endId;

        public Backwards(long lowIncluded, long highExcluded, Configuration config) {
            this.lowIncluded = lowIncluded;
            this.highExcluded = highExcluded;
            this.batchSize = config.batchSize();
            this.endId = highExcluded;
        }

        @Override
        public LongIterator nextBatch() {
            if (this.endId <= this.lowIncluded) {
                return null;
            }
            long startId = this.findFloorId(this.endId);
            LongIterator result = PrimitiveLongCollections.range((long)startId, (long)(this.endId - 1L));
            this.endId = Long.max(this.lowIncluded, startId);
            return result;
        }

        private long findFloorId(long roofId) {
            int rest = (int)(roofId % (long)this.batchSize);
            return Long.max(rest == 0 ? roofId - (long)this.batchSize : roofId - (long)rest, this.lowIncluded);
        }

        public String toString() {
            return "]" + this.highExcluded + "-" + this.lowIncluded + "]";
        }
    }

    public static class Forwards
    implements RecordIdIterator {
        private final long lowIncluded;
        private final long highExcluded;
        private final int batchSize;
        private long startId;

        public Forwards(long lowIncluded, long highExcluded, Configuration config) {
            this.lowIncluded = lowIncluded;
            this.highExcluded = highExcluded;
            this.batchSize = config.batchSize();
            this.startId = lowIncluded;
        }

        @Override
        public LongIterator nextBatch() {
            if (this.startId >= this.highExcluded) {
                return null;
            }
            long endId = Long.min(this.highExcluded, this.findRoofId(this.startId));
            LongIterator result = PrimitiveLongCollections.range((long)this.startId, (long)(endId - 1L));
            this.startId = endId;
            return result;
        }

        private long findRoofId(long floorId) {
            int rest = (int)(floorId % (long)this.batchSize);
            return Long.max(rest == 0 ? floorId + (long)this.batchSize : floorId + (long)this.batchSize - (long)rest, this.lowIncluded);
        }

        public String toString() {
            return "[" + this.lowIncluded + "-" + this.highExcluded + "[";
        }
    }
}

