/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.concurrent.atomic.AtomicLong;

public class HighestId {
    private final AtomicLong highestId;

    public HighestId() {
        this(0L);
    }

    public HighestId(long initialId) {
        this.highestId = new AtomicLong(initialId);
    }

    public void offer(long candidate) {
        long currentHighest;
        do {
            if (candidate > (currentHighest = this.highestId.get())) continue;
            return;
        } while (!this.highestId.compareAndSet(currentHighest, candidate));
    }

    public long get() {
        return this.highestId.get();
    }
}

