/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.AbstractStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;

public abstract class LonelyProcessingStep
extends AbstractStep<Void> {
    private final int batchSize;
    private int batch;
    private long lastProcessingTimestamp;

    public LonelyProcessingStep(StageControl control, String name, Configuration config, StatsProvider ... additionalStatsProviders) {
        super(control, name, config, additionalStatsProviders);
        this.batchSize = config.batchSize();
    }

    @Override
    public long receive(long ticket, Void nothing) {
        this.control.scheduler().schedule(() -> {
            this.assertHealthy();
            try {
                try {
                    this.lastProcessingTimestamp = System.nanoTime();
                    this.process();
                    this.endOfUpstream();
                }
                catch (Throwable e) {
                    this.issuePanic(e);
                }
            }
            catch (Throwable e) {
                if (!this.isPanic()) {
                    this.issuePanic(e);
                }
                throw e;
            }
        }, this.name());
        return 0L;
    }

    protected abstract void process();

    protected void progress(long amount) {
        this.batch = (int)((long)this.batch + amount);
        if (this.batch >= this.batchSize) {
            int batches = this.batch / this.batchSize;
            this.batch %= this.batchSize;
            this.doneBatches.addAndGet(batches);
            long time = System.nanoTime();
            this.totalProcessingTime.add(time - this.lastProcessingTimestamp);
            this.lastProcessingTimestamp = time;
        }
    }
}

