/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.common.EntityType;
import org.neo4j.internal.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.util.concurrent.AsyncEvent;
import org.neo4j.util.concurrent.AsyncEvents;

public final class BadCollector
implements Collector {
    public static final String BAD_FILE_NAME = "bad.log";
    static final Monitor NO_MONITOR = new Monitor(){};
    static final int BAD_RELATIONSHIPS = 1;
    static final int DUPLICATE_NODES = 2;
    static final int EXTRA_COLUMNS = 4;
    static final int VIOLATING_NODES = 8;
    static final int COLLECT_ALL = 7;
    public static final long UNLIMITED_TOLERANCE = -1L;
    static final int DEFAULT_BACK_PRESSURE_THRESHOLD = 10000;
    private final PrintStream out;
    private final long tolerance;
    private final int collect;
    private final int backPressureThreshold;
    private final boolean logBadEntries;
    private final Monitor monitor;
    private final AtomicLong badEntries = new AtomicLong();
    private final AsyncEvents<ProblemReporter> logger;
    private final Thread eventProcessor;
    private final AtomicLong queueSize = new AtomicLong();

    public BadCollector(OutputStream out, long tolerance, int collect) {
        this(out, tolerance, collect, 10000, false, NO_MONITOR);
    }

    BadCollector(OutputStream out, long tolerance, int collect, int backPressureThreshold, boolean skipBadEntriesLogging, Monitor monitor) {
        this.out = new PrintStream(out);
        this.tolerance = tolerance;
        this.collect = collect;
        this.backPressureThreshold = backPressureThreshold;
        this.logBadEntries = !skipBadEntriesLogging;
        this.monitor = monitor;
        this.logger = new AsyncEvents(this::processEvent, AsyncEvents.Monitor.NONE);
        this.eventProcessor = new Thread((Runnable)this.logger);
        this.eventProcessor.start();
    }

    private void processEvent(ProblemReporter report) {
        this.monitor.beforeProcessEvent();
        this.out.println(report.message());
        this.queueSize.addAndGet(-1L);
    }

    public void collectBadRelationship(Object startId, Group startIdGroup, Object type, Object endId, Group endIdGroup, Object specificValue) {
        this.collect(new RelationshipsProblemReporter(startId, startIdGroup, type, endId, endIdGroup, specificValue));
    }

    public void collectExtraColumns(String source, long row, String value) {
        this.collect(new ExtraColumnsProblemReporter(row, source, value));
    }

    public void collectDuplicateNode(Object id, long actualId, Group group) {
        this.collect(new NodesProblemReporter(id, group));
    }

    public void collectEntityViolatingConstraint(Object id, long actualId, Map<String, Object> properties, String constraintDescription, EntityType entityType) {
        this.collect(new EntityViolatingConstraintReporter(id, actualId, properties, constraintDescription, entityType));
    }

    public void collectRelationshipViolatingConstraint(Map<String, Object> properties, String constraintDescription, Object startId, Group startIdGroup, String type, Object endId, Group endIdGroup) {
        this.collect(new RelationshipViolatingConstraintReporter(properties, constraintDescription, startId, startIdGroup, type, endId, endIdGroup));
    }

    public boolean isCollectingBadRelationships() {
        return this.collects(1);
    }

    private void collect(ProblemReporter report) {
        boolean collect = this.collects(report.type());
        if (collect) {
            long count = this.badEntries.incrementAndGet();
            if (this.tolerance == -1L || count <= this.tolerance) {
                if (this.logBadEntries) {
                    while (this.queueSize.get() >= (long)this.backPressureThreshold) {
                        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                    }
                    this.logger.send((AsyncEvent)report);
                    this.queueSize.addAndGet(1L);
                }
                return;
            }
        }
        InputException exception = report.exception();
        throw collect ? new InputException(String.format("Too many bad entries %d, where last one was: %s", this.badEntries.longValue(), exception.getMessage()), exception) : exception;
    }

    public void close() {
        this.logger.shutdown();
        try {
            this.logger.awaitTermination();
            this.eventProcessor.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.out.flush();
            this.out.close();
        }
    }

    public long badEntries() {
        return this.badEntries.get();
    }

    private boolean collects(int bit) {
        return (this.collect & bit) != 0;
    }

    static interface Monitor {
        default public void beforeProcessEvent() {
        }
    }

    static abstract class ProblemReporter
    extends AsyncEvent {
        private final int type;

        ProblemReporter(int type) {
            this.type = type;
        }

        int type() {
            return this.type;
        }

        abstract String message();

        abstract InputException exception();
    }

    private static class RelationshipsProblemReporter
    extends ProblemReporter {
        private String message;
        private final Object specificValue;
        private final Object startId;
        private final Group startIdGroup;
        private final Object type;
        private final Object endId;
        private final Group endIdGroup;

        RelationshipsProblemReporter(Object startId, Group startIdGroup, Object type, Object endId, Group endIdGroup, Object specificValue) {
            super(1);
            this.startId = startId;
            this.startIdGroup = startIdGroup;
            this.type = type;
            this.endId = endId;
            this.endIdGroup = endIdGroup;
            this.specificValue = specificValue;
        }

        @Override
        public String message() {
            return this.getReportMessage();
        }

        @Override
        public InputException exception() {
            return new InputException(this.getReportMessage());
        }

        private String getReportMessage() {
            if (this.message == null) {
                this.message = !this.isMissingData() ? String.format("%s (%s)-[%s]->%s (%s) referring to missing node %s", this.startId, this.startIdGroup, this.type, this.endId, this.endIdGroup, this.specificValue) : String.format("%s (%s)-[%s]->%s (%s) is missing data", this.startId, this.startIdGroup, this.type, this.endId, this.endIdGroup);
            }
            return this.message;
        }

        private boolean isMissingData() {
            return this.startId == null || this.endId == null || this.type == null;
        }
    }

    private static class ExtraColumnsProblemReporter
    extends ProblemReporter {
        private String message;
        private final long row;
        private final String source;
        private final String value;

        ExtraColumnsProblemReporter(long row, String source, String value) {
            super(4);
            this.row = row;
            this.source = source;
            this.value = value;
        }

        @Override
        public String message() {
            return this.getReportMessage();
        }

        @Override
        public InputException exception() {
            return new InputException(this.getReportMessage());
        }

        private String getReportMessage() {
            if (this.message == null) {
                this.message = String.format("Extra column not present in header on line %d in %s with value %s", this.row, this.source, this.value);
            }
            return this.message;
        }
    }

    private static class NodesProblemReporter
    extends ProblemReporter {
        private final Object id;
        private final Group group;

        NodesProblemReporter(Object id, Group group) {
            super(2);
            this.id = id;
            this.group = group;
        }

        @Override
        public String message() {
            return DuplicateInputIdException.message(this.id, this.group);
        }

        @Override
        public InputException exception() {
            return new DuplicateInputIdException(this.id, this.group);
        }
    }

    private static class EntityViolatingConstraintReporter
    extends ProblemReporter {
        private final Object id;
        private final long actualId;
        private final Map<String, Object> properties;
        private final String constraintDescription;
        private final EntityType entityType;

        EntityViolatingConstraintReporter(Object id, long actualId, Map<String, Object> properties, String constraintDescription, EntityType entityType) {
            super(entityType == EntityType.NODE ? 8 : 1);
            this.id = id;
            this.actualId = actualId;
            this.properties = properties;
            this.constraintDescription = constraintDescription;
            this.entityType = entityType;
        }

        @Override
        String message() {
            return String.format("%s %s (internal id %d) would have violated constraint:%s with properties:%s", this.entityType == EntityType.NODE ? "Node" : "Relationship", this.id, this.actualId, this.constraintDescription, this.properties);
        }

        @Override
        InputException exception() {
            return new InputException(this.message());
        }
    }

    private static class RelationshipViolatingConstraintReporter
    extends ProblemReporter {
        private final Map<String, Object> properties;
        private final String constraintDescription;
        private final Object startId;
        private final Group startIdGroup;
        private final String type;
        private final Object endId;
        private final Group endIdGroup;

        RelationshipViolatingConstraintReporter(Map<String, Object> properties, String constraintDescription, Object startId, Group startIdGroup, String type, Object endId, Group endIdGroup) {
            super(1);
            this.properties = properties;
            this.constraintDescription = constraintDescription;
            this.startId = startId;
            this.startIdGroup = startIdGroup;
            this.type = type;
            this.endId = endId;
            this.endIdGroup = endIdGroup;
        }

        @Override
        String message() {
            return String.format("%s (%s)-[%s]->%s (%s) would have violated constraint:%s with properties:%s", this.startId, this.startIdGroup, this.type, this.endId, this.endIdGroup, this.constraintDescription, this.properties);
        }

        @Override
        InputException exception() {
            return new InputException(this.message());
        }
    }
}

