/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.OutputStream;
import java.util.function.Function;
import org.neo4j.internal.batchimport.input.BadCollector;
import org.neo4j.internal.batchimport.input.Collector;

public class Collectors {
    private Collectors() {
    }

    public static Collector silentBadCollector(long tolerance) {
        return Collectors.silentBadCollector(tolerance, 7);
    }

    public static Collector silentBadCollector(long tolerance, int collect) {
        return Collectors.badCollector(OutputStream.nullOutputStream(), tolerance, collect);
    }

    public static Collector badCollector(OutputStream out, long tolerance) {
        return Collectors.badCollector(out, tolerance, 7, false);
    }

    public static Collector badCollector(OutputStream out, long tolerance, int collect) {
        return new BadCollector(out, tolerance, collect, 10000, false, BadCollector.NO_MONITOR);
    }

    public static Collector badCollector(OutputStream out, long tolerance, int collect, boolean skipBadEntriesLogging) {
        return new BadCollector(out, tolerance, collect, 10000, skipBadEntriesLogging, BadCollector.NO_MONITOR);
    }

    public static Function<OutputStream, Collector> badCollector(int tolerance) {
        return Collectors.badCollector(tolerance, 7);
    }

    public static Function<OutputStream, Collector> badCollector(int tolerance, int collect) {
        return out -> Collectors.badCollector(out, tolerance, collect, false);
    }

    public static int collect(boolean skipBadRelationships, boolean skipDuplicateNodes, boolean ignoreExtraColumns) {
        return (skipBadRelationships ? 1 : 0) | (skipDuplicateNodes ? 2 : 0) | (ignoreExtraColumns ? 4 : 0);
    }
}

