/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.util.Arrays;
import org.neo4j.internal.batchimport.cache.HeapNumberArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class HeapLongArray
extends HeapNumberArray<LongArray>
implements LongArray {
    private final long[] array;
    private final long defaultValue;

    public HeapLongArray(int length, long defaultValue, long base, MemoryTracker memoryTracker) {
        super(8, base);
        this.defaultValue = defaultValue;
        this.array = new long[length];
        memoryTracker.allocateHeap(HeapEstimator.sizeOf((long[])this.array));
        this.clear();
    }

    @Override
    public long length() {
        return this.array.length;
    }

    @Override
    public long get(long index) {
        return this.array[this.index(index)];
    }

    @Override
    public void set(long index, long value) {
        this.array[this.index((long)index)] = value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, this.defaultValue);
    }
}

