/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.neo4j.batchimport.api.InputIterator;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.InputChunk;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetDataFactory;
import org.neo4j.internal.batchimport.input.parquet.ParquetInputChunk;
import org.neo4j.internal.batchimport.input.parquet.ParquetInputIterator;
import org.neo4j.internal.batchimport.input.parquet.ParquetMonitor;
import org.neo4j.internal.batchimport.input.parquet.ParquetProxyInputChunk;

class ParquetGroupInputIterator
implements InputIterator {
    private final ParquetDataFactory source;
    private final Groups groups;
    private final IdType idType;
    private final ParquetMonitor monitor;
    private final Map<Path, List<ParquetColumn>> columnInfo;
    private final String arrayDelimiter;
    private ParquetInputIterator current;

    ParquetGroupInputIterator(ParquetDataFactory source, Groups groups, IdType idType, String arrayDelimiter, Map<Path, List<ParquetColumn>> columnInfo, ParquetMonitor monitor) {
        this.monitor = monitor;
        this.source = source;
        this.groups = groups;
        this.idType = idType;
        this.arrayDelimiter = arrayDelimiter;
        this.columnInfo = columnInfo;
    }

    public InputChunk newChunk() {
        return new ParquetProxyInputChunk();
    }

    public synchronized boolean next(InputChunk chunk) throws IOException {
        while (true) {
            if (this.current == null) {
                if (!this.source.hasNextFile()) {
                    return false;
                }
                ParquetData data = this.source.getNextFile();
                this.current = new ParquetInputIterator(data, this.groups, this.idType, this.columnInfo, data.defaultTimezoneSupplier(), this.arrayDelimiter);
            }
            if (this.current.next((ParquetInputChunk)chunk)) {
                return true;
            }
            this.current.close();
            this.current = null;
        }
    }

    public void close() {
        if (this.current != null) {
            try {
                this.current.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

