/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TemporaryIncrementalImportInformation
implements Closeable {
    private final FileSystemAbstraction fs;
    private final Path file;
    private final List<Entry> entryList;
    private final Map<String, Entry> entryMap;
    private boolean dirty;

    public TemporaryIncrementalImportInformation(FileSystemAbstraction fs, Path file, Entry ... entries) throws IOException {
        this.fs = fs;
        this.file = file;
        this.entryList = List.of(entries);
        this.entryMap = this.entryList.stream().collect(Collectors.toMap(e -> e.key, e -> e));
        this.readState();
    }

    public <T> T get(String key) {
        Entry entry = this.entry(key);
        return (T)entry.value;
    }

    public void put(String key, Object value) {
        this.entry((String)key).value = value;
        this.dirty = true;
    }

    private Entry entry(String key) {
        Entry entry = this.entryMap.get(key);
        Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Unknown key %s", (Object[])new Object[]{key});
        return entry;
    }

    @Override
    public void close() throws IOException {
        this.write();
    }

    public void write() throws IOException {
        if (this.dirty) {
            try (DataOutputStream output = new DataOutputStream(this.fs.openAsOutputStream(this.file, false));){
                for (Entry entry : this.entryList) {
                    entry.type.write(output, entry.value);
                }
                this.dirty = false;
            }
        }
    }

    private void readState() throws IOException {
        try (DataInputStream input = new DataInputStream(this.fs.openAsInputStream(this.file));){
            for (Entry entry : this.entryList) {
                entry.value = entry.type.read(input);
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
    }

    private static LongSet readLongs(DataInputStream input) throws IOException {
        int size = input.readInt();
        if (size == -1) {
            return null;
        }
        MutableLongSet data = LongSets.mutable.empty();
        for (int i = 0; i < size; ++i) {
            data.add(input.readLong());
        }
        return data;
    }

    private static Map<String, Long> readStringLongMap(DataInputStream input) throws IOException {
        int size = input.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<String, Long> data = new HashMap<String, Long>();
        for (int i = 0; i < size; ++i) {
            String key = null;
            if (input.readBoolean()) {
                key = input.readUTF();
            }
            data.put(key, input.readLong());
        }
        return data;
    }

    private static Map<Long, Map<String, Value>> readLongValuesMap(DataInputStream input) throws IOException {
        int size = input.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<Long, Map<String, Value>> data = new HashMap<Long, Map<String, Value>>();
        for (int i = 0; i < size; ++i) {
            data.put(input.readLong(), TemporaryIncrementalImportInformation.readStringValueMap(input));
        }
        return data;
    }

    private static Map<String, Value> readStringValueMap(DataInputStream input) throws IOException {
        int size = input.readInt();
        HashMap<String, Value> data = new HashMap<String, Value>();
        for (int i = 0; i < size; ++i) {
            data.put(input.readUTF(), ((ValueType)TemporaryIncrementalImportInformation.readEnum((DataInputStream)input, (Enum[])ValueType.VALUES)).read(input));
        }
        return data;
    }

    @SafeVarargs
    private static <E extends Enum<E>> E readEnum(DataInputStream input, E ... options) throws IOException {
        byte option = input.readByte();
        if (option < 0 || option >= options.length) {
            throw new IOException("Invalid enum option: " + option);
        }
        return options[option];
    }

    private static void writeLongs(DataOutputStream output, LongSet data) throws IOException {
        if (TemporaryIncrementalImportInformation.writeStartContainer(output, TemporaryIncrementalImportInformation.size(data))) {
            LongIterator iterator = data.longIterator();
            while (iterator.hasNext()) {
                output.writeLong(iterator.next());
            }
        }
    }

    private static void writeStringLongMap(DataOutputStream output, Map<String, Long> data) throws IOException {
        if (TemporaryIncrementalImportInformation.writeStartContainer(output, TemporaryIncrementalImportInformation.size(data))) {
            for (Map.Entry<String, Long> entry : data.entrySet()) {
                String key = entry.getKey();
                output.writeBoolean(key != null);
                if (key != null) {
                    output.writeUTF(key);
                }
                output.writeLong(entry.getValue());
            }
        }
    }

    private static void writeLongValuesMap(DataOutputStream output, Map<Long, Map<String, Value>> data) throws IOException {
        if (TemporaryIncrementalImportInformation.writeStartContainer(output, TemporaryIncrementalImportInformation.size(data))) {
            for (Map.Entry<Long, Map<String, Value>> entry : data.entrySet()) {
                output.writeLong(entry.getKey());
                Map<String, Value> schemaData = entry.getValue();
                output.writeInt(schemaData.size());
                for (Map.Entry<String, Value> schemaEntry : schemaData.entrySet()) {
                    output.writeUTF(schemaEntry.getKey());
                    ValueType.write(output, schemaEntry.getValue());
                }
            }
        }
    }

    private static boolean writeStartContainer(DataOutputStream output, IntSupplier containerSize) throws IOException {
        if (containerSize == null) {
            output.writeInt(-1);
            return false;
        }
        output.writeInt(containerSize.getAsInt());
        return true;
    }

    private static IntSupplier size(LongSet data) {
        return data == null ? null : () -> ((LongSet)data).size();
    }

    private static IntSupplier size(Map<?, ?> data) {
        return data == null ? null : data::size;
    }

    public static class Entry {
        private final String key;
        private final EntryType type;
        private Object value;

        public Entry(String key, EntryType type) {
            this(key, type, type.defaultValue());
        }

        public Entry(String key, EntryType type, Object defaultValue) {
            this.key = key;
            this.type = type;
            this.value = defaultValue;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EntryType {
        INT{

            @Override
            void write(DataOutputStream output, Object value) throws IOException {
                output.writeInt((Integer)value);
            }

            @Override
            Object read(DataInputStream input) throws IOException {
                return input.readInt();
            }

            @Override
            Object defaultValue() {
                return 0;
            }
        }
        ,
        LONG{

            @Override
            void write(DataOutputStream output, Object value) throws IOException {
                output.writeLong((Long)value);
            }

            @Override
            Object read(DataInputStream input) throws IOException {
                return input.readLong();
            }

            @Override
            Object defaultValue() {
                return 0L;
            }
        }
        ,
        LONG_SET{

            @Override
            void write(DataOutputStream output, Object value) throws IOException {
                TemporaryIncrementalImportInformation.writeLongs(output, (LongSet)value);
            }

            @Override
            Object read(DataInputStream input) throws IOException {
                return TemporaryIncrementalImportInformation.readLongs(input);
            }

            @Override
            Object defaultValue() {
                return LongSets.immutable.empty();
            }
        }
        ,
        STRING_LONG_MAP{

            @Override
            void write(DataOutputStream output, Object value) throws IOException {
                TemporaryIncrementalImportInformation.writeStringLongMap(output, (Map)value);
            }

            @Override
            Object read(DataInputStream input) throws IOException {
                return TemporaryIncrementalImportInformation.readStringLongMap(input);
            }

            @Override
            Object defaultValue() {
                return Collections.emptyMap();
            }
        }
        ,
        LONG_VALUES_MAP{

            @Override
            void write(DataOutputStream output, Object value) throws IOException {
                TemporaryIncrementalImportInformation.writeLongValuesMap(output, (Map)value);
            }

            @Override
            Object read(DataInputStream input) throws IOException {
                return TemporaryIncrementalImportInformation.readLongValuesMap(input);
            }

            @Override
            Object defaultValue() {
                return Collections.emptyMap();
            }
        };


        abstract void write(DataOutputStream var1, Object var2) throws IOException;

        abstract Object read(DataInputStream var1) throws IOException;

        abstract Object defaultValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ValueType {
        BOOLEAN{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                output.writeBoolean(((BooleanValue)value).booleanValue());
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                return Values.booleanValue((boolean)input.readBoolean());
            }
        }
        ,
        BOOLEAN_ARRAY{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                BooleanArray typedData = (BooleanArray)value;
                output.writeInt(typedData.intSize());
                for (int i = 0; i < typedData.intSize(); ++i) {
                    output.writeBoolean(typedData.booleanValue(i));
                }
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                boolean[] array = new boolean[input.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = input.readBoolean();
                }
                return Values.booleanArray((boolean[])array);
            }
        }
        ,
        SHORT{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                output.writeShort(((ShortValue)value).value());
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                return Values.shortValue((short)input.readShort());
            }
        }
        ,
        SHORT_ARRAY{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                ShortArray typedData = (ShortArray)value;
                output.writeInt(typedData.intSize());
                for (int i = 0; i < typedData.intSize(); ++i) {
                    output.writeShort((short)typedData.longValue(i));
                }
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                short[] array = new short[input.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = input.readShort();
                }
                return Values.shortArray((short[])array);
            }
        }
        ,
        INT{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                output.writeInt(((IntValue)value).value());
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                return Values.intValue((int)input.readInt());
            }
        }
        ,
        INT_ARRAY{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                IntArray typedData = (IntArray)value;
                output.writeInt(typedData.intSize());
                for (int i = 0; i < typedData.intSize(); ++i) {
                    output.writeInt((int)typedData.longValue(i));
                }
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                int[] array = new int[input.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = input.readInt();
                }
                return Values.intArray((int[])array);
            }
        }
        ,
        LONG{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                output.writeLong(((LongValue)value).longValue());
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                return Values.longValue((long)input.readLong());
            }
        }
        ,
        LONG_ARRAY{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                LongArray typedData = (LongArray)value;
                output.writeInt(typedData.intSize());
                for (int i = 0; i < typedData.intSize(); ++i) {
                    output.writeLong(typedData.longValue(i));
                }
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                long[] array = new long[input.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = input.readLong();
                }
                return Values.longArray((long[])array);
            }
        }
        ,
        FLOAT{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                output.writeFloat(((FloatValue)value).value());
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                return Values.floatValue((float)input.readFloat());
            }
        }
        ,
        FLOAT_ARRAY{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                FloatArray typedData = (FloatArray)value;
                output.writeInt(typedData.intSize());
                for (int i = 0; i < typedData.intSize(); ++i) {
                    output.writeFloat((float)typedData.doubleValue(i));
                }
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                float[] array = new float[input.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = input.readFloat();
                }
                return Values.floatArray((float[])array);
            }
        }
        ,
        DOUBLE{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                output.writeDouble(((DoubleValue)value).doubleValue());
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                return Values.doubleValue((double)input.readDouble());
            }
        }
        ,
        DOUBLE_ARRAY{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                DoubleArray typedData = (DoubleArray)value;
                output.writeInt(typedData.intSize());
                for (int i = 0; i < typedData.intSize(); ++i) {
                    output.writeDouble(typedData.doubleValue(i));
                }
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                double[] array = new double[input.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = input.readDouble();
                }
                return Values.doubleArray((double[])array);
            }
        }
        ,
        TEXT{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                output.writeUTF(((TextValue)value).stringValue());
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                return Values.stringValue((String)input.readUTF());
            }
        }
        ,
        TEXT_ARRAY{

            @Override
            protected void writeValue(DataOutputStream output, Value value) throws IOException {
                TextArray typedData = (TextArray)value;
                output.writeInt(typedData.intSize());
                for (int i = 0; i < typedData.intSize(); ++i) {
                    output.writeUTF(typedData.stringValue(i));
                }
            }

            @Override
            Value read(DataInputStream input) throws IOException {
                String[] array = new String[input.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = input.readUTF();
                }
                return Values.stringArray((String[])array);
            }
        };

        private static final ValueType[] VALUES;

        private static void write(DataOutputStream output, Value value) throws IOException {
            ValueType type = null;
            if (value instanceof BooleanValue) {
                type = BOOLEAN;
            } else if (value instanceof ShortValue) {
                type = SHORT;
            } else if (value instanceof IntValue) {
                type = INT;
            } else if (value instanceof LongValue) {
                type = LONG;
            } else if (value instanceof FloatValue) {
                type = FLOAT;
            } else if (value instanceof DoubleValue) {
                type = DOUBLE;
            } else if (value instanceof TextValue) {
                type = TEXT;
            } else if (value instanceof BooleanArray) {
                type = BOOLEAN_ARRAY;
            } else if (value instanceof ShortArray) {
                type = SHORT_ARRAY;
            } else if (value instanceof IntArray) {
                type = INT_ARRAY;
            } else if (value instanceof LongArray) {
                type = LONG_ARRAY;
            } else if (value instanceof FloatArray) {
                type = FLOAT_ARRAY;
            } else if (value instanceof DoubleArray) {
                type = DOUBLE_ARRAY;
            } else if (value instanceof TextArray) {
                type = TEXT_ARRAY;
            }
            if (type == null) {
                throw new IOException("Invalid number type found for value: " + value);
            }
            output.writeByte(type.ordinal());
            type.writeValue(output, value);
        }

        abstract Value read(DataInputStream var1) throws IOException;

        protected abstract void writeValue(DataOutputStream var1, Value var2) throws IOException;

        static {
            VALUES = ValueType.values();
        }
    }
}

