/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.DynamicByteArray;
import org.neo4j.internal.batchimport.cache.DynamicIntArray;
import org.neo4j.internal.batchimport.cache.DynamicLongArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.memory.MemoryTracker;

public class ChunkedNumberArrayFactory
extends NumberArrayFactory.Adapter {
    static final int MAGIC_CHUNK_COUNT = 10;
    private final NumberArrayFactory delegate;

    ChunkedNumberArrayFactory(NumberArrayFactory.Monitor monitor, NumberArrayFactory ... delegateList) {
        this.delegate = new NumberArrayFactories.Auto(monitor, delegateList);
    }

    @Override
    public LongArray newLongArray(long length, long defaultValue, long base, MemoryTracker memoryTracker) {
        return this.newDynamicLongArray(ChunkedNumberArrayFactory.fractionOf(length), defaultValue, memoryTracker);
    }

    @Override
    public IntArray newIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
        return this.newDynamicIntArray(ChunkedNumberArrayFactory.fractionOf(length), defaultValue, memoryTracker);
    }

    @Override
    public ByteArray newByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
        return this.newDynamicByteArray(ChunkedNumberArrayFactory.fractionOf(length), defaultValue, memoryTracker);
    }

    private static long fractionOf(long length) {
        if (length < 10L) {
            return length;
        }
        return Long.min(length / 10L, 0x7FFFFFF7L);
    }

    @Override
    public IntArray newDynamicIntArray(long chunkSize, int defaultValue, MemoryTracker memoryTracker) {
        return new DynamicIntArray(this.delegate, chunkSize, defaultValue, memoryTracker);
    }

    @Override
    public LongArray newDynamicLongArray(long chunkSize, long defaultValue, MemoryTracker memoryTracker) {
        return new DynamicLongArray(this.delegate, chunkSize, defaultValue, memoryTracker);
    }

    @Override
    public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue, MemoryTracker memoryTracker) {
        return new DynamicByteArray(this.delegate, chunkSize, defaultValue, memoryTracker);
    }

    public String toString() {
        return "ChunkedNumberArrayFactory with delegate " + String.valueOf(this.delegate);
    }
}

